/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.SCM;
import hudson.scm.SVNAuthenticationManager;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import hudson.scm.subversion.Messages;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.ListBoxModel;
import hudson.util.MultipartFormDataParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class SubversionTagAction
extends AbstractScmTagAction
implements Describable<SubversionTagAction> {
    private final Map<SubversionSCM.SvnInfo, List<String>> tags = new CopyOnWriteMap.Tree();
    private static final Pattern TRUNK_BRANCH_MARKER = Pattern.compile("/(trunk|branches)(/|$)");

    SubversionTagAction(Run build, Collection<SubversionSCM.SvnInfo> svnInfos) {
        super(build);
        HashMap m = new HashMap();
        for (SubversionSCM.SvnInfo si : svnInfos) {
            m.put(si, new ArrayList());
        }
        this.tags.putAll(m);
    }

    public boolean hasTags() {
        return this.isTagged();
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        int nonNullTag = 0;
        for (List<String> v : this.tags.values()) {
            if (!v.isEmpty() && ++nonNullTag > 1) break;
        }
        if (nonNullTag == 0) {
            return Messages.SubversionTagAction_DisplayName_HasNoTag();
        }
        if (nonNullTag == 1) {
            return Messages.SubversionTagAction_DisplayName_HasATag();
        }
        return Messages.SubversionTagAction_DisplayName_HasTags();
    }

    public Map<SubversionSCM.SvnInfo, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Exported(name="tags")
    public List<TagInfo> getTagInfo() {
        ArrayList<TagInfo> data = new ArrayList<TagInfo>();
        for (Map.Entry<SubversionSCM.SvnInfo, List<String>> e : this.tags.entrySet()) {
            String module = e.getKey().toString();
            for (String url : e.getValue()) {
                data.add(new TagInfo(module, url));
            }
        }
        return data;
    }

    public boolean isTagged() {
        for (List<String> t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getTooltip() {
        String tag = null;
        for (List<String> v : this.tags.values()) {
            for (String s : v) {
                if (tag != null) {
                    return Messages.SubversionTagAction_Tooltip();
                }
                tag = s;
            }
        }
        if (tag != null) {
            return Messages.SubversionTagAction_Tooltip_OneTag(tag);
        }
        return null;
    }

    public String makeTagURL(SubversionSCM.SvnInfo si) {
        Matcher m = TRUNK_BRANCH_MARKER.matcher(si.url);
        if (!m.find()) {
            return null;
        }
        return si.url.substring(0, m.start()) + "/tags/" + this.getBuild().getProject().getName() + "-" + this.getBuild().getNumber();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<SubversionSCM.SvnInfo, String> newTags = new HashMap<SubversionSCM.SvnInfo, String>();
        int i = -1;
        for (SubversionSCM.SvnInfo e : this.tags.keySet()) {
            if (this.tags.size() > 1 && parser.get("tag" + ++i) == null) continue;
            newTags.put(e, parser.get("name" + i));
        }
        String credentialsId = parser.get("credentialsId");
        StandardCredentials upc = null;
        if (credentialsId != null) {
            Authentication a;
            Item context = (Item)req.findAncestorObject(Item.class);
            ArrayList<Authentication> authentications = new ArrayList<Authentication>(2);
            authentications.add(Jenkins.getAuthentication());
            if (context.hasPermission(Item.CONFIGURE)) {
                authentications.add(ACL.SYSTEM);
            }
            Iterator i$ = authentications.iterator();
            while (i$.hasNext() && (upc = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)(a = (Authentication)i$.next()), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})}))) == null) {
            }
        }
        new TagWorkerThread(newTags, upc, parser.get("comment")).start();
        rsp.sendRedirect(".");
    }

    public Permission getPermission() {
        return SubversionSCM.TAG;
    }

    public Descriptor<SubversionTagAction> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SubversionTagAction> {
        public String getDisplayName() {
            return null;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @AncestorInPath Run run) {
            Iterator<SubversionSCM.SvnInfo> i$;
            if (context == null || !context.hasPermission(SCM.TAG)) {
                return new ListBoxModel();
            }
            LinkedHashSet c = new LinkedHashSet();
            SubversionTagAction action = run != null ? (SubversionTagAction)run.getAction(SubversionTagAction.class) : null;
            List domainRequirements = Collections.emptyList();
            if (action != null && (i$ = action.getTags().keySet().iterator()).hasNext()) {
                SubversionSCM.SvnInfo info = i$.next();
                domainRequirements = URIRequirementBuilder.fromUri((String)info.url).build();
            }
            c.addAll(CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)Jenkins.getAuthentication(), domainRequirements));
            if (context.hasPermission(Item.CONFIGURE)) {
                c.addAll(CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements));
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}), c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TagWorkerThread
    extends TaskThread {
        private final Map<SubversionSCM.SvnInfo, String> tagSet;
        private final StandardCredentials upc;
        private final String comment;

        public TagWorkerThread(Map<SubversionSCM.SvnInfo, String> tagSet, StandardCredentials upc, String comment) {
            super((TaskAction)SubversionTagAction.this, TaskThread.ListenerAndText.forMemory((TaskAction)SubversionTagAction.this));
            this.tagSet = tagSet;
            this.upc = upc;
            this.comment = comment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void perform(TaskListener listener) {
            try {
                File configDir = SVNWCUtil.getDefaultConfigurationDirectory();
                SVNAuthenticationManager sam = new SVNAuthenticationManager(configDir, null, null);
                sam.setAuthenticationProvider(new CredentialsSVNAuthenticationProviderImpl((Credentials)this.upc));
                SvnClientManager cm = new SvnClientManager(SVNClientManager.newInstance((ISVNOptions)SubversionSCM.createDefaultSVNOptions(), (ISVNAuthenticationManager)sam));
                try {
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        PrintStream logger = listener.getLogger();
                        logger.println("Tagging " + e.getKey() + " to " + e.getValue());
                        try {
                            SVNURL src = SVNURL.parseURIDecoded((String)e.getKey().url);
                            SVNURL dst = SVNURL.parseURIDecoded((String)e.getValue());
                            SVNCopyClient svncc = cm.getCopyClient();
                            SVNRevision sourceRevision = SVNRevision.create((long)e.getKey().revision);
                            SVNCopySource csrc = new SVNCopySource(sourceRevision, sourceRevision, src);
                            svncc.doCopy(new SVNCopySource[]{csrc}, dst, false, true, false, this.comment, null);
                        }
                        catch (SVNException x) {
                            x.printStackTrace(listener.error("Failed to tag"));
                            cm.dispose();
                            return;
                        }
                    }
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        ((List)SubversionTagAction.this.tags.get(e.getKey())).add(e.getValue());
                    }
                    SubversionTagAction.this.getBuild().save();
                    SubversionTagAction.this.workerThread = null;
                }
                finally {
                    cm.dispose();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }

    @ExportedBean
    public static class TagInfo {
        private String module;
        private String url;

        private TagInfo(String module, String url) {
            this.module = module;
            this.url = url;
        }

        @Exported
        public String getModule() {
            return this.module;
        }

        @Exported
        public String getUrl() {
            return this.url;
        }
    }
}

