/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import hudson.util.QueryParameterMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private static Method IS_IGNORE_POST_COMMIT_HOOKS_METHOD;
    private static final Logger LOGGER;

    public SubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        QueryParameterMap query;
        String revParam;
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        BufferedReader r = new BufferedReader(req.getReader());
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Reading line: " + line);
                }
                affectedPath.add(line.substring(4));
                if (!line.startsWith("svnlook changed --revision ")) continue;
                String msg = "Expecting the output from the svnlook command but instead you just sent me the svnlook invocation command line: " + line;
                LOGGER.warning(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        if ((revParam = (query = new QueryParameterMap((HttpServletRequest)req)).get("rev")) == null) {
            revParam = req.getHeader("X-Hudson-Subversion-Revision");
        }
        long rev = -1L;
        if (revParam != null) {
            rev = Long.parseLong(revParam);
        }
        boolean listenerDidSomething = false;
        for (Listener listener : Jenkins.getInstance().getExtensionList(Listener.class)) {
            try {
                if (!listener.onNotify(this.uuid, rev, affectedPath)) continue;
                listenerDidSomething = true;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Listener " + listener.getClass().getName() + " threw an uncaught exception", t);
            }
        }
        if (!listenerDidSomething) {
            LOGGER.log(Level.WARNING, "No interest in change to repository UUID {0} found", this.uuid);
        }
        rsp.setStatus(200);
    }

    private static boolean doesIgnorePostCommitHooks(SCMTrigger trigger) {
        if (IS_IGNORE_POST_COMMIT_HOOKS_METHOD == null) {
            return false;
        }
        try {
            return (Boolean)IS_IGNORE_POST_COMMIT_HOOKS_METHOD.invoke((Object)trigger, (Object[])null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure when calling isIgnorePostCommitHooks", e);
            return false;
        }
    }

    static {
        try {
            IS_IGNORE_POST_COMMIT_HOOKS_METHOD = SCMTrigger.class.getMethod("isIgnorePostCommitHooks", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(SubversionRepositoryStatus.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class JobTriggerListenerImpl
    extends Listener {
        private JobProvider jobProvider = new JobProvider(){

            @Override
            public List<Job> getAllJobs() {
                return Jenkins.getInstance().getAllItems(Job.class);
            }
        };

        void setJobProvider(JobProvider jobProvider) {
            this.jobProvider = jobProvider;
        }

        @Override
        public boolean onNotify(UUID uuid, long rev, Set<String> affectedPath) {
            boolean scmFound = false;
            boolean triggerFound = false;
            boolean uuidFound = false;
            boolean pathFound = false;
            HashMap<String, UUID> remoteUUIDCache = new HashMap<String, UUID>();
            LOGGER.fine("Starting subversion locations checks for all jobs");
            for (Job p : this.jobProvider.getAllJobs()) {
                SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)p);
                if (scmTriggerItem == null || p instanceof AbstractProject && ((AbstractProject)p).isDisabled()) continue;
                try {
                    for (SCM scm : scmTriggerItem.getSCMs()) {
                        if (!(scm instanceof SubversionSCM)) continue;
                        scmFound = true;
                        SCMTrigger trigger = scmTriggerItem.getSCMTrigger();
                        if (trigger == null || SubversionRepositoryStatus.doesIgnorePostCommitHooks(trigger)) continue;
                        triggerFound = true;
                        SubversionSCM sscm = (SubversionSCM)scm;
                        ArrayList<SubversionSCM.SvnInfo> infos = new ArrayList<SubversionSCM.SvnInfo>();
                        boolean projectMatches = false;
                        for (SubversionSCM.ModuleLocation loc : sscm.getProjectLocations(p)) {
                            String n;
                            String url = loc.getURL();
                            String repositoryRootPath = null;
                            UUID remoteUUID = null;
                            for (Map.Entry e : remoteUUIDCache.entrySet()) {
                                if (!url.startsWith((String)e.getKey())) continue;
                                remoteUUID = (UUID)e.getValue();
                                repositoryRootPath = SVNURL.parseURIDecoded((String)((String)e.getKey())).getPath();
                                LOGGER.finer("Using cached uuid for module location " + url + " of job " + p);
                                break;
                            }
                            if (remoteUUID == null) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("Could not find " + loc.getURL() + " in " + remoteUUIDCache.keySet().toString());
                                }
                                remoteUUID = loc.getUUID(p, scm);
                                SVNURL repositoryRoot = loc.getRepositoryRoot(p, scm);
                                repositoryRootPath = repositoryRoot.getPath();
                                remoteUUIDCache.put(repositoryRoot.toString(), remoteUUID);
                            }
                            if (!remoteUUID.equals(uuid)) continue;
                            uuidFound = true;
                            String m = loc.getSVNURL().getPath();
                            if (!m.startsWith(n = repositoryRootPath)) continue;
                            String remaining = m.substring(n.length());
                            if (remaining.startsWith("/")) {
                                remaining = remaining.substring(1);
                            }
                            String remainingSlash = remaining + '/';
                            if (rev != -1L) {
                                infos.add(new SubversionSCM.SvnInfo(loc.getURL(), rev));
                            }
                            for (String path : affectedPath) {
                                if (!path.equals(remaining) && !path.startsWith(remainingSlash) && remaining.length() != 0) continue;
                                projectMatches = true;
                                pathFound = true;
                            }
                        }
                        if (!projectMatches) continue;
                        LOGGER.fine("Scheduling the immediate polling of " + p);
                        RevisionParameterAction[] actions = infos.isEmpty() ? new RevisionParameterAction[]{} : new RevisionParameterAction[]{new RevisionParameterAction(infos)};
                        trigger.run((Action[])actions);
                    }
                }
                catch (SVNException e) {
                    LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
                }
            }
            LOGGER.fine("Ended subversion locations checks for all jobs");
            if (!scmFound) {
                LOGGER.warning("No subversion jobs found");
            } else if (!triggerFound) {
                LOGGER.warning("No subversion jobs using SCM polling or all jobs using SCM polling are ignoring post-commit hooks");
            } else if (!uuidFound) {
                LOGGER.warning("No subversion jobs using repository: " + uuid);
            } else if (!pathFound) {
                LOGGER.fine("No jobs found matching the modified files");
            }
            return scmFound;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener
    implements ExtensionPoint {
        public abstract boolean onNotify(UUID var1, long var2, Set<String> var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface JobProvider {
        public List<Job> getAllJobs();
    }
}

