/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class UpdateWithRevertUpdater
extends WorkspaceUpdater {
    private static final long serialVersionUID = 485917115133281105L;

    @DataBoundConstructor
    public UpdateWithRevertUpdater() {
    }

    @Override
    public WorkspaceUpdater.UpdateTask createTask(int workspaceFormat) {
        return new TaskImpl(workspaceFormat);
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.UpdateWithRevertUpdater_DisplayName();
        }
    }

    public static class TaskImpl
    extends UpdateUpdater.TaskImpl {
        private static final long serialVersionUID = -8562813147341259328L;

        public TaskImpl(int workspaceFormat) {
            super(workspaceFormat);
        }

        @Override
        protected void preUpdate(SubversionSCM.ModuleLocation module, File local) throws SVNException, IOException {
            this.listener.getLogger().println("Reverting " + local + " to depth " + module.getDepthOption() + " with ignoreExternals: " + module.isIgnoreExternalsOption());
            SVNWCClient svnwc = this.manager.getWCClient();
            svnwc.setIgnoreExternals(module.isIgnoreExternalsOption());
            svnwc.doRevert(new File[]{local.getCanonicalFile()}, module.getSvnDepthForRevert(), null);
        }
    }
}

