/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.log.Logger;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.CompareAgainstBaselineCallable;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.DefaultSVNLogFilter;
import hudson.scm.EnvVarsUtils;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.PerJobCredentialStore;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.SVNAuthStoreHandlerImpl;
import hudson.scm.SVNAuthenticationManager;
import hudson.scm.SVNLogFilter;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionChangeLogBuilder;
import hudson.scm.SubversionChangeLogParser;
import hudson.scm.SubversionCredentialProvider;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionTagAction;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.scm.SvnClientManager;
import hudson.scm.SvnExternalsFileManager;
import hudson.scm.UserProvidedCredential;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SvnHelper;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.UpdateWithRevertUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import hudson.util.MultipartFormDataParser;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.stream.StreamResult;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.scm.impl.subversion.RemotableSVNErrorMessage;
import jenkins.util.JenkinsJVM;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="TODO needs triage")
public class SubversionSCM
extends SCM {
    private ModuleLocation[] locations = new ModuleLocation[0];
    @CheckForNull
    private List<AdditionalCredentials> additionalCredentials;
    private final SubversionRepositoryBrowser browser;
    private String excludedRegions;
    private String includedRegions;
    private String excludedUsers;
    private String excludedRevprop;
    private String excludedCommitMessages;
    private WorkspaceUpdater workspaceUpdater;
    @Deprecated
    private String modules;
    @Deprecated
    private Boolean useUpdate;
    @Deprecated
    private Boolean doRevert;
    private boolean ignoreDirPropChanges;
    private boolean filterChangelog;
    private boolean quietOperation;
    private transient Map<Job, List<External>> projectExternalsCache;
    private transient boolean pollFromMaster = POLL_FROM_MASTER;
    private static final transient SecureRandom RANDOM = new SecureRandom();
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SubversionSCM.class.getName());
    public static final int DEFAULT_TIMEOUT = Integer.getInteger(SubversionSCM.class.getName() + ".timeout", 3600000);
    private static boolean POLL_FROM_MASTER = Boolean.getBoolean(SubversionSCM.class.getName() + ".pollFromMaster");
    public static final String CONFIG_DIR = System.getProperty(SubversionSCM.class.getName() + ".configDir");

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        this(remoteLocations, localLocations, useUpdate, browser, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(ModuleLocation.parse(remoteLocations, localLocations, null, null), useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(ModuleLocation.parse(remoteLocations, localLocations, null, null), useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(locations, useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, doRevert, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        this(locations, useUpdate ? (doRevert ? new UpdateWithRevertUpdater() : new UpdateUpdater()) : new CheckoutUpdater(), browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions);
    }

    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        this(locations, workspaceUpdater, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions, false);
    }

    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions, boolean ignoreDirPropChanges) {
        this(locations, workspaceUpdater, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions, ignoreDirPropChanges, false, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions, boolean ignoreDirPropChanges, boolean filterChangelog, List<AdditionalCredentials> additionalCredentials) {
        this(locations, workspaceUpdater, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions, ignoreDirPropChanges, filterChangelog, additionalCredentials, false);
    }

    @DataBoundConstructor
    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions, boolean ignoreDirPropChanges, boolean filterChangelog, List<AdditionalCredentials> additionalCredentials, boolean quietOperation) {
        Iterator<ModuleLocation> itr = locations.iterator();
        while (itr.hasNext()) {
            ModuleLocation ml = itr.next();
            String remote = Util.fixEmptyAndTrim((String)ml.remote);
            if (remote != null) continue;
            itr.remove();
        }
        this.locations = locations.toArray(new ModuleLocation[0]);
        this.additionalCredentials = additionalCredentials == null ? null : new ArrayList<AdditionalCredentials>(additionalCredentials);
        this.workspaceUpdater = workspaceUpdater;
        this.browser = browser;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.excludedRevprop = excludedRevprop;
        this.excludedCommitMessages = excludedCommitMessages;
        this.includedRegions = includedRegions;
        this.ignoreDirPropChanges = ignoreDirPropChanges;
        this.filterChangelog = filterChangelog;
        this.quietOperation = quietOperation;
    }

    public SubversionSCM(String svnUrl) {
        this(svnUrl, null, ".");
    }

    public SubversionSCM(String svnUrl, String local) {
        this(svnUrl, null, local);
    }

    public SubversionSCM(String svnUrl, String credentialId, String local) {
        this(new String[]{svnUrl}, new String[]{credentialId}, new String[]{local});
    }

    public SubversionSCM(String svnUrl, String credentialId, String local, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser) {
        this(ModuleLocation.parse(new String[]{svnUrl}, new String[]{credentialId}, new String[]{local}, null, null, null), workspaceUpdater, browser, null, null, null, null, null, false, false, null, false);
    }

    public SubversionSCM(String[] svnUrls, String[] locals) {
        this(svnUrls, null, locals);
    }

    public SubversionSCM(String[] svnUrls, String[] credentialIds, String[] locals) {
        this(ModuleLocation.parse(svnUrls, credentialIds, locals, null, null, null), true, false, null, null, null, null, null);
    }

    public String getModules() {
        return null;
    }

    @Exported
    public ModuleLocation[] getLocations() {
        return this.getLocations(null, null);
    }

    public String getKey() {
        StringBuilder b = new StringBuilder("svn");
        for (ModuleLocation loc : this.getLocations()) {
            b.append(' ').append(loc.getURL());
        }
        return b.toString();
    }

    public List<AdditionalCredentials> getAdditionalCredentials() {
        ArrayList<AdditionalCredentials> result = new ArrayList<AdditionalCredentials>();
        if (this.additionalCredentials != null) {
            result.addAll(this.additionalCredentials);
        }
        return result;
    }

    @Exported
    public WorkspaceUpdater getWorkspaceUpdater() {
        if (this.workspaceUpdater != null) {
            return this.workspaceUpdater;
        }
        if (this.useUpdate != null && !this.useUpdate.booleanValue()) {
            return new CheckoutUpdater();
        }
        if (this.doRevert != null && this.doRevert.booleanValue()) {
            return new UpdateWithRevertUpdater();
        }
        return new UpdateUpdater();
    }

    public void setWorkspaceUpdater(WorkspaceUpdater workspaceUpdater) {
        this.workspaceUpdater = workspaceUpdater;
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        return this.getLocations(null, (Run<?, ?>)build);
    }

    public ModuleLocation[] getLocations(EnvVars env, Run<?, ?> build) {
        EnvVars env2;
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[0]);
            this.modules = null;
        }
        if (env == null && build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        EnvVars envVars = env2 = env != null ? new EnvVars(env) : new EnvVars();
        if (build instanceof AbstractBuild) {
            env2.putAll(((AbstractBuild)build).getBuildVariables());
        }
        EnvVars.resolve((Map)env2);
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(env2);
        }
        return outLocations;
    }

    public ModuleLocation[] getProjectLocations(Job project) throws IOException {
        List<External> projectExternals = this.getExternals(project);
        ModuleLocation[] configuredLocations = this.getLocations();
        if (projectExternals.isEmpty()) {
            return configuredLocations;
        }
        ArrayList<ModuleLocation> allLocations = new ArrayList<ModuleLocation>(configuredLocations.length + projectExternals.size());
        allLocations.addAll(Arrays.asList(configuredLocations));
        for (External external : projectExternals) {
            allLocations.add(new ModuleLocation(external.url, external.path));
        }
        return allLocations.toArray(new ModuleLocation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<External> getExternals(Job context) throws IOException {
        List<External> projectExternals;
        Map<Job, List<External>> projectExternalsCache;
        Map<Job, List<External>> map = projectExternalsCache = this.getProjectExternalsCache();
        synchronized (map) {
            projectExternals = projectExternalsCache.get(context);
        }
        if (projectExternals == null) {
            projectExternals = SvnExternalsFileManager.parseExternalsFile(context);
            map = projectExternalsCache;
            synchronized (map) {
                if (!projectExternalsCache.containsKey(context)) {
                    projectExternalsCache.put(context, projectExternals);
                }
            }
        }
        return projectExternals;
    }

    @Exported
    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return this.includedRegions == null || this.includedRegions.trim().equals("") ? null : this.includedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        if (included != null) {
            Pattern[] patterns = new Pattern[included.length];
            int i = 0;
            for (String includedRegion : included) {
                patterns[i++] = Pattern.compile(includedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    @Exported
    public String getExcludedRevprop() {
        return this.excludedRevprop;
    }

    private String getExcludedRevpropNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.getExcludedRevprop());
        if (s != null) {
            return s;
        }
        return this.getDescriptor().getGlobalExcludedRevprop();
    }

    @Exported
    public String getExcludedCommitMessages() {
        return this.excludedCommitMessages;
    }

    public String[] getExcludedCommitMessagesNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedCommitMessages);
        return s == null ? new String[]{} : s.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedCommitMessagesPatterns() {
        String[] excluded = this.getExcludedCommitMessagesNormalized();
        Pattern[] patterns = new Pattern[excluded.length];
        int i = 0;
        for (String excludedCommitMessage : excluded) {
            patterns[i++] = Pattern.compile(excludedCommitMessage);
        }
        return patterns;
    }

    @Exported
    public boolean isIgnoreDirPropChanges() {
        return this.ignoreDirPropChanges;
    }

    @Exported
    public boolean isFilterChangelog() {
        return this.filterChangelog;
    }

    @Exported
    public boolean isQuietOperation() {
        return this.quietOperation;
    }

    public void setQuietOperation(boolean quietOperation) {
        this.quietOperation = quietOperation;
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        ModuleLocation[] svnLocations = this.getLocations(new EnvVars(env), build);
        try {
            Map<String, Long> revisions = this.parseSvnRevisionFile(build);
            Set<String> knownURLs = revisions.keySet();
            if (svnLocations.length == 1) {
                String url = svnLocations[0].getURL();
                Long rev = revisions.get(url);
                if (rev != null) {
                    env.put("SVN_REVISION", rev.toString());
                    env.put("SVN_URL", url);
                } else if (!knownURLs.isEmpty()) {
                    LOGGER.log(Level.WARNING, "no revision found corresponding to {0}; known: {1}", new Object[]{url, knownURLs});
                }
            }
            for (int i = 0; i < svnLocations.length; ++i) {
                String url = svnLocations[i].getURL();
                Long rev = revisions.get(url);
                if (rev != null) {
                    env.put("SVN_REVISION_" + (i + 1), rev.toString());
                    env.put("SVN_URL_" + (i + 1), url);
                    continue;
                }
                if (knownURLs.isEmpty()) continue;
                LOGGER.log(Level.WARNING, "no revision found corresponding to {0}; known: {1}", new Object[]{url, knownURLs});
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "error building environment variables", e);
        }
    }

    private void calcChangeLog(Run<?, ?> build, FilePath workspace, File changelogFile, SCMRevisionState baseline, TaskListener listener, Map<String, List<External>> externalsMap, EnvVars env) throws IOException, InterruptedException {
        boolean created;
        if (baseline == null) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
            return;
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));){
            created = new SubversionChangeLogBuilder(build, workspace, (SVNRevisionState)baseline, env, listener, this).run(externalsMap, new StreamResult(os));
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
    }

    static Map<String, Long> parseRevisionFile(Run<?, ?> build) throws IOException {
        return SubversionSCM.parseRevisionFile(build, true, false);
    }

    Map<String, Long> parseSvnRevisionFile(Run<?, ?> build) throws IOException {
        return SubversionSCM.parseRevisionFile(build);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="TODO needs triage")
    static Map<String, Long> parseRevisionFile(Run<?, ?> build, boolean findClosest, boolean prunePinnedExternals) throws IOException {
        File file;
        HashMap<String, Long> revisions = new HashMap<String, Long>();
        HashMap<String, Long> pinnedRevisions = new HashMap<String, Long>();
        if (findClosest) {
            for (Run b = build; b != null; b = b.getPreviousBuild()) {
                if (!SubversionSCM.getRevisionFile(b).exists()) continue;
                build = b;
                break;
            }
        }
        if (!(file = SubversionSCM.getRevisionFile(build)).exists()) {
            return revisions;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                int index;
                boolean isPinned = false;
                int indexLast = line.length();
                if (line.lastIndexOf("::p") == indexLast - 3) {
                    isPinned = true;
                    indexLast -= 3;
                }
                if ((index = line.lastIndexOf(47)) < 0) continue;
                try {
                    Long oldRevision;
                    String url = line.substring(0, index);
                    long revision = Long.parseLong(line.substring(index + 1, indexLast));
                    if (isPinned) {
                        if (prunePinnedExternals || (oldRevision = (Long)pinnedRevisions.get(url)) != null) continue;
                        pinnedRevisions.put(url, revision);
                        continue;
                    }
                    oldRevision = (Long)revisions.get(url);
                    if (oldRevision != null && oldRevision <= revision) continue;
                    revisions.put(url, revision);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, "Error parsing line " + line, e);
                }
            }
            for (Map.Entry rev : pinnedRevisions.entrySet()) {
                if (revisions.containsKey(rev.getKey())) continue;
                revisions.put((String)rev.getKey(), (Long)rev.getValue());
            }
            return revisions;
        }
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="TODO needs triage")
    public void checkout(Run build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        if (build instanceof AbstractBuild) {
            EnvVarsUtils.overrideAll(env, ((AbstractBuild)build).getBuildVariables());
        }
        Map<String, List<External>> externalsMap = this.checkout(build, workspace, listener, env);
        ArrayList<External> externalsForAll = new ArrayList<External>();
        if (externalsMap != null) {
            for (String moduleLocationRemote : externalsMap.keySet()) {
                externalsForAll.addAll((Collection<External>)externalsMap.get(moduleLocationRemote));
            }
        }
        List pList = (List)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, listener, externalsForAll, env));
        List<SvnInfo> revList = pList.stream().map(svnInfoP -> svnInfoP.info).collect(Collectors.toList());
        try (PrintWriter w = new PrintWriter(new FileOutputStream(SubversionSCM.getRevisionFile(build)));){
            for (SvnInfoP p : pList) {
                if (p.pinned) {
                    w.println(p.info.url + '/' + p.info.revision + "::p");
                    continue;
                }
                w.println(p.info.url + '/' + p.info.revision);
            }
        }
        SvnExternalsFileManager.writeExternalsFile(build.getParent(), externalsForAll);
        Map<Job, List<External>> projectExternalsCache = this.getProjectExternalsCache();
        Map<Job, List<External>> map = projectExternalsCache;
        synchronized (map) {
            projectExternalsCache.put(build.getParent(), externalsForAll);
        }
        boolean scmChangesAlreadyProcessed = build.getActions(SubversionTagAction.class).stream().anyMatch(existingTagAction -> CollectionUtils.isEqualCollection(existingTagAction.getTags().keySet(), (Collection)revList));
        if (changelogFile != null && !scmChangesAlreadyProcessed) {
            build.addAction((Action)new SubversionTagAction(build, revList));
            this.calcChangeLog(build, workspace, changelogFile, baseline, listener, externalsMap, env);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="TODO needs triage")
    private Map<String, List<External>> checkout(Run build, FilePath workspace, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        if (this.repositoryLocationsNoLongerExist(build, listener, env)) {
            Run lsb = build.getParent().getLastSuccessfulBuild();
            if (build instanceof AbstractBuild && lsb != null && build.getNumber() - lsb.getNumber() > 10 && build.getTimestamp().getTimeInMillis() - lsb.getTimestamp().getTimeInMillis() > TimeUnit.DAYS.toMillis(1L)) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getParent().getName() + ", project will be disabled.");
                this.disableProject(((AbstractBuild)build).getProject(), listener);
            }
            return null;
        }
        HashMap<String, List<External>> externalsMap = new HashMap<String, List<External>>();
        LinkedHashSet<String> unauthenticatedRealms = new LinkedHashSet<String>();
        for (ModuleLocation location : this.getLocations(env, build)) {
            CheckOutTask checkOutTask = new CheckOutTask(new CheckOutUpdateTask(build, this, location, build.getTimestamp().getTime(), listener, env, this.quietOperation));
            ArrayList externals = new ArrayList((Collection)workspace.act((FilePath.FileCallable)checkOutTask));
            externalsMap.put(location.remote, externals);
            unauthenticatedRealms.addAll(checkOutTask.getUnauthenticatedRealms());
        }
        if (this.additionalCredentials != null) {
            for (AdditionalCredentials c : this.additionalCredentials) {
                unauthenticatedRealms.remove(c.getRealm());
            }
        }
        if (!unauthenticatedRealms.isEmpty()) {
            listener.getLogger().println("WARNING: The following realms could not be authenticated:");
            for (String realm : unauthenticatedRealms) {
                listener.getLogger().println(" * " + realm);
            }
            if (build == build.getParent().getLastBuild()) {
                if (this.additionalCredentials == null) {
                    this.additionalCredentials = new ArrayList<AdditionalCredentials>();
                }
                for (String realm : unauthenticatedRealms) {
                    this.additionalCredentials.add(new AdditionalCredentials(realm, null));
                }
                try {
                    listener.getLogger().println("Adding missing realms to configuration...");
                    build.getParent().save();
                    listener.getLogger().println("Updated project configuration saved.");
                }
                catch (IOException e) {
                    listener.getLogger().println("Could not update project configuration: " + e.getMessage());
                }
            }
        }
        return externalsMap;
    }

    private synchronized Map<Job, List<External>> getProjectExternalsCache() {
        if (this.projectExternalsCache == null) {
            this.projectExternalsCache = new WeakHashMap<Job, List<External>>();
        }
        return this.projectExternalsCache;
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        return SubversionSCM.createClientManager(authProvider, SubversionSCM.descriptor().isStoreAuthToDisk(), SubversionSCM.descriptor().getWorkspaceFormat()).getCore();
    }

    public static SvnClientManager createClientManager(ISVNAuthenticationProvider authProvider, boolean storeAuthToDisk, int workspaceFormat) {
        ISVNAuthenticationManager sam = SubversionSCM.createSvnAuthenticationManager(authProvider);
        return new SvnClientManager(SVNClientManager.newInstance((ISVNOptions)SubversionSCM.createDefaultSVNOptions(storeAuthToDisk), (ISVNAuthenticationManager)sam), workspaceFormat);
    }

    @Deprecated
    public static SvnClientManager createClientManager(ISVNAuthenticationProvider authProvider) {
        if (JenkinsJVM.isJenkinsJVM()) {
            return SubversionSCM.createClientManager(authProvider, SubversionSCM.descriptor().isStoreAuthToDisk(), SubversionSCM.descriptor().getWorkspaceFormat());
        }
        return SubversionSCM.createClientManager(authProvider, true, 8);
    }

    public static DefaultSVNOptions createDefaultSVNOptions(boolean storeAuthToDisk) {
        DefaultSVNOptions defaultOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        if (defaultOptions != null) {
            defaultOptions.setAuthStorageEnabled(storeAuthToDisk);
        }
        return defaultOptions;
    }

    public static ISVNAuthenticationManager createSvnAuthenticationManager(ISVNAuthenticationProvider authProvider) {
        File configDir = CONFIG_DIR != null ? new File(CONFIG_DIR) : SVNWCUtil.getDefaultConfigurationDirectory();
        SVNAuthenticationManager sam = new SVNAuthenticationManager(configDir, null, null);
        sam.setAuthenticationProvider(authProvider);
        SVNAuthStoreHandlerImpl.install((ISVNAuthenticationManager)sam);
        return sam;
    }

    public static SVNClientManager createSvnClientManager(AbstractProject context) {
        return SubversionSCM.createClientManager(context).getCore();
    }

    public static SvnClientManager createClientManager(AbstractProject context) {
        return new SvnClientManager(SubversionSCM.createSvnClientManager(SubversionSCM.descriptor().createAuthenticationProvider(context)), SubversionSCM.descriptor().getWorkspaceFormat());
    }

    public ISVNAuthenticationProvider createAuthenticationProvider(Job<?, ?> inContextOf, ModuleLocation location, TaskListener listener) {
        return CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider(inContextOf, this, location, listener);
    }

    @Deprecated
    public ISVNAuthenticationProvider createAuthenticationProvider(Job<?, ?> inContextOf, ModuleLocation location) {
        return this.createAuthenticationProvider(inContextOf, location, TaskListener.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider, boolean storeAuthToDisk, int workspaceFormat) throws SVNException {
        SvnClientManager manager = SubversionSCM.createClientManager(authProvider, storeAuthToDisk, workspaceFormat);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(Run build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    @Deprecated
    public static File getRevisionFile(AbstractBuild build) {
        return SubversionSCM.getRevisionFile((Run)build);
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Map<String, Long> wsRev = SubversionSCM.parseRevisionFile(build, true, true);
        return new SVNRevisionState(wsRev);
    }

    private boolean isPollFromMaster() {
        return this.pollFromMaster;
    }

    void setPollFromMaster(boolean pollFromMaster) {
        this.pollFromMaster = pollFromMaster;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        SVNRevisionState baseline = _baseline instanceof SVNRevisionState ? (SVNRevisionState)_baseline : (project.getLastBuild() != null ? (SVNRevisionState)this.calcRevisionsFromBuild(project.getLastBuild(), (FilePath)(launcher != null ? workspace : null), launcher, listener) : new SVNRevisionState(null));
        if (project.getLastBuild() == null) {
            listener.getLogger().println(Messages.SubversionSCM_pollChanges_noBuilds());
            return PollingResult.BUILD_NOW;
        }
        String nodeName = "master";
        LocalChannel channel = null;
        if (workspace != null && !this.isPollFromMaster() && (channel = workspace.getChannel()) != null && channel instanceof Channel) {
            nodeName = ((Channel)channel).getName();
        }
        if (channel == null) {
            channel = FilePath.localChannel;
        }
        Object node = nodeName.equals("master") ? Jenkins.getInstance() : Jenkins.getInstance().getNode(nodeName);
        EnvVars env = project.getEnvironment((Node)node, listener);
        Run lastCompletedBuild = project.getLastCompletedBuild();
        if (lastCompletedBuild != null) {
            if (project instanceof AbstractProject && this.repositoryLocationsNoLongerExist(lastCompletedBuild, listener, env)) {
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationsNoLongerExist(project));
                this.disableProject((AbstractProject)project, listener);
                return PollingResult.NO_CHANGES;
            }
            for (ModuleLocation loc : this.getLocations(env, lastCompletedBuild)) {
                String url;
                try {
                    url = loc.getSVNURL().toDecodedString();
                }
                catch (SVNException ex) {
                    listener.error(Messages.SubversionSCM_pollChanges_exception(loc.getURL()));
                    return PollingResult.BUILD_NOW;
                }
                if (baseline.revisions.containsKey(url)) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationNotInWorkspace(url));
                return PollingResult.BUILD_NOW;
            }
        }
        SVNLogHandler logHandler = new SVNLogHandler(this.createSVNLogFilter(), listener);
        LinkedHashMap<String, ISVNAuthenticationProvider> authProviders = new LinkedHashMap<String, ISVNAuthenticationProvider>();
        for (ModuleLocation loc : this.getLocations(env, null)) {
            String url;
            try {
                url = loc.getExpandedLocation(project).getSVNURL().toDecodedString();
            }
            catch (SVNException ex) {
                ex.printStackTrace(listener.error(Messages.SubversionSCM_pollChanges_exception(loc.getURL())));
                return PollingResult.BUILD_NOW;
            }
            authProviders.put(url, this.createAuthenticationProvider(project, loc, listener));
        }
        ISVNAuthenticationProvider defaultAuthProvider = this.createAuthenticationProvider(project, null, listener);
        return (PollingResult)channel.call((Callable)new CompareAgainstBaselineCallable(baseline, logHandler, project.getName(), listener, defaultAuthProvider, authProviders, nodeName));
    }

    public SVNLogFilter createSVNLogFilter() {
        return new DefaultSVNLogFilter(this.getExcludedRegionsPatterns(), this.getIncludedRegionsPatterns(), this.getExcludedUsersNormalized(), this.getExcludedRevpropNormalized(), this.getExcludedCommitMessagesPatterns(), this.isIgnoreDirPropChanges());
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionChangeLogParser(this.ignoreDirPropChanges);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].getLocalDir());
        }
        return workspace;
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        EnvVars env;
        if (build == null) {
            return this.getModuleRoot(workspace);
        }
        LogTaskListener listener = new LogTaskListener(LOGGER, Level.WARNING);
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.getLocations().length > 0) {
            return this._getModuleRoot(workspace, this.getLocations()[0].getLocalDir(), env);
        }
        return workspace;
    }

    @Deprecated
    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].getLocalDir());
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public FilePath[] getModuleRoots(FilePath workspace, AbstractBuild build) {
        EnvVars env;
        if (build == null) {
            return this.getModuleRoots(workspace);
        }
        LogTaskListener listener = new LogTaskListener(LOGGER, Level.WARNING);
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = this._getModuleRoot(workspace, moduleLocations[i].getLocalDir(), env);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace, build)};
    }

    FilePath _getModuleRoot(FilePath workspace, String localDir, EnvVars env) {
        return workspace.child(env.expand(localDir));
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    @Initializer(after=InitMilestone.JOB_LOADED, before=InitMilestone.COMPLETED)
    public static void perJobCredentialsMigration() {
        SubversionSCM.descriptor().migratePerJobCredentials();
    }

    private static boolean isAuthenticationFailedError(SVNCancelException e) {
        if (String.valueOf(e.getMessage()).contains("No credential to try")) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause instanceof SVNCancelException) {
            return SubversionSCM.isAuthenticationFailedError((SVNCancelException)cause);
        }
        return false;
    }

    @NonNull
    public static DescriptorImpl descriptor() {
        JenkinsJVM.checkJenkinsJVM();
        return (DescriptorImpl)((Object)ExtensionList.lookupSingleton(DescriptorImpl.class));
    }

    public boolean repositoryLocationsNoLongerExist(AbstractBuild<?, ?> build, TaskListener listener) {
        return this.repositoryLocationsNoLongerExist((Run<?, ?>)build, listener, null);
    }

    public boolean repositoryLocationsNoLongerExist(Run<?, ?> build, TaskListener listener, EnvVars env) {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(env, build)) {
            try {
                if (this.getDescriptor().checkRepositoryPath(build.getParent(), l.getSVNURL(), SubversionSCM.lookupCredentials((Item)build.getParent(), l.credentialsId, l.getSVNURL())) != SVNNodeKind.NONE) continue;
                out.println("Location '" + l.remote + "' does not exist");
                ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
                if (params != null) {
                    LOGGER.fine("Location could be expanded on build '" + build + "' parameters values:");
                    return false;
                }
                return true;
            }
            catch (SVNException e) {
                LOGGER.log(Level.FINE, "Location check failed", e);
            }
        }
        return false;
    }

    private void disableProject(@NonNull AbstractProject project, @NonNull TaskListener listener) throws IOException {
        if (project.supportsMakeDisabled()) {
            project.makeDisabled(true);
            listener.getLogger().println(Messages.SubversionSCM_disableProject_disabled());
        } else {
            listener.getLogger().println(Messages.SubversionSCM_disableProject_unsupported());
        }
    }

    public static void init(int workspaceFormat) {
        if (Boolean.getBoolean("hudson.spool-svn")) {
            DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, true, null));
        } else {
            DAVRepositoryFactory.setup();
        }
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (System.getProperty("svnkit.ssh2.persistent") == null) {
            System.setProperty("svnkit.ssh2.persistent", "false");
        }
        if (System.getProperty("svnkit.http.methods") == null) {
            System.setProperty("svnkit.http.methods", "Digest,Basic,NTLM,Negotiate");
        }
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SubversionWorkspaceSelector(workspaceFormat));
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        final Level lv = level;
        Logger.enabled = true;
        Logger.logger = new DebugLogger(){
            private final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SCPClient.class.getPackage().getName());

            public void log(int level, String className, String message) {
                this.LOGGER.log(lv, className + ' ' + message);
            }
        };
    }

    static boolean compareSVNAuthentications(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        try {
            return SubversionSCM.describeBean(a1).equals(SubversionSCM.describeBean(a2));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static Map describeBean(Object o) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Map m = PropertyUtils.describe((Object)o);
        for (Map.Entry entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof char[])) continue;
            char[] chars = (char[])v;
            entry.setValue(new String(chars));
        }
        return m;
    }

    private static SVNRevision getRevisionFromRemoteUrl(String remoteUrlPossiblyWithRevision) {
        int idx = remoteUrlPossiblyWithRevision.lastIndexOf(64);
        int slashIdx = remoteUrlPossiblyWithRevision.lastIndexOf(47);
        if (idx > 0 && idx > slashIdx) {
            String n = remoteUrlPossiblyWithRevision.substring(idx + 1);
            return SVNRevision.parse((String)n);
        }
        return null;
    }

    private static StandardCredentials lookupCredentials(Item context, String credentialsId, SVNURL repoURL) {
        return credentialsId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)repoURL.toString()).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static class AdditionalCredentials
    extends AbstractDescribableImpl<AdditionalCredentials> {
        @NonNull
        private final String realm;
        @CheckForNull
        private final String credentialsId;

        @DataBoundConstructor
        public AdditionalCredentials(@NonNull String realm, @CheckForNull String credentialsId) {
            realm.getClass();
            this.realm = realm;
            this.credentialsId = credentialsId;
        }

        @NonNull
        public String getRealm() {
            return this.realm;
        }

        @CheckForNull
        public String getCredentialsId() {
            return this.credentialsId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AdditionalCredentials)) {
                return false;
            }
            AdditionalCredentials that = (AdditionalCredentials)((Object)o);
            if (!this.realm.equals(that.realm)) {
                return false;
            }
            return Objects.equals(this.credentialsId, that.credentialsId);
        }

        public int hashCode() {
            int result = this.realm.hashCode();
            result = 31 * result + (this.credentialsId != null ? this.credentialsId.hashCode() : 0);
            return result;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<AdditionalCredentials> {
            @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="TODO needs triage")
            public String getDisplayName() {
                return null;
            }

            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String realm) {
                List domainRequirements;
                if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                    return new StandardListBoxModel();
                }
                if (realm == null) {
                    domainRequirements = Collections.emptyList();
                } else if (realm.startsWith("<") && realm.contains(">")) {
                    int index = realm.indexOf(62);
                    assert (index > 1);
                    domainRequirements = URIRequirementBuilder.fromUri((String)realm.substring(1, index).trim()).build();
                } else {
                    domainRequirements = Collections.emptyList();
                }
                return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements));
            }
        }
    }

    @ExportedBean
    public static final class ModuleLocation
    extends AbstractDescribableImpl<ModuleLocation>
    implements Serializable {
        @Exported
        public final String remote;
        public String credentialsId;
        @Exported
        public final String local;
        @Exported
        public final String depthOption;
        @Exported
        public boolean ignoreExternalsOption;
        @Exported
        public boolean cancelProcessOnExternalsFail;
        private volatile transient UUID repositoryUUID;
        private volatile transient SVNURL repositoryRoot;
        private static final long serialVersionUID = 1L;

        @Deprecated
        public ModuleLocation(String remote, String local) {
            this(remote, null, local, null, false, false);
        }

        void setCredentialsId(String id) {
            this.credentialsId = id;
        }

        @Deprecated
        public ModuleLocation(String remote, String local, String depthOption, boolean ignoreExternalsOption) {
            this(remote, null, local, depthOption, ignoreExternalsOption, false);
        }

        @Deprecated
        public ModuleLocation(String remote, String credentialsId, String local, String depthOption, boolean ignoreExternalsOption) {
            this(remote, credentialsId, local, depthOption, ignoreExternalsOption, false);
        }

        @DataBoundConstructor
        public ModuleLocation(String remote, String credentialsId, String local, String depthOption, boolean ignoreExternalsOption, boolean cancelProcessOnExternalsFail) {
            this.remote = Util.removeTrailingSlash((String)Util.fixNull((String)remote).trim());
            this.credentialsId = credentialsId;
            this.local = Util.fixEmptyAndTrim((String)local);
            this.depthOption = StringUtils.isEmpty((String)depthOption) ? SVNDepth.INFINITY.getName() : depthOption;
            this.ignoreExternalsOption = ignoreExternalsOption;
            this.cancelProcessOnExternalsFail = cancelProcessOnExternalsFail;
        }

        public ModuleLocation withRemote(String remote) {
            return new ModuleLocation(remote, this.credentialsId, this.local, this.depthOption, this.ignoreExternalsOption, this.cancelProcessOnExternalsFail);
        }

        public ModuleLocation withCredentialsId(String credentialsId) {
            return new ModuleLocation(this.remote, credentialsId, this.local, this.depthOption, this.ignoreExternalsOption, this.cancelProcessOnExternalsFail);
        }

        public ModuleLocation withLocal(String local) {
            return new ModuleLocation(this.remote, this.credentialsId, local, this.depthOption, this.ignoreExternalsOption, this.cancelProcessOnExternalsFail);
        }

        public ModuleLocation withDepthOption(String depthOption) {
            return new ModuleLocation(this.remote, this.credentialsId, this.local, depthOption, this.ignoreExternalsOption, this.cancelProcessOnExternalsFail);
        }

        public ModuleLocation withIgnoreExternalsOption(boolean ignoreExternalsOption) {
            return new ModuleLocation(this.remote, this.credentialsId, this.local, this.depthOption, ignoreExternalsOption, this.cancelProcessOnExternalsFail);
        }

        public ModuleLocation withCancelProcessOnExternalsFailed(boolean cancelProcessOnExternalsFailed) {
            return new ModuleLocation(this.remote, this.credentialsId, this.local, this.depthOption, this.ignoreExternalsOption, cancelProcessOnExternalsFailed);
        }

        public String getLocalDir() {
            if (this.local == null) {
                return SubversionSCM.getLastPathComponent(this.getURL());
            }
            return this.local;
        }

        public String getURL() {
            return SvnHelper.getUrlWithoutRevision(this.remote);
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIEncoded((String)this.getURL());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UUID getUUID(Job context, SCM scm) throws SVNException {
            if (this.repositoryUUID == null || this.repositoryRoot == null) {
                LOGGER.fine("UUID of " + this.remote + " not cached for " + context);
                ModuleLocation moduleLocation = this;
                synchronized (moduleLocation) {
                    SVNRepository r = this.openRepository(context, scm, false);
                    if (r.getRepositoryUUID(false) == null) {
                        r.testConnection();
                    }
                    this.repositoryUUID = UUID.fromString(r.getRepositoryUUID(false));
                    this.repositoryRoot = r.getRepositoryRoot(true);
                }
            }
            return this.repositoryUUID;
        }

        @Deprecated
        public UUID getUUID(AbstractProject context) throws SVNException {
            return this.getUUID((Job)context, context.getScm());
        }

        @Deprecated
        public SVNRepository openRepository(AbstractProject context) throws SVNException {
            return this.openRepository(context, true);
        }

        @Deprecated
        public SVNRepository openRepository(AbstractProject context, boolean keepConnection) throws SVNException {
            return this.openRepository((Job)context, context.getScm(), true);
        }

        public SVNRepository openRepository(Job context, SCM scm, boolean keepConnection) throws SVNException {
            SVNURL repoURL = this.getSVNURL();
            StandardCredentials creds = SubversionSCM.lookupCredentials((Item)context, this.credentialsId, repoURL);
            HashMap<String, Credentials> additional = new HashMap<String, Credentials>();
            if (creds == null) {
                List<AdditionalCredentials> additionalCredentialsList = ((SubversionSCM)scm).getAdditionalCredentials();
                for (AdditionalCredentials c : additionalCredentialsList) {
                    StandardCredentials cred;
                    String credentialsId = c.getCredentialsId();
                    if (credentialsId == null || (cred = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})}))) == null) continue;
                    additional.put(c.getRealm(), (Credentials)cred);
                }
            }
            if (keepConnection) {
                return SubversionSCM.descriptor().getRepository(context, repoURL, creds, additional, null);
            }
            return SubversionSCM.descriptor().getRepository(context, repoURL, creds, additional, new ISVNSession(){

                public boolean keepConnection(SVNRepository repository) {
                    return false;
                }

                public void saveCommitMessage(SVNRepository repository, long revision, String message) {
                }

                public String getCommitMessage(SVNRepository repository, long revision) {
                    return null;
                }

                public boolean hasCommitMessage(SVNRepository repository, long revision) {
                    return false;
                }
            });
        }

        @Deprecated
        public SVNURL getRepositoryRoot(AbstractProject context) throws SVNException {
            return this.getRepositoryRoot((Job)context, context.getScm());
        }

        @NonNull
        public SVNURL getRepositoryRoot(Job context, SCM scm) throws SVNException {
            this.getUUID(context, scm);
            return this.repositoryRoot;
        }

        public SVNRevision getRevision(SVNRevision defaultValue) {
            SVNRevision revision = SubversionSCM.getRevisionFromRemoteUrl(this.remote);
            return revision != null ? revision : defaultValue;
        }

        private String getExpandedRemote(AbstractBuild<?, ?> build) {
            String outRemote = this.remote;
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outRemote = parameters.substitute(build, this.remote);
            }
            return outRemote;
        }

        private String getExpandedLocalDir(AbstractBuild<?, ?> build) {
            String outLocalDir = this.getLocalDir();
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outLocalDir = parameters.substitute(build, this.getLocalDir());
            }
            return outLocalDir;
        }

        public String getDepthOption() {
            return this.depthOption;
        }

        private static SVNDepth getSvnDepth(String name) {
            return SVNDepth.fromString((String)name);
        }

        public SVNDepth getSvnDepthForUpdate() {
            return ModuleLocation.getSvnDepth(this.getDepthOption());
        }

        public SVNDepth getSvnDepthForCheckout() {
            if ("unknown".equals(this.getDepthOption())) {
                return SVNDepth.FILES;
            }
            if ("as-it-is-infinity".equals(this.getDepthOption())) {
                return SVNDepth.INFINITY;
            }
            return ModuleLocation.getSvnDepth(this.getDepthOption());
        }

        public SVNDepth getSvnDepthForRevert() {
            if ("unknown".equals(this.getDepthOption()) || "as-it-is-infinity".equals(this.getDepthOption())) {
                return SVNDepth.INFINITY;
            }
            return ModuleLocation.getSvnDepth(this.getDepthOption());
        }

        public boolean isIgnoreExternalsOption() {
            return this.ignoreExternalsOption;
        }

        public boolean isCancelProcessOnExternalsFail() {
            return this.cancelProcessOnExternalsFail;
        }

        public ModuleLocation getExpandedLocation(AbstractBuild<?, ?> build) {
            EnvVars env = new EnvVars(EnvVars.masterEnvVars);
            env.putAll(build.getBuildVariables());
            return this.getExpandedLocation(env);
        }

        public ModuleLocation getExpandedLocation(EnvVars env) {
            return new ModuleLocation(env.expand(this.remote), this.credentialsId, env.expand(this.getLocalDir()), this.getDepthOption(), this.isIgnoreExternalsOption(), this.isCancelProcessOnExternalsFail());
        }

        public String toString() {
            return this.remote;
        }

        @Deprecated
        public static List<ModuleLocation> parse(String[] remoteLocations, String[] localLocations, String[] depthOptions, boolean[] isIgnoreExternals) {
            return ModuleLocation.parse(remoteLocations, null, localLocations, depthOptions, isIgnoreExternals, null);
        }

        @Deprecated
        public static List<ModuleLocation> parse(String[] remoteLocations, String[] credentialIds, String[] localLocations, String[] depthOptions, boolean[] isIgnoreExternals) {
            return ModuleLocation.parse(remoteLocations, credentialIds, localLocations, depthOptions, isIgnoreExternals, null);
        }

        public static List<ModuleLocation> parse(String[] remoteLocations, String[] credentialIds, String[] localLocations, String[] depthOptions, boolean[] isIgnoreExternals, boolean[] cancelProcessOnExternalsFails) {
            ArrayList<ModuleLocation> modules = new ArrayList<ModuleLocation>();
            if (remoteLocations != null && localLocations != null) {
                int entries = Math.min(remoteLocations.length, localLocations.length);
                for (int i = 0; i < entries; ++i) {
                    String remoteLoc = Util.nullify((String)remoteLocations[i]);
                    if (remoteLoc == null) continue;
                    remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
                    modules.add(new ModuleLocation(remoteLoc, credentialIds != null && credentialIds.length > i ? credentialIds[i] : null, Util.nullify((String)localLocations[i]), depthOptions != null ? depthOptions[i] : null, isIgnoreExternals != null && isIgnoreExternals[i], cancelProcessOnExternalsFails != null && cancelProcessOnExternalsFails[i]));
                }
            }
            return modules;
        }

        public ModuleLocation getExpandedLocation(Job<?, ?> project) {
            String url;
            String returnURL = url = this.getURL();
            for (JobProperty property : project.getProperties().values()) {
                if (!(property instanceof ParametersDefinitionProperty)) continue;
                ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)property;
                for (String propertyName : pdp.getParameterDefinitionNames()) {
                    ParameterDefinition pd;
                    if (!url.contains(propertyName) || (pd = pdp.getParameterDefinition(propertyName)) == null) continue;
                    ParameterValue pv = pd.getDefaultParameterValue();
                    String replacement = "";
                    if (pv != null) {
                        replacement = String.valueOf(pv.createVariableResolver(null).resolve(propertyName));
                    }
                    returnURL = returnURL.replace("${" + propertyName + "}", replacement);
                    returnURL = returnURL.replace("$" + propertyName, replacement);
                }
            }
            return new ModuleLocation(returnURL, this.credentialsId, this.getLocalDir(), this.getDepthOption(), this.isIgnoreExternalsOption(), this.isCancelProcessOnExternalsFail());
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ModuleLocation> {
            @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="TODO needs triage")
            public String getDisplayName() {
                return null;
            }

            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote) {
                if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                    return new StandardListBoxModel();
                }
                return this.fillCredentialsIdItems(context, remote);
            }

            public ListBoxModel fillCredentialsIdItems(@CheckForNull Item context, String remote) {
                List domainRequirements = remote == null ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)remote.trim()).build();
                return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements));
            }

            @RequirePOST
            public FormValidation doCheckRemote(StaplerRequest req, @AncestorInPath Item context, @QueryParameter String remote) {
                String url = Util.fixEmptyAndTrim((String)remote);
                if (url == null) {
                    return FormValidation.error((String)Messages.SubversionSCM_doCheckRemote_required());
                }
                if (url.indexOf(36) != -1) {
                    return FormValidation.warning((String)"This repository URL is parameterized, syntax validation skipped");
                }
                try {
                    SVNURL.parseURIEncoded((String)url);
                }
                catch (SVNException svne) {
                    LOGGER.log(Level.SEVERE, svne.getMessage());
                    return FormValidation.error((String)Messages.SubversionSCM_doCheckRemote_invalidUrl());
                }
                return FormValidation.ok();
            }

            @RequirePOST
            public FormValidation doCheckCredentialsId(StaplerRequest req, @AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String value) {
                if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                    return FormValidation.ok();
                }
                return this.checkCredentialsId(req, context, remote, value);
            }

            public FormValidation checkCredentialsId(StaplerRequest req, @NonNull Item context, String remote, String value) {
                String url = Util.fixEmptyAndTrim((String)remote);
                if (url == null) {
                    return FormValidation.ok();
                }
                if (remote.indexOf(36) != -1) {
                    return FormValidation.warning((String)"The repository URL is parameterized, connection check skipped");
                }
                try {
                    SVNURL repoURL = SVNURL.parseURIEncoded((String)remote);
                    StandardCredentials credentials = SubversionSCM.lookupCredentials(context, value, repoURL);
                    SVNRepository repo = SubversionSCM.descriptor().getRepository(context, repoURL, credentials, Collections.emptyMap(), null);
                    String repoRoot = repo.getRepositoryRoot(true).toDecodedString();
                    String repoPath = repo.getLocation().toDecodedString().substring(repoRoot.length());
                    SVNPath path = new SVNPath(repoPath, true, true);
                    SVNNodeKind svnNodeKind = repo.checkPath(path.getTarget(), path.getPegRevision().getNumber());
                    if (svnNodeKind != SVNNodeKind.DIR) {
                        return FormValidation.error((String)"Credentials looks fine but the repository URL is invalid");
                    }
                }
                catch (SVNException e) {
                    LOGGER.log(Level.SEVERE, e.getErrorMessage().getMessage());
                    return FormValidation.error((String)"Unable to access the repository");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckLocal(@QueryParameter String value) throws IOException, ServletException {
                String v = Util.nullify((String)value);
                if (v == null) {
                    return FormValidation.ok();
                }
                if ((v = v.trim()).startsWith("/") || v.startsWith("\\") || v.startsWith("..") || v.matches("^[A-Za-z]:.*")) {
                    return FormValidation.error((String)"absolute path is not allowed");
                }
                return FormValidation.ok();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<SubversionSCM>
    implements ModelObject {
        private transient Map<String, Credential> credentials;
        private boolean mayHaveLegacyPerJobCredentials;
        private String globalExcludedRevprop = null;
        private int workspaceFormat = 8;
        private boolean validateRemoteUpToVar = false;
        private boolean storeAuthToDisk = true;
        private final transient RemotableSVNAuthenticationProviderImpl remotableProvider = new RemotableSVNAuthenticationProviderImpl();
        private static final Pattern USERNAME_PATTERN = Pattern.compile("([a-zA-Z0-9_-]+\\\\)?+([a-zA-Z0-9_-]+)");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() {
            super.load();
            if (this.credentials != null && !this.credentials.isEmpty()) {
                try (ACLContext oldContext = ACL.as((Authentication)ACL.SYSTEM);){
                    BulkChange bc = new BulkChange((Saveable)this);
                    try {
                        this.mayHaveLegacyPerJobCredentials = true;
                        CredentialsStore store = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
                        for (Map.Entry<String, Credential> e : this.credentials.entrySet()) {
                            this.migrateCredentials(store, e.getKey(), e.getValue());
                        }
                        this.save();
                        bc.commit();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Could not migrate stored credentials", e);
                    }
                    finally {
                        bc.abort();
                    }
                }
            }
        }

        void migratePerJobCredentials() {
            if (this.credentials == null && !this.mayHaveLegacyPerJobCredentials) {
                return;
            }
            boolean allOk = true;
            for (AbstractProject job : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                File jobCredentials = new File(job.getRootDir(), "subversion.credentials");
                if (!jobCredentials.isFile()) continue;
                try {
                    if (job.getScm() instanceof SubversionSCM) {
                        new PerJobCredentialStore(job).migrateCredentials(this);
                        job.save();
                    }
                    if (jobCredentials.delete()) continue;
                    LOGGER.log(Level.WARNING, "Could not remove legacy per-job credentials store file: {0}", jobCredentials);
                    allOk = false;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not migrate per-job credentials for " + job.getFullName(), e);
                    allOk = false;
                }
            }
            this.mayHaveLegacyPerJobCredentials = !allOk;
            this.save();
        }

        StandardCredentials migrateCredentials(CredentialsStore store, String legacyRealm, Credential legacyCredential) throws IOException {
            String url;
            Matcher matcher;
            StandardCredentials credential = legacyCredential.toCredentials(null, legacyRealm);
            if (credential != null) {
                return credential;
            }
            credential = legacyCredential.toCredentials(legacyRealm);
            if (store.isDomainsModifiable() && (matcher = Pattern.compile("\\s*<([^>]+)>.*").matcher(legacyRealm)).matches() && ((url = matcher.group(1)).startsWith("http:") || url.startsWith("svn:") || url.startsWith("https:") || url.startsWith("svn+ssh:"))) {
                List requirements = URIRequirementBuilder.fromUri((String)url).build();
                HostnameRequirement hostnameRequirement = null;
                SchemeRequirement schemeRequirement = null;
                for (Object r : requirements) {
                    if (hostnameRequirement == null && r instanceof HostnameRequirement) {
                        hostnameRequirement = (HostnameRequirement)r;
                    }
                    if (schemeRequirement == null && r instanceof SchemeRequirement) {
                        schemeRequirement = (SchemeRequirement)r;
                    }
                    if (schemeRequirement == null || hostnameRequirement == null) continue;
                    break;
                }
                Domain domain = null;
                if (hostnameRequirement != null) {
                    for (Domain d : store.getDomains()) {
                        HostnameSpecification spec = null;
                        for (DomainSpecification s : d.getSpecifications()) {
                            if (!(s instanceof HostnameSpecification)) continue;
                            spec = (HostnameSpecification)s;
                            break;
                        }
                        if (spec == null || !spec.test((DomainRequirement)hostnameRequirement).isMatch() || !d.test(requirements)) continue;
                        domain = d;
                        break;
                    }
                }
                if (domain == null) {
                    if (hostnameRequirement != null) {
                        ArrayList<Object> specs = new ArrayList<Object>();
                        specs.add(new HostnameSpecification(hostnameRequirement.getHostname(), null));
                        if (schemeRequirement != null) {
                            specs.add(new SchemeSpecification(schemeRequirement.getScheme()));
                        }
                        if (store.addDomain(domain = new Domain(hostnameRequirement.getHostname(), null, specs), new Credentials[]{credential})) {
                            return credential;
                        }
                    }
                } else if (store.addCredentials(domain, (Credentials)credential)) {
                    return credential;
                }
            }
            store.addCredentials(Domain.global(), (Credentials)credential);
            return credential;
        }

        public SCM newInstance(StaplerRequest staplerRequest, JSONObject jsonObject) throws Descriptor.FormException {
            return (SCM)super.newInstance(staplerRequest, jsonObject);
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public DescriptorImpl() {
            super(SubversionRepositoryBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public String getDisplayName() {
            return "Subversion";
        }

        public void setGlobalExcludedRevprop(String globalExcludedRevprop) {
            this.globalExcludedRevprop = globalExcludedRevprop;
        }

        public String getGlobalExcludedRevprop() {
            return this.globalExcludedRevprop;
        }

        public int getWorkspaceFormat() {
            if (this.workspaceFormat == 0) {
                return 8;
            }
            return this.workspaceFormat;
        }

        public void setWorkspaceFormat(int workspaceFormat) {
            this.workspaceFormat = workspaceFormat;
        }

        public boolean isValidateRemoteUpToVar() {
            return this.validateRemoteUpToVar;
        }

        public boolean isStoreAuthToDisk() {
            return this.storeAuthToDisk;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.globalExcludedRevprop = Util.fixEmptyAndTrim((String)req.getParameter("svn.global_excluded_revprop"));
            this.workspaceFormat = Integer.parseInt(req.getParameter("svn.workspaceFormat"));
            this.validateRemoteUpToVar = formData.containsKey((Object)"validateRemoteUpToVar");
            this.storeAuthToDisk = formData.containsKey((Object)"storeAuthToDisk");
            this.save();
            return super.configure(req, formData);
        }

        public boolean isBrowserReusable(SubversionSCM x, SubversionSCM y) {
            ModuleLocation[] yl;
            ModuleLocation[] xl = x.getLocations();
            if (xl.length != (yl = y.getLocations()).length) {
                return false;
            }
            for (int i = 0; i < xl.length; ++i) {
                if (xl[i].getURL().equals(yl[i].getURL())) continue;
                return false;
            }
            return true;
        }

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }

        @Deprecated
        public ISVNAuthenticationProvider createAuthenticationProvider(AbstractProject<?, ?> inContextOf) {
            SubversionSCM scm = null;
            if (inContextOf != null && inContextOf.getScm() instanceof SubversionSCM) {
                scm = (SubversionSCM)inContextOf.getScm();
            }
            return CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider(inContextOf, scm, null);
        }

        @Deprecated
        public ISVNAuthenticationProvider createAuthenticationProvider() {
            return CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider(null, null, null);
        }

        @POST
        public void doPostCredential(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
            StringWriter log = new StringWriter();
            PrintWriter logWriter = new PrintWriter(log);
            try (UserProvidedCredential upc = UserProvidedCredential.fromForm(req, parser);){
                this.postCredential(parser.get("url"), upc, logWriter);
                rsp.sendRedirect("credentialOK");
            }
            catch (SVNException e) {
                logWriter.println("FAILED: " + e.getErrorMessage());
                req.setAttribute("message", (Object)log.toString());
                req.setAttribute("pre", (Object)true);
                req.setAttribute("exception", (Object)e);
                rsp.forward((Object)Jenkins.getInstance(), "error", req);
            }
        }

        public void postCredential(String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(null, url, username, password, keyFile, logWriter);
        }

        public void postCredential(AbstractProject inContextOf, String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(url, new UserProvidedCredential(username, password, keyFile, inContextOf), logWriter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCredential(String url, UserProvidedCredential upc, PrintWriter logWriter) throws SVNException, IOException {
            JenkinsJVM.checkJenkinsJVM();
            SVNRepository repository = null;
            try {
                repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
                repository.setTunnelProvider((ISVNTunnelProvider)SubversionSCM.createDefaultSVNOptions(SubversionSCM.descriptor().isStoreAuthToDisk()));
                UserProvidedCredential userProvidedCredential = upc;
                Objects.requireNonNull(userProvidedCredential);
                UserProvidedCredential.AuthenticationManagerImpl authManager = new UserProvidedCredential.AuthenticationManagerImpl(userProvidedCredential, logWriter);
                authManager.setAuthenticationForced(true);
                repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
                repository.testConnection();
                authManager.checkIfProtocolCompleted();
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        @Deprecated
        @RequirePOST
        @CheckForNull
        public FormValidation doCheckRemote(StaplerRequest req, @AncestorInPath AbstractProject context, @QueryParameter String value, @QueryParameter String credentialsId) {
            ModuleLocation.DescriptorImpl d;
            Jenkins instance = Jenkins.getInstance();
            if (instance != null && (d = (ModuleLocation.DescriptorImpl)instance.getDescriptorByType(ModuleLocation.DescriptorImpl.class)) != null) {
                return d.doCheckCredentialsId(req, (Item)context, value, credentialsId);
            }
            return FormValidation.warning((String)"Unable to check remote.");
        }

        @Deprecated
        public SVNNodeKind checkRepositoryPath(AbstractProject context, SVNURL repoURL) throws SVNException {
            return this.checkRepositoryPath((Job)context, repoURL, null);
        }

        @Deprecated
        public SVNNodeKind checkRepositoryPath(Job context, SVNURL repoURL, StandardCredentials credentials) throws SVNException {
            return this.checkRepositoryPath((Item)context, repoURL, credentials);
        }

        public SVNNodeKind checkRepositoryPath(Item context, SVNURL repoURL, StandardCredentials credentials) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(context, repoURL, credentials, Collections.emptyMap(), null);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            catch (SVNException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "Could not check repository path {0} using credentials {1} ({2})");
                    lr.setThrown(e);
                    lr.setParameters(new Object[]{repoURL, credentials == null ? null : CredentialsNameProvider.name((Credentials)credentials), credentials});
                    LOGGER.log(lr);
                }
                throw e;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        @Deprecated
        protected SVNRepository getRepository(AbstractProject context, SVNURL repoURL) throws SVNException {
            return this.getRepository((Job)context, repoURL, null, Collections.emptyMap(), null);
        }

        @Deprecated
        protected SVNRepository getRepository(AbstractProject context, SVNURL repoURL, ISVNSession session) throws SVNException {
            return this.getRepository((Job)context, repoURL, null, Collections.emptyMap(), null);
        }

        @Deprecated
        protected SVNRepository getRepository(AbstractProject context, SVNURL repoURL, StandardCredentials credentials, Map<String, Credentials> additionalCredentials) throws SVNException {
            return this.getRepository((Job)context, repoURL, credentials, additionalCredentials, null);
        }

        @Deprecated
        protected SVNRepository getRepository(Job context, SVNURL repoURL, StandardCredentials credentials, Map<String, Credentials> additionalCredentials, ISVNSession session) throws SVNException {
            return this.getRepository((Item)context, repoURL, credentials, additionalCredentials, session);
        }

        protected SVNRepository getRepository(Item context, SVNURL repoURL, StandardCredentials credentials, Map<String, Credentials> additionalCredentials, ISVNSession session) throws SVNException {
            JenkinsJVM.checkJenkinsJVM();
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL, (ISVNSession)session);
            ISVNAuthenticationManager sam = SubversionSCM.createSvnAuthenticationManager(new CredentialsSVNAuthenticationProviderImpl((Credentials)credentials, additionalCredentials, TaskListener.NULL));
            sam = new FilterSVNAuthenticationManager(sam){

                @Override
                public int getReadTimeout(SVNRepository repository) {
                    int r = super.getReadTimeout(repository);
                    if (r <= 0) {
                        r = DEFAULT_TIMEOUT;
                    }
                    return r;
                }
            };
            repository.setTunnelProvider((ISVNTunnelProvider)SubversionSCM.createDefaultSVNOptions(SubversionSCM.descriptor().isStoreAuthToDisk()));
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(true).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        public FormValidation doCheckExcludedRegions(@QueryParameter String value) throws IOException, ServletException {
            for (String region : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                try {
                    Pattern.compile(region);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIncludedRegions(@QueryParameter String value) throws IOException, ServletException {
            return this.doCheckExcludedRegions(value);
        }

        public FormValidation doCheckExcludedUsers(@QueryParameter String value) throws IOException, ServletException {
            for (String user : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                if ("".equals(user = user.trim()) || USERNAME_PATTERN.matcher(user).matches()) continue;
                return FormValidation.error((String)("Invalid username: " + user));
            }
            return FormValidation.ok();
        }

        public List<WorkspaceUpdaterDescriptor> getWorkspaceUpdaterDescriptors() {
            return WorkspaceUpdaterDescriptor.all();
        }

        public FormValidation doCheckExcludedCommitMessages(@QueryParameter String value) throws IOException, ServletException {
            for (String message : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                try {
                    Pattern.compile(message);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public FormValidation doCheckRevisionPropertiesSupported(@AncestorInPath Item context, @QueryParameter String value, @QueryParameter String credentialsId, @QueryParameter String excludedRevprop) throws IOException, ServletException {
            String v = Util.fixNull((String)value).trim();
            if (v.length() == 0) {
                return FormValidation.ok();
            }
            String revprop = Util.fixNull((String)excludedRevprop).trim();
            if (revprop.length() == 0) {
                return FormValidation.ok();
            }
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                SVNURL repoURL = SVNURL.parseURIDecoded((String)new EnvVars(EnvVars.masterEnvVars).expand(v));
                StandardCredentials credentials = SubversionSCM.lookupCredentials(context, credentialsId, repoURL);
                SVNNodeKind node = null;
                try {
                    node = this.checkRepositoryPath(context, repoURL, credentials);
                }
                catch (SVNCancelException ce) {
                    if (!SubversionSCM.isAuthenticationFailedError(ce)) throw ce;
                    return FormValidation.ok();
                }
                if (node != SVNNodeKind.NONE) {
                    return FormValidation.ok();
                }
                SVNRepository repository = null;
                try {
                    repository = this.getRepository(context, repoURL, credentials, Collections.emptyMap(), null);
                    if (!repository.hasCapability(SVNCapability.LOG_REVPROPS)) return FormValidation.warning((String)Messages.SubversionSCM_excludedRevprop_notSupported(v));
                    FormValidation formValidation = FormValidation.ok();
                    return formValidation;
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
            }
            catch (SVNException e) {
                String message = "";
                message = message + "Unable to access " + Util.escape((String)v) + " : " + Util.escape((String)e.getErrorMessage().getFullMessage());
                LOGGER.log(Level.INFO, "Failed to access subversion repository " + v, e);
                return FormValidation.errorWithMarkup((String)message);
            }
        }

        static {
            SubversionSCM.init(8);
        }

        private final class RemotableSVNAuthenticationProviderImpl
        implements RemotableSVNAuthenticationProvider {
            private static final long serialVersionUID = 1243451839093253666L;

            private RemotableSVNAuthenticationProviderImpl() {
            }

            @Override
            public Credential getCredential(SVNURL url, String realm) {
                for (SubversionCredentialProvider p : SubversionCredentialProvider.all()) {
                    Credential c = p.getCredential(url, realm);
                    if (c == null) continue;
                    LOGGER.fine(String.format("getCredential(%s)=>%s by %s", realm, c, p));
                    return c;
                }
                LOGGER.fine(String.format("getCredential(%s)=>%s", realm, DescriptorImpl.this.credentials.get(realm)));
                return (Credential)DescriptorImpl.this.credentials.get(realm);
            }

            @Override
            public void acknowledgeAuthentication(String realm, Credential credential) {
            }

            private Object writeReplace() {
                return Channel.current().export(RemotableSVNAuthenticationProvider.class, (Object)this);
            }
        }

        static interface RemotableSVNAuthenticationProvider
        extends Serializable {
            public Credential getCredential(SVNURL var1, String var2);

            public void acknowledgeAuthentication(String var1, Credential var2);
        }

        public static final class SslClientCertificateCredential
        extends Credential {
            private static final long serialVersionUID = 5455755079546887446L;
            private final Secret certificate;
            private final Secret password;

            public SslClientCertificateCredential(File certificate, String password) throws IOException {
                this.password = Secret.fromString((String)Scrambler.scramble((String)password));
                this.certificate = Secret.fromString((String)new String(Base64.encode((byte[])FileUtils.readFileToByteArray((File)certificate))));
            }

            @Override
            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssl.client-passphrase")) {
                    try {
                        return SVNSSLAuthentication.newInstance((byte[])Base64.decode((char[])this.certificate.getPlainText().toCharArray()), (char[])Scrambler.descramble((String)Secret.toString((Secret)this.password)).toCharArray(), (boolean)false, null, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }

            public StandardCertificateCredentials toCredentials(String description) {
                return new CertificateCredentialsImpl(CredentialsScope.GLOBAL, null, description, Scrambler.descramble((String)Secret.toString((Secret)this.password)), (CertificateCredentialsImpl.KeyStoreSource)new CertificateCredentialsImpl.UploadedKeyStoreSource(this.certificate.getEncryptedValue()));
            }

            @Override
            public StandardCredentials toCredentials(ModelObject context, String description) throws IOException {
                StandardCertificateCredentials result = this.toCredentials(description);
                for (StandardCertificateCredentials c : CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)this.findItemGroup(context), (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                    if (!c.getPassword().equals((Object)result.getPassword())) continue;
                    KeyStore s1 = c.getKeyStore();
                    KeyStore s2 = result.getKeyStore();
                    try {
                        HashSet<String> a1 = new HashSet<String>(Collections.list(s1.aliases()));
                        HashSet<String> a2 = new HashSet<String>(Collections.list(s2.aliases()));
                        if (!a1.equals(a2)) continue;
                        ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
                        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
                        s1.store(bos1, c.getPassword().getPlainText().toCharArray());
                        s2.store(bos2, c.getPassword().getPlainText().toCharArray());
                        if (!Arrays.equals(bos1.toByteArray(), bos2.toByteArray())) continue;
                        return c;
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    }
                }
                return null;
            }
        }

        public static final class SshPublicKeyCredential
        extends Credential {
            private static final long serialVersionUID = -4649332611621900514L;
            private final String userName;
            private final Secret passphrase;
            private final String id;
            private final String privateKey;

            public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
                JenkinsJVM.checkJenkinsJVM();
                this.userName = userName;
                this.passphrase = Secret.fromString((String)Scrambler.scramble((String)passphrase));
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    buf.append(Integer.toHexString(RANDOM.nextInt(16)));
                }
                this.id = buf.toString();
                try {
                    File savedKeyFile = this.getKeyFile();
                    FileUtils.copyFile((File)keyFile, (File)savedKeyFile);
                    this.setFilePermissions(savedKeyFile, "600");
                    this.privateKey = FileUtils.readFileToString((File)savedKeyFile, (String)"iso-8859-1");
                }
                catch (IOException e) {
                    throw new SVNException((SVNErrorMessage)new RemotableSVNErrorMessage(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "Unable to save private key"), (Throwable)e);
                }
            }

            private File getKeyFile() {
                if (this.id.contains("/") || this.id.contains("\\")) {
                    throw new SecurityException();
                }
                File dir = new File(Jenkins.getInstance().getRootDir(), "subversion-credentials");
                if (dir.mkdirs()) {
                    this.setFilePermissions(dir, "600");
                }
                return new File(dir, this.id);
            }

            private boolean setFilePermissions(File file, String perms) {
                try {
                    Chmod chmod = new Chmod();
                    chmod.setProject(new Project());
                    chmod.setFile(file);
                    chmod.setPerm(perms);
                    chmod.execute();
                }
                catch (BuildException e) {
                    LOGGER.log(Level.WARNING, "Failed to set permission of " + file, e);
                    return false;
                }
                return true;
            }

            public SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, this.privateKey.toCharArray(), Scrambler.descramble((String)Secret.toString((Secret)this.passphrase)), -1, false);
                }
                return null;
            }

            @Override
            public StandardCredentials toCredentials(String description) throws IOException {
                try {
                    return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, null, this.userName, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1")), Scrambler.descramble((String)Secret.toString((Secret)this.passphrase)), description);
                }
                catch (UnsupportedCharsetException e) {
                    throw new IllegalStateException("Java Language Specification lists ISO-8859-1 as a required standard charset", e);
                }
            }

            @Override
            public StandardCredentials toCredentials(ModelObject context, String description) throws IOException {
                String key = FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1");
                for (SSHUserPrivateKey c : CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (ItemGroup)this.findItemGroup(context), (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                    if (!this.userName.equals(c.getUsername()) || !c.getPrivateKeys().contains(key)) continue;
                    return c;
                }
                return null;
            }
        }

        public static final class PasswordCredential
        extends Credential {
            private static final long serialVersionUID = -1676145651108866745L;
            private final String userName;
            private final Secret password;

            public PasswordCredential(String userName, String password) {
                this.userName = userName;
                this.password = Secret.fromString((String)Scrambler.scramble((String)password));
            }

            @Override
            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, this.getPassword(), -1, false);
                }
                return new SVNPasswordAuthentication(this.userName, this.getPassword(), false);
            }

            @Override
            public StandardCredentials toCredentials(String description) {
                return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, description, this.userName, this.getPassword());
            }

            @Override
            public StandardCredentials toCredentials(ModelObject context, String description) throws IOException {
                for (StandardUsernamePasswordCredentials c : CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)this.findItemGroup(context), (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                    if (!this.userName.equals(c.getUsername()) || !this.getPassword().equals(c.getPassword().getPlainText())) continue;
                    return c;
                }
                return null;
            }

            private String getPassword() {
                return Scrambler.descramble((String)Secret.toString((Secret)this.password));
            }
        }

        public static abstract class Credential
        implements Serializable {
            private static final long serialVersionUID = -3707951427730113110L;

            public abstract SVNAuthentication createSVNAuthentication(String var1) throws SVNException;

            public abstract StandardCredentials toCredentials(String var1) throws IOException;

            public abstract StandardCredentials toCredentials(ModelObject var1, String var2) throws IOException;

            protected ItemGroup findItemGroup(ModelObject context) {
                if (context instanceof ItemGroup) {
                    return (ItemGroup)context;
                }
                if (context instanceof Item) {
                    return ((Item)context).getParent();
                }
                return Jenkins.getInstance();
            }
        }
    }

    static final class SVNLogHandler
    implements ISVNLogEntryHandler,
    Serializable {
        private boolean changesFound = false;
        private SVNLogFilter filter;
        private final boolean storeAuthToDisk = SubversionSCM.descriptor().isStoreAuthToDisk();
        private final int workspaceFormat = SubversionSCM.descriptor().getWorkspaceFormat();
        private static final long serialVersionUID = 1L;

        SVNLogHandler(SVNLogFilter svnLogFilter, TaskListener listener) {
            JenkinsJVM.checkJenkinsJVM();
            this.filter = svnLogFilter;
            this.filter.setTaskListener(listener);
        }

        public boolean isChangesFound() {
            return this.changesFound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean findNonExcludedChanges(SVNURL url, long from, long to, ISVNAuthenticationProvider authProvider) throws SVNException {
            if (from > to) {
                return false;
            }
            if (!this.filter.hasExclusionRule()) {
                return true;
            }
            SvnClientManager manager = SubversionSCM.createClientManager(authProvider, this.storeAuthToDisk, this.workspaceFormat);
            try {
                manager.getLogClient().doLog(url, null, SVNRevision.UNDEFINED, SVNRevision.create((long)from), SVNRevision.create((long)to), false, true, false, 0L, null, (ISVNLogEntryHandler)this);
            }
            finally {
                manager.dispose();
            }
            return this.isChangesFound();
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.filter.isIncluded(logEntry)) {
                this.changesFound = true;
            }
        }
    }

    private static class BuildRevisionMapTask
    extends MasterToSlaveFileCallable<List<SvnInfoP>> {
        private final ISVNAuthenticationProvider defaultAuthProvider;
        private final Map<String, ISVNAuthenticationProvider> authProviders;
        private final TaskListener listener;
        private final List<External> externals;
        private final ModuleLocation[] locations;
        private final boolean storeAuthToDisk = SubversionSCM.descriptor().isStoreAuthToDisk();
        private final int workspaceFormat = SubversionSCM.descriptor().getWorkspaceFormat();
        private static final long serialVersionUID = 1L;

        public BuildRevisionMapTask(Run<?, ?> build, SubversionSCM parent, TaskListener listener, List<External> externals, EnvVars env) {
            this.listener = listener;
            this.externals = externals;
            this.locations = parent.getLocations(env, build);
            this.defaultAuthProvider = parent.createAuthenticationProvider(build.getParent(), null, listener);
            this.authProviders = new LinkedHashMap<String, ISVNAuthenticationProvider>();
            for (ModuleLocation loc : this.locations) {
                this.authProviders.put(loc.remote, parent.createAuthenticationProvider(build.getParent(), loc, listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SvnInfoP> invoke(File ws, VirtualChannel channel) throws IOException {
            ArrayList<SvnInfoP> revisions = new ArrayList<SvnInfoP>();
            for (ModuleLocation module : this.locations) {
                ISVNAuthenticationProvider authProvider = this.authProviders.get(module.remote);
                if (authProvider == null) {
                    authProvider = this.defaultAuthProvider;
                }
                SvnClientManager manager = SubversionSCM.createClientManager(authProvider, this.storeAuthToDisk, this.workspaceFormat);
                try {
                    SVNWCClient svnWc = manager.getWCClient();
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, module.getLocalDir()), SVNRevision.WORKING));
                        revisions.add(new SvnInfoP(info, false));
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for " + module.remote));
                    }
                }
                finally {
                    manager.dispose();
                }
            }
            SvnClientManager manager = SubversionSCM.createClientManager(this.defaultAuthProvider, this.storeAuthToDisk, this.workspaceFormat);
            try {
                SVNWCClient svnWc = manager.getWCClient();
                for (External ext : this.externals) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, ext.path), SVNRevision.WORKING));
                        revisions.add(new SvnInfoP(info, ext.isRevisionFixed()));
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for external " + ext.url + " at " + ext.path));
                    }
                }
                ArrayList<SvnInfoP> arrayList = revisions;
                return arrayList;
            }
            finally {
                manager.dispose();
            }
        }
    }

    public static final class External
    implements Serializable {
        public final String path;
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;

        public External(String path, SVNURL url, long revision) {
            this.path = path;
            this.url = url.toDecodedString();
            this.revision = revision;
        }

        public boolean isRevisionFixed() {
            return this.revision != -1L;
        }
    }

    private static final class SvnInfoP
    implements Serializable {
        public final SvnInfo info;
        public final boolean pinned;
        private static final long serialVersionUID = 1L;

        public SvnInfoP(SvnInfo info, boolean pinned) {
            this.info = info;
            this.pinned = pinned;
        }
    }

    public static final class SvnInfo
    implements Serializable,
    Comparable<SvnInfo> {
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;

        public SvnInfo(String url, long revision) {
            this.url = url;
            this.revision = revision;
        }

        public SvnInfo(SVNInfo info) {
            this(info.getURL().toDecodedString(), info.getCommittedRevision().getNumber());
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIDecoded((String)this.url);
        }

        @Override
        public int compareTo(SvnInfo that) {
            int r = this.url.compareTo(that.url);
            if (r != 0) {
                return r;
            }
            if (this.revision < that.revision) {
                return -1;
            }
            if (this.revision > that.revision) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SvnInfo svnInfo = (SvnInfo)o;
            return this.revision == svnInfo.revision && this.url.equals(svnInfo.url);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s (rev.%s)", this.url, this.revision);
        }
    }

    private static class CheckOutUpdateTask
    extends WorkspaceUpdater.UpdateTask {
        private final WorkspaceUpdater.UpdateTask task;
        private final boolean storeAuthToDisk = SubversionSCM.descriptor().isStoreAuthToDisk();
        private final int workspaceFormat = SubversionSCM.descriptor().getWorkspaceFormat();
        private static final long serialVersionUID = 1L;

        CheckOutUpdateTask(Run<?, ?> build, SubversionSCM parent, ModuleLocation location, Date timestamp, TaskListener listener, EnvVars env, boolean quietOperation) {
            this.authProvider = parent.createAuthenticationProvider(build.getParent(), location, listener);
            this.timestamp = timestamp;
            this.listener = listener;
            this.location = location;
            this.revisions = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
            this.task = parent.getWorkspaceUpdater().createTask(this.workspaceFormat);
            this.quietOperation = quietOperation;
        }

        List<External> run(File ws) throws IOException {
            SubversionSCM.init(this.workspaceFormat);
            this.clientManager = SubversionSCM.createClientManager(this.authProvider, this.storeAuthToDisk, this.workspaceFormat);
            this.manager = this.clientManager.getCore();
            this.ws = ws;
            try {
                List<External> externals = this.perform();
                this.checkClockOutOfSync();
                List<External> list = externals;
                return list;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            finally {
                this.clientManager.dispose();
            }
        }

        @Override
        public List<External> perform() throws IOException, InterruptedException {
            return this.delegateTo(this.task);
        }

        private void checkClockOutOfSync() {
            try {
                SVNDirEntry dir = this.clientManager.createRepository(this.location.getSVNURL(), true).info("/", -1L);
                if (dir != null && dir.getDate() != null && dir.getDate().after(new Date())) {
                    this.listener.getLogger().println(Messages.SubversionSCM_ClockOutOfSync());
                }
            }
            catch (SVNAuthenticationException e) {
                LOGGER.log(Level.FINE, "Failed to estimate the remote time stamp", e);
            }
            catch (SVNException e) {
                LOGGER.log(Level.INFO, "Failed to estimate the remote time stamp", e);
            }
        }
    }

    private static final class CheckOutTask
    extends MasterToSlaveFileCallable<List<External>> {
        private final CheckOutUpdateTask delegate;

        CheckOutTask(CheckOutUpdateTask delegate) {
            this.delegate = delegate;
        }

        Set<String> getUnauthenticatedRealms() {
            if (this.delegate.authProvider instanceof CredentialsSVNAuthenticationProviderImpl) {
                return ((CredentialsSVNAuthenticationProviderImpl)this.delegate.authProvider).getUnauthenticatedRealms();
            }
            return Collections.emptySet();
        }

        public List<External> invoke(File ws, VirtualChannel channel) throws IOException {
            return this.delegate.run(ws);
        }
    }
}

