/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.DirAwareSVNXMLLogHandler;
import hudson.scm.NullSVNLogFilter;
import hudson.scm.SVNLogFilter;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import jenkins.MasterToSlaveFileCallable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.LocatorImpl;

public final class SubversionChangeLogBuilder {
    private final Map<String, Long> previousRevisions;
    private final Map<String, Long> thisRevisions;
    private final TaskListener listener;
    private final SubversionSCM scm;
    private final Run<?, ?> build;
    private final FilePath workspace;
    private final EnvVars env;
    private static final LocatorImpl DUMMY_LOCATOR = new LocatorImpl();
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Debugging environment variable is made editable, so it can be modified through the groovy console.")
    public static boolean debug = false;

    public SubversionChangeLogBuilder(AbstractBuild<?, ?> build, BuildListener listener, SubversionSCM scm) throws IOException {
        this((Run<?, ?>)build, build.getWorkspace(), (SVNRevisionState)build.getPreviousBuild().getAction(SVNRevisionState.class), null, (TaskListener)listener, scm);
    }

    public SubversionChangeLogBuilder(Run<?, ?> build, FilePath workspace, @NonNull SVNRevisionState baseline, EnvVars env, TaskListener listener, SubversionSCM scm) throws IOException {
        this.previousRevisions = baseline.revisions;
        this.thisRevisions = scm.parseSvnRevisionFile(build);
        this.listener = listener;
        this.scm = scm;
        this.build = build;
        this.workspace = workspace;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(@NonNull Map<String, List<SubversionSCM.External>> externalsMap, Result changeLog) throws IOException, InterruptedException {
        boolean changelogFileCreated = false;
        TransformerHandler th = SubversionChangeLogBuilder.createTransformerHandler();
        th.setResult(changeLog);
        SVNLogFilter logFilter = this.scm.isFilterChangelog() ? this.scm.createSVNLogFilter() : new NullSVNLogFilter();
        DirAwareSVNXMLLogHandler logHandler = new DirAwareSVNXMLLogHandler((ContentHandler)th, logFilter);
        th.setDocumentLocator(DUMMY_LOCATOR);
        logHandler.startDocument();
        for (SubversionSCM.ModuleLocation l : this.scm.getLocations(this.env, this.build)) {
            CredentialsSVNAuthenticationProviderImpl authProvider = CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider((Item)this.build.getParent(), this.scm, l, this.listener);
            SVNClientManager manager = SubversionSCM.createClientManager(authProvider, SubversionSCM.descriptor().isStoreAuthToDisk(), SubversionSCM.descriptor().getWorkspaceFormat()).getCore();
            try {
                SVNLogClient svnlc = manager.getLogClient();
                PathContext context = this.getUrlForPath(this.workspace.child(l.getLocalDir()), authProvider);
                context.moduleWorkspacePath = l.getLocalDir();
                changelogFileCreated |= this.buildModule(context, svnlc, logHandler);
                List<SubversionSCM.External> externals = externalsMap.get(l.remote);
                if (externals == null) continue;
                for (SubversionSCM.External ext : externals) {
                    PathContext extContext = this.getUrlForPath(this.workspace.child(ext.path), authProvider);
                    extContext.moduleWorkspacePath = ext.path;
                    changelogFileCreated |= this.buildModule(extContext, svnlc, logHandler);
                }
            }
            finally {
                manager.dispose();
            }
        }
        if (changelogFileCreated) {
            logHandler.endDocument();
        }
        return changelogFileCreated;
    }

    private PathContext getUrlForPath(FilePath path, ISVNAuthenticationProvider authProvider) throws IOException, InterruptedException {
        return (PathContext)path.act((FilePath.FileCallable)new GetContextForPath(authProvider));
    }

    private boolean buildModule(PathContext context, SVNLogClient svnlc, DirAwareSVNXMLLogHandler logHandler) throws IOException {
        String url = context.url;
        PrintStream logger = this.listener.getLogger();
        try {
            SVNURL repoURL = SVNURL.parseURIEncoded((String)url);
            Long prevRev = this.previousRevisions.get(url);
            if (prevRev == null) {
                logger.println("No revision recorded for " + repoURL + " in the previous build");
                return false;
            }
            Long thisRev = this.thisRevisions.get(url);
            if (thisRev == null) {
                this.listener.error("No revision found for " + repoURL + " in " + SubversionSCM.getRevisionFile(this.build) + ". Revision file contains: " + this.thisRevisions.keySet());
                return false;
            }
            if (thisRev.equals(prevRev)) {
                logger.println("No changes for " + repoURL + " since the previous build");
                return false;
            }
            if (prevRev.compareTo(thisRev) > 0) {
                long temp = thisRev;
                thisRev = prevRev;
                prevRev = temp;
            }
            logHandler.setContext(context);
            if (debug) {
                this.listener.getLogger().printf("Computing changelog of %1s from %2s to %3s%n", SVNURL.parseURIEncoded((String)url), prevRev + 1L, thisRev);
            }
            svnlc.doLog(SVNURL.parseURIEncoded((String)url), null, SVNRevision.UNDEFINED, SVNRevision.create((long)(prevRev + 1L)), SVNRevision.create((long)thisRev), false, true, 0L, debug ? new DebugSVNLogHandler(logHandler) : logHandler);
            if (debug) {
                this.listener.getLogger().println("done");
            }
        }
        catch (SVNException e) {
            throw new IOException("revision check failed on " + url, e);
        }
        return true;
    }

    private static TransformerHandler createTransformerHandler() {
        try {
            return ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }

    static {
        DUMMY_LOCATOR.setLineNumber(-1);
        DUMMY_LOCATOR.setColumnNumber(-1);
    }

    @Restricted(value={NoExternalUse.class})
    public static class PathContext
    implements Serializable {
        public String url;
        public String repoUrl;
        public String moduleWorkspacePath;
        private static final long serialVersionUID = 1L;

        private PathContext(String url, String repoUrl, String moduleWorkspacePath) {
            this.url = url;
            this.moduleWorkspacePath = moduleWorkspacePath;
            this.repoUrl = repoUrl;
        }
    }

    private static class GetContextForPath
    extends MasterToSlaveFileCallable<PathContext> {
        private final ISVNAuthenticationProvider authProvider;
        private final boolean storeAuthToDisk;
        private final int workspaceFormat;
        private static final long serialVersionUID = 1L;

        public GetContextForPath(ISVNAuthenticationProvider authProvider) {
            this.authProvider = authProvider;
            this.storeAuthToDisk = SubversionSCM.descriptor().isStoreAuthToDisk();
            this.workspaceFormat = SubversionSCM.descriptor().getWorkspaceFormat();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PathContext invoke(File p, VirtualChannel channel) throws IOException {
            SvnClientManager manager = SubversionSCM.createClientManager(this.authProvider, this.storeAuthToDisk, this.workspaceFormat);
            try {
                SVNWCClient svnwc = manager.getWCClient();
                try {
                    SVNInfo info = svnwc.doInfo(p, SVNRevision.WORKING);
                    String url = info.getURL().toDecodedString();
                    String repoRoot = info.getRepositoryRootURL().toDecodedString();
                    PathContext pathContext = new PathContext(url, repoRoot, null);
                    return pathContext;
                }
                catch (SVNException e) {
                    e.printStackTrace();
                    PathContext pathContext = null;
                    manager.dispose();
                    return pathContext;
                }
            }
            finally {
                manager.dispose();
            }
        }
    }

    private class DebugSVNLogHandler
    implements ISVNLogEntryHandler {
        private final ISVNLogEntryHandler core;

        private DebugSVNLogHandler(ISVNLogEntryHandler core) {
            this.core = core;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            SubversionChangeLogBuilder.this.listener.getLogger().println("SVNLogEntry=" + logEntry);
            this.core.handleLogEntry(logEntry);
        }
    }
}

