/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.subversion;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionRepositoryStatus;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.SvnHelper;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.security.ACL;
import hudson.util.EditDistance;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.scm.impl.subversion.Messages;
import jenkins.scm.impl.subversion.SVNRepositoryView;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SubversionSCMSource
extends SCMSource {
    public static final StringListComparator COMPARATOR = new StringListComparator();
    public static final Logger LOGGER = Logger.getLogger(SubversionSCMSource.class.getName());
    private final String remoteBase;
    private String credentialsId = "";
    private String includes = "trunk,branches/*,tags/*,sandbox/*";
    private String excludes = "";
    private SubversionRepositoryBrowser browser;
    private WorkspaceUpdater workspaceUpdater = new UpdateUpdater();
    @GuardedBy(value="this")
    private transient String uuid;

    @Deprecated
    public SubversionSCMSource(String id, String remoteBase, String credentialsId, String includes, String excludes) {
        super(id);
        this.remoteBase = StringUtils.removeEnd((String)remoteBase, (String)"/") + "/";
        this.setCredentialsId(credentialsId);
        this.setIncludes(StringUtils.defaultIfEmpty((String)includes, (String)"trunk,branches/*,tags/*,sandbox/*"));
        this.setExcludes(StringUtils.defaultIfEmpty((String)excludes, (String)""));
    }

    @DataBoundConstructor
    public SubversionSCMSource(String id, String remoteBase) {
        super(id);
        this.remoteBase = StringUtils.removeEnd((String)remoteBase, (String)"/") + "/";
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @DataBoundSetter
    public void setBrowser(SubversionRepositoryBrowser browser) {
        this.browser = browser;
    }

    public WorkspaceUpdater getWorkspaceUpdater() {
        return this.workspaceUpdater;
    }

    @DataBoundSetter
    public void setWorkspaceUpdater(WorkspaceUpdater workspaceUpdater) {
        this.workspaceUpdater = workspaceUpdater;
    }

    public String getRemoteBase() {
        return this.remoteBase;
    }

    @CheckForNull
    public synchronized String getUuid() {
        if (this.uuid == null) {
            SVNRepositoryView repository = null;
            try {
                SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
                repository = this.openSession(repoURL, (Item)this.getOwner());
                this.uuid = repository.getUuid();
            }
            catch (IOException | SVNException e) {
                try {
                    LOGGER.log(Level.WARNING, "Could not connect to remote repository " + this.remoteBase + " to determine UUID", e);
                }
                catch (Throwable throwable) {
                    SubversionSCMSource.closeSession(repository);
                    throw throwable;
                }
                SubversionSCMSource.closeSession(repository);
            }
            SubversionSCMSource.closeSession(repository);
        }
        return this.uuid;
    }

    @NonNull
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SVNRepositoryView repository = null;
        try {
            listener.getLogger().println("Opening conection to " + this.remoteBase);
            SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
            repository = this.openSession(repoURL, (Item)this.getOwner());
            String repoPath = SubversionSCM.DescriptorImpl.getRelativePath(repoURL, repository.getRepository());
            List<String> prefix = Collections.emptyList();
            this.fetch(listener, repository, repoPath, SubversionSCMSource.toPaths(SubversionSCMSource.splitCludes(this.includes)), prefix, prefix, SubversionSCMSource.toPaths(SubversionSCMSource.splitCludes(this.excludes)), criteria, observer);
        }
        catch (SVNException e) {
            try {
                e.printStackTrace(listener.error("Could not communicate with Subversion server"));
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SubversionSCMSource.closeSession(repository);
                throw throwable;
            }
        }
        SubversionSCMSource.closeSession(repository);
    }

    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException {
        SCMRevisionImpl sCMRevisionImpl;
        SVNRepositoryView repository = null;
        try {
            listener.getLogger().println("Opening connection to " + this.remoteBase);
            SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
            repository = this.openSession(repoURL, (Item)this.getOwner());
            String repoPath = SubversionSCM.DescriptorImpl.getRelativePath(repoURL, repository.getRepository());
            String path = SVNPathUtil.append((String)repoPath, (String)head.getName());
            SVNRepositoryView.NodeEntry svnEntry = repository.getNode(path, -1L);
            sCMRevisionImpl = new SCMRevisionImpl(head, svnEntry.getRevision());
        }
        catch (SVNException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SubversionSCMSource.closeSession(repository);
                throw throwable;
            }
        }
        SubversionSCMSource.closeSession(repository);
        return sCMRevisionImpl;
    }

    protected SCMRevision retrieve(String unparsedRevision, TaskListener listener, Item context) throws IOException, InterruptedException {
        SCMRevisionImpl sCMRevisionImpl;
        long resolvedRevision;
        long revision;
        String base;
        SVNRepositoryView repository;
        block7: {
            repository = null;
            listener.getLogger().println("Opening connection to " + this.remoteBase);
            SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
            repository = this.openSession(repoURL, context);
            String repoPath = SubversionSCM.DescriptorImpl.getRelativePath(repoURL, repository.getRepository());
            Matcher pathAtRev = Pattern.compile("(.+)@(\\d+)").matcher(unparsedRevision);
            if (pathAtRev.matches()) {
                base = pathAtRev.group(1);
                revision = Long.parseLong(pathAtRev.group(2));
            } else {
                base = unparsedRevision;
                revision = -1L;
            }
            String path = SVNPathUtil.append((String)repoPath, (String)base);
            resolvedRevision = repository.getNode(path, -1L).getRevision();
            if (resolvedRevision != -1L) break block7;
            listener.getLogger().println("Could not find " + path);
            SCMRevision sCMRevision = null;
            SubversionSCMSource.closeSession(repository);
            return sCMRevision;
        }
        try {
            sCMRevisionImpl = new SCMRevisionImpl(new SCMHead(base), revision == -1L ? resolvedRevision : revision);
        }
        catch (SVNException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SubversionSCMSource.closeSession(repository);
                throw throwable;
            }
        }
        SubversionSCMSource.closeSession(repository);
        return sCMRevisionImpl;
    }

    protected Set<String> retrieveRevisions(TaskListener listener, Item context) throws IOException, InterruptedException {
        return this.retrieve(listener).stream().map(SCMHead::getName).collect(Collectors.toSet());
    }

    private static void closeSession(@CheckForNull SVNRepositoryView repository) {
        if (repository != null) {
            repository.close();
        }
    }

    private SVNRepositoryView openSession(SVNURL repoURL, Item context) throws SVNException, IOException {
        return new SVNRepositoryView(repoURL, this.credentialsId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)repoURL.toString()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})})));
    }

    void fetch(@NonNull TaskListener listener, final @NonNull SVNRepositoryView repository, @NonNull String repoPath, @NonNull SortedSet<List<String>> paths, @NonNull List<String> prefix, @NonNull List<String> realPath, @NonNull SortedSet<List<String>> excludedPaths, @CheckForNull SCMSourceCriteria branchCriteria, @NonNull SCMHeadObserver observer) throws IOException, SVNException, InterruptedException {
        String svnPath = SVNPathUtil.append((String)repoPath, (String)StringUtils.join(realPath, (char)'/'));
        assert (prefix.size() == realPath.size());
        assert (SubversionSCMSource.wildcardStartsWith(realPath, prefix));
        SortedMap<List<String>, SortedSet<List<String>>> includePaths = SubversionSCMSource.groupPaths(paths, prefix);
        listener.getLogger().println("Checking directory " + svnPath + "@HEAD");
        SVNRepositoryView.NodeEntry node = repository.getNode(svnPath, -1L);
        if (!SVNNodeKind.DIR.equals(node.getType()) || node.getChildren() == null) {
            return;
        }
        for (Map.Entry<List<String>, SortedSet<List<String>>> entry : includePaths.entrySet()) {
            for (List list : entry.getValue()) {
                String name = (String)list.get(prefix.size());
                SVNRepositoryView.ChildEntry[] children = (SVNRepositoryView.ChildEntry[])node.getChildren().clone();
                Arrays.sort(children, Comparator.comparingLong(SVNRepositoryView.ChildEntry::getRevision).reversed());
                for (SVNRepositoryView.ChildEntry svnEntry : children) {
                    if (svnEntry.getType() != SVNNodeKind.DIR || !SubversionSCMSource.isMatch(svnEntry.getName(), name)) continue;
                    List<String> childPrefix = SubversionSCMSource.copyAndAppend(prefix, name);
                    List<String> childRealPath = SubversionSCMSource.copyAndAppend(realPath, svnEntry.getName());
                    if (SubversionSCMSource.wildcardStartsWith(childRealPath, excludedPaths)) continue;
                    if (list.equals(childPrefix)) {
                        final String childPath = StringUtils.join(childRealPath, (char)'/');
                        final String candidateRootPath = SVNPathUtil.append((String)repoPath, (String)childPath);
                        long candidateRevision = svnEntry.getRevision();
                        final long lastModified = svnEntry.getLastModified();
                        listener.getLogger().println("Checking candidate branch " + candidateRootPath + "@HEAD");
                        if (branchCriteria == null || branchCriteria.isHead(new SCMSourceCriteria.Probe(){

                            public String name() {
                                return childPath;
                            }

                            public long lastModified() {
                                return lastModified;
                            }

                            public boolean exists(@NonNull String path) throws IOException {
                                try {
                                    return repository.checkPath(SVNPathUtil.append((String)candidateRootPath, (String)path), -1L) != SVNNodeKind.NONE;
                                }
                                catch (SVNException e) {
                                    throw new IOException(e);
                                }
                            }
                        }, listener)) {
                            listener.getLogger().println("Met criteria");
                            long branchRevision = candidateRevision;
                            if (repository.checkPath(candidateRootPath, branchRevision) == SVNNodeKind.NONE) {
                                listener.getLogger().println("Branch older than root folder, using HEAD");
                                branchRevision = -1L;
                            }
                            SCMHead head = new SCMHead(childPath);
                            observer.observe(head, (SCMRevision)new SCMRevisionImpl(head, branchRevision));
                            if (observer.isObserving()) continue;
                            return;
                        }
                        listener.getLogger().println("Does not meet criteria");
                        continue;
                    }
                    this.fetch(listener, repository, repoPath, paths, childPrefix, childRealPath, excludedPaths, branchCriteria, observer);
                }
            }
        }
    }

    @NonNull
    private static <T> List<T> copyAndAppend(@NonNull List<T> list, T ... values) {
        ArrayList<T> childPrefix = new ArrayList<T>(list.size() + values.length);
        childPrefix.addAll(list);
        childPrefix.addAll(Arrays.asList(values));
        return childPrefix;
    }

    @NonNull
    static SortedMap<List<String>, SortedSet<List<String>>> groupPaths(@NonNull SortedSet<List<String>> pathSegments, @NonNull List<String> prefix) {
        String optimization;
        pathSegments = SubversionSCMSource.filterPaths(pathSegments, prefix);
        TreeMap<List<String>, SortedSet<List<String>>> result = new TreeMap<List<String>, SortedSet<List<String>>>(COMPARATOR);
        while (!pathSegments.isEmpty()) {
            ArrayList<String> longestPrefix = null;
            int longestIndex = -1;
            for (ArrayList<String> arrayList : pathSegments) {
                if (longestPrefix == null) {
                    longestPrefix = arrayList;
                    longestIndex = SubversionSCMSource.indexOfNextWildcard(arrayList, prefix.size());
                    continue;
                }
                int index = SubversionSCMSource.indexOfNextWildcard((List<String>)arrayList, prefix.size());
                if (index <= longestIndex) continue;
                longestPrefix = arrayList;
                longestIndex = index;
            }
            assert (longestPrefix != null);
            longestPrefix = new ArrayList<String>(longestPrefix.subList(0, longestIndex));
            SortedSet<List<String>> group = SubversionSCMSource.filterPaths(pathSegments, longestPrefix);
            result.put(longestPrefix, group);
            pathSegments.removeAll(group);
        }
        while (null != (optimization = SubversionSCMSource.getOptimizationPoint(result.keySet(), prefix.size()))) {
            List<String> optimizedPrefix = SubversionSCMSource.copyAndAppend(prefix, optimization);
            TreeSet<List<String>> optimizedGroup = new TreeSet<List<String>>(COMPARATOR);
            Iterator iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!SubversionSCMSource.startsWith((List)entry.getKey(), optimizedPrefix)) continue;
                iterator.remove();
                optimizedGroup.addAll((Collection)entry.getValue());
            }
            result.put(optimizedPrefix, optimizedGroup);
        }
        return result;
    }

    @CheckForNull
    static String getOptimizationPoint(@NonNull Set<List<String>> newPrefixes, int oldPrefixSize) {
        HashSet<String> set = new HashSet<String>();
        for (List<String> p : newPrefixes) {
            if (p.size() <= oldPrefixSize) continue;
            String value = p.get(oldPrefixSize);
            if (set.contains(value)) {
                return value;
            }
            set.add(value);
        }
        return null;
    }

    static int indexOfNextWildcard(@NonNull List<String> pathSegment, int startIndex) {
        String segment;
        int index = startIndex;
        ListIterator<String> i = pathSegment.listIterator(index);
        while (i.hasNext() && (segment = i.next()).indexOf(42) == -1 && segment.indexOf(63) == -1) {
            ++index;
        }
        return index;
    }

    static boolean startsWith(@NonNull List<String> value, @NonNull List<String> prefix) {
        if (value.size() < prefix.size()) {
            return false;
        }
        ListIterator<String> i1 = value.listIterator();
        ListIterator<String> i2 = prefix.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    static boolean wildcardStartsWith(@NonNull List<String> value, @NonNull List<String> wildcardPrefix) {
        if (value.size() < wildcardPrefix.size()) {
            return false;
        }
        ListIterator<String> i1 = value.listIterator();
        ListIterator<String> i2 = wildcardPrefix.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (SubversionSCMSource.isMatch(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    static boolean wildcardStartsWith(@NonNull List<String> value, @NonNull Collection<List<String>> wildcardPrefixes) {
        for (List<String> wildcardPrefix : wildcardPrefixes) {
            if (!SubversionSCMSource.wildcardStartsWith(value, wildcardPrefix)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    static SortedSet<List<String>> filterPaths(@NonNull SortedSet<List<String>> pathSegments, @NonNull List<String> prefix) {
        TreeSet<List<String>> result = new TreeSet<List<String>>(COMPARATOR);
        for (List list : pathSegments) {
            if (!SubversionSCMSource.startsWith(list, prefix)) continue;
            result.add(list);
        }
        return result;
    }

    @NonNull
    static SortedSet<List<String>> toPaths(@NonNull SortedSet<String> pathStrings) {
        TreeSet<List<String>> result = new TreeSet<List<String>>(COMPARATOR);
        for (String clude : pathStrings) {
            result.add(Arrays.asList(clude.split("/")));
        }
        return result;
    }

    @NonNull
    static SortedSet<String> splitCludes(@CheckForNull String cludes) {
        TreeSet<String> result = new TreeSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(StringUtils.defaultString((String)cludes), ",");
        while (tokenizer.hasMoreTokens()) {
            String clude = tokenizer.nextToken().trim();
            if (!StringUtils.isNotEmpty((String)clude)) continue;
            result.add(clude.trim());
        }
        return result;
    }

    static boolean isMatch(@NonNull String value, @NonNull String wildcareMatcher) {
        return FilenameUtils.wildcardMatch((String)value, (String)wildcareMatcher, (IOCase)IOCase.SENSITIVE);
    }

    @NonNull
    public SubversionSCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        if (revision != null && !head.equals((Object)revision.getHead())) {
            revision = null;
        }
        if (revision != null && !(revision instanceof SCMRevisionImpl)) {
            revision = null;
        }
        StringBuilder remote = new StringBuilder(this.remoteBase);
        if (!this.remoteBase.endsWith("/")) {
            remote.append('/');
        }
        remote.append(head.getName());
        if (revision != null) {
            remote.append('@').append(((SCMRevisionImpl)revision).getRevision());
        } else if (remote.indexOf("@") != -1) {
            remote.append('@');
        }
        return new SubversionSCM(remote.toString(), this.credentialsId, ".", this.workspaceUpdater, this.browser);
    }

    @Extension
    public static class ListenerImpl
    extends SubversionRepositoryStatus.Listener {
        public static final int RECENT_SIZE = 64;
        @GuardedBy(value="itself")
        private final Map<String, Long> recentUpdates = new LinkedHashMap<String, Long>(64){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
                return this.size() >= 64;
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onNotify(UUID uuid, long revision, Set<String> paths) {
            String id = uuid.toString();
            Map<String, Long> map = this.recentUpdates;
            synchronized (map) {
                Long recentUpdate = this.recentUpdates.get(id);
                if (recentUpdate != null && revision == recentUpdate) {
                    LOGGER.log(Level.FINE, "Received duplicate post-commit hook from {0} for revision {1} on paths {2}", new Object[]{uuid, revision, paths});
                    return false;
                }
                this.recentUpdates.put(id, revision);
            }
            LOGGER.log(Level.INFO, "Received post-commit hook from {0} for revision {1} on paths {2}", new Object[]{uuid, revision, paths});
            boolean notified = false;
            Authentication old = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
            try {
                for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                    for (SCMSource source : owner.getSCMSources()) {
                        if (!(source instanceof SubversionSCMSource) || !id.equals(((SubversionSCMSource)source).getUuid())) continue;
                        LOGGER.log(Level.INFO, "SCM changes detected relevant to {0}. Notifying update", owner.getFullDisplayName());
                        owner.onSCMSourceUpdated(source);
                        notified = true;
                    }
                }
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(old);
            }
            if (!notified) {
                LOGGER.log(Level.INFO, "No subversion consumers for UUID {0}", uuid);
            }
            return notified;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public static final String DEFAULT_INCLUDES = "trunk,branches/*,tags/*,sandbox/*";
        public static final String DEFAULT_EXCLUDES = "";
        static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");

        public String getDisplayName() {
            return Messages.SubversionSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remoteBase, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)remoteBase.trim()).build();
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public FormValidation doCheckCredentialsId(StaplerRequest req, @AncestorInPath Item context, @QueryParameter String remoteBase, @QueryParameter String value) {
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) return FormValidation.ok();
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            String url = Util.fixEmptyAndTrim((String)remoteBase);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return FormValidation.ok();
            }
            try {
                StandardCredentials credentials;
                String urlWithoutRevision = SvnHelper.getUrlWithoutRevision(url);
                SVNURL repoURL = SVNURL.parseURIDecoded((String)urlWithoutRevision);
                StandardCredentials standardCredentials = credentials = value == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)repoURL.toString()).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value));
                if (this.checkRepositoryPath(repoURL, credentials) != SVNNodeKind.NONE) {
                    SVNRevision revision = DescriptorImpl.getRevisionFromRemoteUrl(url);
                    if (revision == null) return FormValidation.ok();
                    if (revision.isValid()) return FormValidation.ok();
                    return FormValidation.errorWithMarkup((String)hudson.scm.subversion.Messages.SubversionSCM_doCheckRemote_invalidRevision());
                }
                SVNRepository repository = null;
                try {
                    String repoPath;
                    repository = this.getRepository(repoURL, credentials, Collections.emptyMap(), null);
                    long rev = repository.getLatestRevision();
                    String p = repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                    while (p.length() > 0) {
                        String head;
                        if (repository.checkPath(p = SVNPathUtil.removeTail((String)p), rev) != SVNNodeKind.DIR) continue;
                        ArrayList entries = new ArrayList();
                        repository.getDir(p, rev, false, entries);
                        ArrayList<String> paths = new ArrayList<String>();
                        for (SVNDirEntry e : entries) {
                            if (e.getKind() != SVNNodeKind.DIR) continue;
                            paths.add(e.getName());
                        }
                        String candidate = EditDistance.findNearest((String)(head = SVNPathUtil.head((String)repoPath.substring(p.length() + 1))), paths);
                        FormValidation formValidation = FormValidation.error((String)hudson.scm.subversion.Messages.SubversionSCM_doCheckRemote_badPathSuggest(p, head, candidate != null ? "/" + candidate : DEFAULT_EXCLUDES));
                        return formValidation;
                    }
                    FormValidation formValidation = FormValidation.error((String)hudson.scm.subversion.Messages.SubversionSCM_doCheckRemote_badPath(repoPath));
                    return formValidation;
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
            }
            catch (SVNException e) {
                LOGGER.log(Level.INFO, "Failed to access subversion repository " + url, e);
                String message = hudson.scm.subversion.Messages.SubversionSCM_doCheckRemote_exceptionMsg1(Util.escape((String)url), Util.escape((String)e.getErrorMessage().getFullMessage()), "javascript:document.getElementById('svnerror').style.display='block';document.getElementById('svnerrorlink').style.display='none';return false;") + "<br/><pre id=\"svnerror\" style=\"display:none\">" + Util.xmlEscape((String)Functions.printThrowable((Throwable)e)) + "</pre>";
                return FormValidation.errorWithMarkup((String)message);
            }
        }

        public SVNNodeKind checkRepositoryPath(SVNURL repoURL, StandardCredentials credentials) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(repoURL, credentials, Collections.emptyMap(), null);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            catch (SVNException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "Could not check repository path {0} using credentials {1} ({2})");
                    lr.setThrown(e);
                    lr.setParameters(new Object[]{repoURL, credentials == null ? null : CredentialsNameProvider.name((Credentials)credentials), credentials});
                    LOGGER.log(lr);
                }
                throw e;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        protected SVNRepository getRepository(SVNURL repoURL, StandardCredentials credentials, Map<String, Credentials> additionalCredentials, ISVNSession session) throws SVNException {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL, (ISVNSession)session);
            ISVNAuthenticationManager sam = SubversionSCM.createSvnAuthenticationManager(new CredentialsSVNAuthenticationProviderImpl((Credentials)credentials, additionalCredentials, TaskListener.NULL));
            sam = new FilterSVNAuthenticationManager(sam){

                @Override
                public int getReadTimeout(SVNRepository repository) {
                    int r = super.getReadTimeout(repository);
                    if (r <= 0) {
                        r = SubversionSCM.DEFAULT_TIMEOUT;
                    }
                    return r;
                }
            };
            repository.setTunnelProvider((ISVNTunnelProvider)SubversionSCM.createDefaultSVNOptions());
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(true).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        private static SVNRevision getRevisionFromRemoteUrl(String remoteUrlPossiblyWithRevision) {
            int idx = remoteUrlPossiblyWithRevision.lastIndexOf(64);
            int slashIdx = remoteUrlPossiblyWithRevision.lastIndexOf(47);
            if (idx > 0 && idx > slashIdx) {
                String n = remoteUrlPossiblyWithRevision.substring(idx + 1);
                return SVNRevision.parse((String)n);
            }
            return null;
        }

        public List<WorkspaceUpdaterDescriptor> getWorkspaceUpdaterDescriptors() {
            return WorkspaceUpdaterDescriptor.all();
        }

        @Restricted(value={NoExternalUse.class})
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return ((SubversionSCM.DescriptorImpl)Jenkins.get().getDescriptorByType(SubversionSCM.DescriptorImpl.class)).getBrowserDescriptors();
        }
    }

    static class StringListComparator
    implements Comparator<List<String>> {
        StringListComparator() {
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            ListIterator<String> e1 = o1.listIterator();
            ListIterator<String> e2 = o2.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                String s2;
                String s1 = e1.next();
                int rv = s1.compareTo(s2 = e2.next());
                if (rv == 0) continue;
                return rv;
            }
            if (e1.hasNext()) {
                return -1;
            }
            if (e2.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private long revision;

        public SCMRevisionImpl(SCMHead head, long revision) {
            super(head);
            this.revision = revision;
        }

        public long getRevision() {
            return this.revision;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return this.revision == that.revision && this.getHead().equals((Object)that.getHead());
        }

        public int hashCode() {
            return (int)(this.revision ^ this.revision >>> 32);
        }

        public String toString() {
            return Long.toString(this.revision);
        }
    }
}

