/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.scm.NullSVNLogFilter;
import hudson.scm.SVNLogFilter;
import hudson.scm.SubversionChangeLogBuilder;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import jenkins.scm.impl.subversion.RemotableSVNErrorMessage;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.xml.SVNXMLLogHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DirAwareSVNXMLLogHandler
extends SVNXMLLogHandler
implements ISVNLogEntryHandler {
    public static final String KIND_ATTR = "kind";
    public static final String REL_PATH_ATTR = "localPath";
    private boolean myIsOmitLogMessage;
    private LinkedList<MergeFrame> myMergeStack;
    private SVNLogFilter filter = new NullSVNLogFilter();
    private SubversionChangeLogBuilder.PathContext context;

    public DirAwareSVNXMLLogHandler(ContentHandler contentHandler, SVNLogFilter filter) {
        super(contentHandler);
        this.filter = filter;
    }

    public DirAwareSVNXMLLogHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        super(contentHandler, log);
    }

    public DirAwareSVNXMLLogHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    public void setOmitLogMessage(boolean omitLogMessage) {
        this.myIsOmitLogMessage = omitLogMessage;
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        try {
            if (this.filter == null || !this.filter.hasExclusionRule() || this.filter.isIncluded(logEntry)) {
                this.sendToHandler(logEntry);
            }
        }
        catch (SAXException e) {
            RemotableSVNErrorMessage err = new RemotableSVNErrorMessage(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)err, (Throwable)e, (SVNLogType)SVNLogType.DEFAULT);
        }
    }

    protected void sendToHandler(SVNLogEntry logEntry) throws SAXException {
        MergeFrame frame;
        if (logEntry.getRevision() == 0L && logEntry.getMessage() == null) {
            return;
        }
        this.addAttribute("revision", logEntry.getRevision() + "");
        this.openTag("logentry");
        if (logEntry.getAuthor() != null) {
            this.addTag("author", logEntry.getAuthor());
        }
        if (logEntry.getDate() != null && logEntry.getDate().getTime() != 0L) {
            this.addTag("date", SVNDate.formatDate((Date)logEntry.getDate()));
        }
        if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
            this.openTag("paths");
            for (String key : logEntry.getChangedPaths().keySet()) {
                SVNLogEntryPath path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                this.addAttribute("action", path.getType() + "");
                String modulePath = this.context.url.substring(this.context.repoUrl.length());
                if (path.getPath().startsWith(modulePath)) {
                    String relativeWorkspacePath = this.context.moduleWorkspacePath + path.getPath().substring(this.context.url.length() - this.context.repoUrl.length());
                    if (".".equals(this.context.moduleWorkspacePath) && relativeWorkspacePath.length() >= 2) {
                        relativeWorkspacePath = relativeWorkspacePath.substring(2);
                    }
                    this.addAttribute(REL_PATH_ATTR, new File(relativeWorkspacePath).toString());
                }
                if (path.getCopyPath() != null) {
                    this.addAttribute("copyfrom-path", path.getCopyPath());
                    this.addAttribute("copyfrom-rev", path.getCopyRevision() + "");
                }
                if (path.getKind() != null) {
                    this.addAttribute(KIND_ATTR, path.getKind().toString());
                }
                this.addTag("path", path.getPath());
            }
            this.closeTag("paths");
        }
        if (!this.myIsOmitLogMessage) {
            String message = logEntry.getMessage();
            message = message == null ? "" : message;
            this.addTag("msg", message);
        }
        if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
            frame = this.myMergeStack.getLast();
            frame.myNumberOfChildrenRemaining--;
        }
        if (logEntry.hasChildren()) {
            frame = new MergeFrame();
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(frame);
        } else {
            while (this.myMergeStack != null && !this.myMergeStack.isEmpty() && (frame = this.myMergeStack.getLast()).myNumberOfChildrenRemaining == 0L) {
                this.closeTag("logentry");
                this.myMergeStack.removeLast();
            }
            this.closeTag("logentry");
        }
    }

    void setContext(SubversionChangeLogBuilder.PathContext context) {
        this.context = context;
    }

    private class MergeFrame {
        private long myNumberOfChildrenRemaining;

        private MergeFrame() {
        }
    }
}

