/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class ListSubversionTagsParameterValue
extends ParameterValue {
    private String tagsDir;
    private String tag;

    @DataBoundConstructor
    public ListSubversionTagsParameterValue(String name, String tagsDir, String tag) {
        super(name);
        this.tagsDir = tagsDir;
        this.tag = tag;
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.getName(), this.getTag());
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return ListSubversionTagsParameterValue.this.name.equals(name) ? ListSubversionTagsParameterValue.this.getTag() : null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSubversionTagsParameterValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListSubversionTagsParameterValue that = (ListSubversionTagsParameterValue)((Object)o);
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        return !(this.tagsDir != null ? !this.tagsDir.equals(that.tagsDir) : that.tagsDir != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tagsDir != null ? this.tagsDir.hashCode() : 0);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    @Exported(visibility=3)
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Exported(visibility=3)
    public String getTagsDir() {
        return this.tagsDir;
    }

    public void setTagsDir(String tagsDir) {
        this.tagsDir = tagsDir;
    }

    public String toString() {
        return "(ListSubversionTagsParameterValue) " + this.getName() + ": Repository URL='" + this.tagsDir + "' Tag='" + this.tag + "'";
    }
}

