/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SubversionUpdateEventHandler;
import hudson.scm.subversion.UpdaterException;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.triggers.SCMTrigger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class UpdateUpdater
extends WorkspaceUpdater {
    private static final long serialVersionUID = 1451258464864424355L;
    private static final FastDateFormat fmt = FastDateFormat.getInstance((String)"''yyyy-MM-dd'T'HH:mm:ss.SSS Z''");

    @DataBoundConstructor
    public UpdateUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new TaskImpl();
    }

    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.UpdateUpdater_DisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskImpl
    extends WorkspaceUpdater.UpdateTask {
        private static final long serialVersionUID = -5766470969352844330L;

        protected boolean isUpdatable() throws IOException {
            String moduleName = this.location.getLocalDir();
            File module = new File(this.ws, moduleName).getCanonicalFile();
            if (!module.exists()) {
                this.listener.getLogger().println("Checking out a fresh workspace because " + module + " doesn't exist");
                return false;
            }
            try {
                SVNInfo svnkitInfo = this.parseSvnInfo(module);
                SubversionSCM.SvnInfo svnInfo = new SubversionSCM.SvnInfo(svnkitInfo);
                String url = this.location.getURL();
                if (!svnInfo.url.equals(url)) {
                    this.listener.getLogger().println("Checking out a fresh workspace because the workspace is not " + url);
                    return false;
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                    this.listener.getLogger().println("Checking out a fresh workspace because there's no workspace at " + module);
                } else {
                    this.listener.getLogger().println("Checking out a fresh workspace because Jenkins failed to detect the current workspace " + module);
                    e.printStackTrace(this.listener.error(e.getMessage()));
                }
                return false;
            }
            return true;
        }

        private SVNInfo parseSvnInfo(File workspace) throws SVNException {
            SVNWCClient svnWc = this.clientManager.getWCClient();
            return svnWc.doInfo(workspace, SVNRevision.WORKING);
        }

        @Override
        public List<SubversionSCM.External> perform() throws IOException, InterruptedException {
            if (!this.isUpdatable()) {
                return this.delegateTo(new CheckoutUpdater());
            }
            SVNUpdateClient svnuc = this.clientManager.getUpdateClient();
            ArrayList<SubversionSCM.External> externals = new ArrayList<SubversionSCM.External>();
            try {
                File local = new File(this.ws, this.location.getLocalDir());
                SubversionUpdateEventHandler eventHandler = new SubversionUpdateEventHandler(this.listener.getLogger(), externals, local, this.location.getLocalDir());
                svnuc.setEventHandler((ISVNEventHandler)eventHandler);
                svnuc.setExternalsHandler((ISVNExternalsHandler)eventHandler);
                SVNRevision r = this.getRevision(this.location);
                String revisionName = r.getDate() != null ? fmt.format(r.getDate()) : r.toString();
                svnuc.setIgnoreExternals(this.location.isIgnoreExternalsOption());
                this.preUpdate(this.location, local);
                this.listener.getLogger().println("Updating " + this.location.remote + " at revision " + revisionName);
                SVNDepth svnDepth = TaskImpl.getSvnDepth(this.location.getDepthOption());
                svnuc.doUpdate(local.getCanonicalFile(), r, svnDepth, true, true);
            }
            catch (SVNCancelException e) {
                if (WorkspaceUpdater.isAuthenticationFailedError(e)) {
                    e.printStackTrace(this.listener.error("Failed to check out " + this.location.remote));
                    return null;
                }
                this.listener.error("Subversion update has been canceled");
                throw (InterruptedException)new InterruptedException().initCause(e);
            }
            catch (SVNException e) {
                SVNException cause = e;
                do {
                    SVNErrorCode errorCode;
                    if ((errorCode = cause.getErrorMessage().getErrorCode()) == SVNErrorCode.WC_LOCKED) {
                        this.listener.getLogger().println("Workspace appear to be locked, so getting a fresh workspace");
                        return this.delegateTo(new CheckoutUpdater());
                    }
                    if (errorCode == SVNErrorCode.WC_OBSTRUCTED_UPDATE) {
                        this.listener.getLogger().println(e.getMessage());
                        this.listener.getLogger().println("Updated failed due to local files. Getting a fresh workspace");
                        return this.delegateTo(new CheckoutUpdater());
                    }
                    if (errorCode == SVNErrorCode.WC_CORRUPT_TEXT_BASE || errorCode == SVNErrorCode.WC_CORRUPT || errorCode == SVNErrorCode.WC_UNWIND_EMPTY) {
                        this.listener.getLogger().println(e.getMessage());
                        this.listener.getLogger().println("Updated failed due to working copy corruption. Getting a fresh workspace");
                        return this.delegateTo(new CheckoutUpdater());
                    }
                    if (errorCode != SVNErrorCode.WC_NOT_LOCKED) continue;
                    this.listener.getLogger().println("Polled jobs are " + ((SCMTrigger.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SCMTrigger.DescriptorImpl.class)).getItemsBeingPolled());
                } while (null != (cause = this.getNestedSVNException(cause)));
                e.printStackTrace(this.listener.error("Failed to update " + this.location.remote));
                this.listener.error("Subversion update failed");
                throw (IOException)new IOException().initCause(new UpdaterException("failed to perform svn update", e));
            }
            return externals;
        }

        private SVNException getNestedSVNException(Throwable e) {
            Throwable t = e.getCause();
            if (t instanceof SVNException) {
                return (SVNException)t;
            }
            if (t instanceof SVNErrorMessage) {
                return this.getNestedSVNException(t);
            }
            return null;
        }

        protected void preUpdate(SubversionSCM.ModuleLocation module, File local) throws SVNException, IOException {
        }
    }
}

