/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.scm.SubversionSCM;
import hudson.scm.listtagsparameter.ListSubversionTagsParameterValue;
import hudson.scm.listtagsparameter.SimpleSVNDirEntryHandler;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSubversionTagsParameterDefinition
extends ParameterDefinition
implements Comparable<ListSubversionTagsParameterDefinition> {
    private final String tagsDir;
    private final String tagsFilter;
    private final boolean reverseByDate;
    private final boolean reverseByName;
    private final String defaultValue;
    private final String maxTags;
    private static final String SVN_BRANCHES = "branches";
    private static final String SVN_TAGS = "tags";
    private static final String SVN_TRUNK = "trunk";
    private final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(ListSubversionTagsParameterDefinition.class.getName());

    @DataBoundConstructor
    public ListSubversionTagsParameterDefinition(String name, String tagsDir, String tagsFilter, String defaultValue, String maxTags, boolean reverseByDate, boolean reverseByName, String uuid) {
        super(name, ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("TagDescription", new Object[0]));
        this.tagsDir = Util.removeTrailingSlash((String)tagsDir);
        this.tagsFilter = tagsFilter;
        this.reverseByDate = reverseByDate;
        this.reverseByName = reverseByName;
        this.defaultValue = defaultValue;
        this.maxTags = maxTags;
        this.uuid = uuid == null || uuid.length() == 0 ? UUID.randomUUID() : UUID.fromString(uuid);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return this.getDefaultParameterValue();
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ListSubversionTagsParameterValue value = (ListSubversionTagsParameterValue)((Object)req.bindJSON(ListSubversionTagsParameterValue.class, formData));
        value.setTagsDir(this.getTagsDir());
        return value;
    }

    public ParameterValue getDefaultParameterValue() {
        if (StringUtils.isEmpty((String)this.defaultValue)) {
            return null;
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), this.defaultValue);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public List<String> getTags() {
        Integer max;
        AbstractProject context = null;
        List jobs = Hudson.getInstance().getItems(AbstractProject.class);
        block2: for (AbstractProject project : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (property == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof ListSubversionTagsParameterDefinition) || ((ListSubversionTagsParameterDefinition)pd).compareTo(this) != 0) continue;
                context = project;
                continue block2;
            }
        }
        SimpleSVNDirEntryHandler dirEntryHandler = new SimpleSVNDirEntryHandler(this.tagsFilter);
        List<Object> dirs = new ArrayList();
        try {
            ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider(context);
            ISVNAuthenticationManager authManager = SubversionSCM.createSvnAuthenticationManager(authProvider);
            SVNURL repoURL = SVNURL.parseURIDecoded((String)this.getTagsDir());
            SVNRepository repo = SVNRepositoryFactory.create((SVNURL)repoURL);
            repo.setAuthenticationManager(authManager);
            SVNLogClient logClient = new SVNLogClient(authManager, null);
            if (this.isSVNRepositoryProjectRoot(repo)) {
                dirs = this.getSVNRootRepoDirectories(logClient, repoURL);
            } else {
                logClient.doList(repoURL, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, (ISVNDirEntryHandler)dirEntryHandler);
                dirs = dirEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
            }
        }
        catch (SVNException e) {
            LOGGER.log(Level.SEVERE, "An SVN exception occurred while listing the directory entries at " + this.getTagsDir(), e);
            return Collections.singletonList("&lt;" + ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("SVNException", new Object[0]) + "&gt;");
        }
        if (dirs == null) {
            LOGGER.log(Level.INFO, "No directory entries were found for the following SVN repository: {0}", this.getTagsDir());
            return Collections.singletonList("&lt;" + ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("NoDirectoryEntriesFound", new Object[0]) + "&gt;");
        }
        this.removeParentDir(dirs);
        Integer n = max = this.isInt(this.maxTags) ? Integer.valueOf(Integer.parseInt(this.maxTags)) : null;
        if (max != null && dirs.size() > max) {
            dirs = dirs.subList(0, max);
        }
        return dirs;
    }

    public String getTagsDir() {
        return this.tagsDir;
    }

    public String getTagsFilter() {
        return this.tagsFilter;
    }

    public boolean isReverseByDate() {
        return this.reverseByDate;
    }

    public boolean isReverseByName() {
        return this.reverseByName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getMaxTags() {
        return this.maxTags;
    }

    private boolean isSVNRepositoryProjectRoot(SVNRepository repo) {
        try {
            SVNDirEntry trunkEntry = repo.info(SVN_TRUNK, SVNRevision.HEAD.getNumber());
            SVNDirEntry branchesEntry = repo.info(SVN_BRANCHES, SVNRevision.HEAD.getNumber());
            SVNDirEntry tagsEntry = repo.info(SVN_TAGS, SVNRevision.HEAD.getNumber());
            if (trunkEntry != null && branchesEntry != null && tagsEntry != null) {
                return true;
            }
        }
        catch (SVNException e) {
            return false;
        }
        return false;
    }

    private void appendTargetDir(String targetDir, List<String> dirs) {
        if (targetDir != null && dirs != null && dirs.size() > 0) {
            for (int i = 0; i < dirs.size(); ++i) {
                dirs.set(i, targetDir + '/' + dirs.get(i));
            }
        }
    }

    private boolean isInt(String value) {
        boolean isInteger = false;
        try {
            Integer.parseInt(value);
            isInteger = true;
        }
        catch (NumberFormatException e) {
            isInteger = false;
        }
        return isInteger;
    }

    private List<String> getSVNRootRepoDirectories(SVNLogClient logClient, SVNURL repoURL) throws SVNException {
        ArrayList<String> dirs = null;
        SVNURL branchesRepo = repoURL.appendPath(SVN_BRANCHES, true);
        SimpleSVNDirEntryHandler branchesEntryHandler = new SimpleSVNDirEntryHandler(null);
        logClient.doList(branchesRepo, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, (ISVNDirEntryHandler)branchesEntryHandler);
        List<String> branches = branchesEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
        branches.remove("");
        this.appendTargetDir(SVN_BRANCHES, branches);
        SVNURL tagsRepo = repoURL.appendPath(SVN_TAGS, true);
        SimpleSVNDirEntryHandler tagsEntryHandler = new SimpleSVNDirEntryHandler(null);
        logClient.doList(tagsRepo, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, (ISVNDirEntryHandler)tagsEntryHandler);
        List<String> tags = tagsEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
        tags.remove("");
        this.appendTargetDir(SVN_TAGS, tags);
        dirs = new ArrayList<String>();
        dirs.add(SVN_TRUNK);
        if (branches != null) {
            dirs.addAll(branches);
        }
        if (tags != null) {
            dirs.addAll(tags);
        }
        if (StringUtils.isNotBlank((String)this.tagsFilter)) {
            Pattern filterPattern = Pattern.compile(this.tagsFilter);
            if (dirs != null && dirs.size() > 0 && filterPattern != null) {
                ArrayList<String> temp = new ArrayList<String>();
                for (String dir : dirs) {
                    if (!filterPattern.matcher(dir).matches()) continue;
                    temp.add(dir);
                }
                dirs = temp;
            }
        }
        return dirs;
    }

    protected void removeParentDir(List<String> dirs) {
        ArrayList<String> dirsToRemove = new ArrayList<String>();
        for (String dir : dirs) {
            if (!this.getTagsDir().endsWith(dir)) continue;
            dirsToRemove.add(dir);
        }
        dirs.removeAll(dirsToRemove);
    }

    @Override
    public int compareTo(ListSubversionTagsParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private SubversionSCM.DescriptorImpl scmDescriptor;

        public ISVNAuthenticationProvider createAuthenticationProvider(AbstractProject context) {
            return this.getSubversionSCMDescriptor().createAuthenticationProvider(context);
        }

        public FormValidation doCheckDefaultValue(StaplerRequest req, @AncestorInPath AbstractProject context, @QueryParameter String value) {
            return this.getSubversionSCMDescriptor().doCheckRemote(req, context, value);
        }

        public FormValidation doCheckTagsDir(StaplerRequest req, @AncestorInPath AbstractProject context, @QueryParameter String value) {
            return this.getSubversionSCMDescriptor().doCheckRemote(req, context, value);
        }

        public FormValidation doCheckTagsFilter(@QueryParameter String value) {
            if (value != null && value.length() == 0) {
                try {
                    Pattern.compile(value);
                }
                catch (PatternSyntaxException pse) {
                    FormValidation.error((String)ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("NotValidRegex", new Object[0]));
                }
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("DisplayName", new Object[0]);
        }

        public SubversionSCM.DescriptorImpl getSubversionSCMDescriptor() {
            if (this.scmDescriptor == null) {
                this.scmDescriptor = (SubversionSCM.DescriptorImpl)Hudson.getInstance().getDescriptor(SubversionSCM.class);
            }
            return this.scmDescriptor;
        }
    }
}

