/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.thoughtworks.xstream.XStream;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.log.Logger;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.CompareAgainstBaselineCallable;
import hudson.scm.DefaultSVNLogFilter;
import hudson.scm.EnvVarsUtils;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.PerJobCredentialStore;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.SVNAuthStoreHandlerImpl;
import hudson.scm.SVNLogFilter;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionChangeLogBuilder;
import hudson.scm.SubversionChangeLogParser;
import hudson.scm.SubversionCredentialProvider;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionTagAction;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.scm.SvnClientManager;
import hudson.scm.UserProvidedCredential;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SvnHelper;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.UpdateWithRevertUpdater;
import hudson.scm.subversion.UpdaterException;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.util.EditDistance;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.MultipartFormDataParser;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.TimeUnit2;
import hudson.util.XStream2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationOutcomeListener;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionSCM
extends SCM
implements Serializable {
    private ModuleLocation[] locations = new ModuleLocation[0];
    private final SubversionRepositoryBrowser browser;
    private String excludedRegions;
    private String includedRegions;
    private String excludedUsers;
    private String excludedRevprop;
    private String excludedCommitMessages;
    private WorkspaceUpdater workspaceUpdater;
    @Deprecated
    private String modules;
    @Deprecated
    private Boolean useUpdate;
    @Deprecated
    private Boolean doRevert;
    private boolean ignoreDirPropChanges;
    private boolean filterChangelog;
    private transient Map<AbstractProject, List<External>> projectExternalsCache;
    private transient boolean pollFromMaster = POLL_FROM_MASTER;
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger LOGGER;
    public static int DEFAULT_TIMEOUT;
    private static boolean POLL_FROM_MASTER;
    public static String CONFIG_DIR;

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        this(remoteLocations, localLocations, useUpdate, browser, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(ModuleLocation.parse(remoteLocations, localLocations, null, null), useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(ModuleLocation.parse(remoteLocations, localLocations, null, null), useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(locations, useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, doRevert, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        this(locations, useUpdate ? (doRevert ? new UpdateWithRevertUpdater() : new UpdateUpdater()) : new CheckoutUpdater(), browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions);
    }

    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        this(locations, workspaceUpdater, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions, false);
    }

    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions, boolean ignoreDirPropChanges) {
        this(locations, workspaceUpdater, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions, ignoreDirPropChanges, false);
    }

    @DataBoundConstructor
    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions, boolean ignoreDirPropChanges, boolean filterChangelog) {
        Iterator<ModuleLocation> itr = locations.iterator();
        while (itr.hasNext()) {
            ModuleLocation ml = itr.next();
            String remote = Util.fixEmptyAndTrim((String)ml.remote);
            if (remote != null) continue;
            itr.remove();
        }
        this.locations = locations.toArray(new ModuleLocation[locations.size()]);
        this.workspaceUpdater = workspaceUpdater;
        this.browser = browser;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.excludedRevprop = excludedRevprop;
        this.excludedCommitMessages = excludedCommitMessages;
        this.includedRegions = includedRegions;
        this.ignoreDirPropChanges = ignoreDirPropChanges;
        this.filterChangelog = filterChangelog;
    }

    public SubversionSCM(String svnUrl) {
        this(svnUrl, ".");
    }

    public SubversionSCM(String svnUrl, String local) {
        this(new String[]{svnUrl}, new String[]{local}, true, null, null, null, null);
    }

    public SubversionSCM(String[] svnUrls, String[] locals) {
        this(svnUrls, locals, true, null, null, null, null);
    }

    public String getModules() {
        return null;
    }

    @Exported
    public ModuleLocation[] getLocations() {
        return this.getLocations(null, null);
    }

    @Exported
    public WorkspaceUpdater getWorkspaceUpdater() {
        if (this.workspaceUpdater != null) {
            return this.workspaceUpdater;
        }
        if (this.useUpdate != null && !this.useUpdate.booleanValue()) {
            return new CheckoutUpdater();
        }
        if (this.doRevert != null && this.doRevert.booleanValue()) {
            return new UpdateWithRevertUpdater();
        }
        return new UpdateUpdater();
    }

    public void setWorkspaceUpdater(WorkspaceUpdater workspaceUpdater) {
        this.workspaceUpdater = workspaceUpdater;
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        return this.getLocations(null, build);
    }

    public ModuleLocation[] getLocations(EnvVars env, AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (env == null && build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        if (env != null) {
            for (int i = 0; i < outLocations.length; ++i) {
                outLocations[i] = this.locations[i].getExpandedLocation(env);
            }
        } else {
            for (int i = 0; i < outLocations.length; ++i) {
                outLocations[i] = this.locations[i].getExpandedLocation(build);
            }
        }
        return outLocations;
    }

    public ModuleLocation[] getProjectLocations(AbstractProject project) throws IOException {
        List<External> projectExternals = this.getExternals(project);
        ModuleLocation[] configuredLocations = this.getLocations();
        if (projectExternals.isEmpty()) {
            return configuredLocations;
        }
        ArrayList<ModuleLocation> allLocations = new ArrayList<ModuleLocation>(configuredLocations.length + projectExternals.size());
        allLocations.addAll(Arrays.asList(configuredLocations));
        for (External external : projectExternals) {
            allLocations.add(new ModuleLocation(external.url, external.path));
        }
        return allLocations.toArray(new ModuleLocation[allLocations.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<External> getExternals(AbstractProject context) throws IOException {
        List<External> projectExternals;
        Map<AbstractProject, List<External>> projectExternalsCache;
        Map<AbstractProject, List<External>> map = projectExternalsCache = this.getProjectExternalsCache();
        synchronized (map) {
            projectExternals = projectExternalsCache.get(context);
        }
        if (projectExternals == null) {
            projectExternals = SubversionSCM.parseExternalsFile(context);
            map = projectExternalsCache;
            synchronized (map) {
                if (!projectExternalsCache.containsKey(context)) {
                    projectExternalsCache.put(context, projectExternals);
                }
            }
        }
        return projectExternals;
    }

    @Exported
    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return this.includedRegions == null || this.includedRegions.trim().equals("") ? null : this.includedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        if (included != null) {
            Pattern[] patterns = new Pattern[included.length];
            int i = 0;
            for (String includedRegion : included) {
                patterns[i++] = Pattern.compile(includedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    @Exported
    public String getExcludedRevprop() {
        return this.excludedRevprop;
    }

    @Exported
    public String getExcludedCommitMessages() {
        return this.excludedCommitMessages;
    }

    public String[] getExcludedCommitMessagesNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedCommitMessages);
        return s == null ? new String[]{} : s.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedCommitMessagesPatterns() {
        String[] excluded = this.getExcludedCommitMessagesNormalized();
        Pattern[] patterns = new Pattern[excluded.length];
        int i = 0;
        for (String excludedCommitMessage : excluded) {
            patterns[i++] = Pattern.compile(excludedCommitMessage);
        }
        return patterns;
    }

    @Exported
    public boolean isIgnoreDirPropChanges() {
        return this.ignoreDirPropChanges;
    }

    @Exported
    public boolean isFilterChangelog() {
        return this.filterChangelog;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] svnLocations = this.getLocations(build);
        try {
            Long rev;
            Map<String, Long> revisions = this.parseSvnRevisionFile(build);
            if (svnLocations.length == 1 && (rev = revisions.get(SvnHelper.getUrlWithoutRevision(svnLocations[0].remote))) != null) {
                env.put("SVN_REVISION", rev.toString());
                env.put("SVN_URL", svnLocations[0].getURL());
            }
            for (int i = 0; i < svnLocations.length; ++i) {
                Long rev2 = revisions.get(SvnHelper.getUrlWithoutRevision(svnLocations[i].remote));
                if (rev2 == null) continue;
                env.put("SVN_REVISION_" + (i + 1), rev2.toString());
                env.put("SVN_URL_" + (i + 1), svnLocations[i].getURL());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "error building environment variables", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals, EnvVars env) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new SubversionChangeLogBuilder(build, env, listener, this).run(externals, new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build) throws IOException {
        return SubversionSCM.parseRevisionFile(build, false, false);
    }

    Map<String, Long> parseSvnRevisionFile(AbstractBuild<?, ?> build) throws IOException {
        return SubversionSCM.parseRevisionFile(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build, boolean findClosest, boolean prunePinnedExternals) throws IOException {
        HashMap<String, Long> revisions;
        block12: {
            File file;
            revisions = new HashMap<String, Long>();
            if (findClosest) {
                for (AbstractBuild b = build; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
                    if (!SubversionSCM.getRevisionFile(b).exists()) continue;
                    build = b;
                    break;
                }
            }
            if (!(file = SubversionSCM.getRevisionFile(build)).exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block6: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index;
                    boolean isPinned = false;
                    int indexLast = line.length();
                    if (line.lastIndexOf("::p") == indexLast - 3) {
                        isPinned = true;
                        indexLast -= 3;
                    }
                    if ((index = line.lastIndexOf(47)) < 0) continue;
                    try {
                        String url = line.substring(0, index);
                        long revision = Long.parseLong(line.substring(index + 1, indexLast));
                        Long oldRevision = (Long)revisions.get(url);
                        if (isPinned) {
                            if (prunePinnedExternals || oldRevision != null) continue block6;
                            revisions.put(url, revision);
                            continue block6;
                        }
                        if (oldRevision != null && oldRevision <= revision) continue block6;
                        revisions.put(url, revision);
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.log(Level.WARNING, "Error parsing line " + line, e);
                    }
                }
                break block12;
                {
                    continue block6;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) throws IOException {
        File file = SubversionSCM.getExternalsFile(project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.XSTREAM, file).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Map<AbstractProject, List<External>> projectExternalsCache;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        EnvVarsUtils.overrideAll(env, build.getBuildVariables());
        List<External> externals = null;
        try {
            externals = this.checkout(build, workspace, (TaskListener)listener, env);
        }
        catch (UpdaterException e) {
            return false;
        }
        PrintWriter w = new PrintWriter(new FileOutputStream(SubversionSCM.getRevisionFile(build)));
        try {
            List pList = (List)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, (TaskListener)listener, externals, env));
            ArrayList<SvnInfo> revList = new ArrayList<SvnInfo>(pList.size());
            for (SvnInfoP p : pList) {
                if (p.pinned) {
                    w.println(p.info.url + '/' + p.info.revision + "::p");
                } else {
                    w.println(p.info.url + '/' + p.info.revision);
                }
                revList.add(p.info);
            }
            build.addAction((Action)new SubversionTagAction(build, revList));
        }
        finally {
            w.close();
        }
        new XmlFile(External.XSTREAM, SubversionSCM.getExternalsFile(build.getProject())).write(externals);
        Map<AbstractProject, List<External>> map = projectExternalsCache = this.getProjectExternalsCache();
        synchronized (map) {
            projectExternalsCache.put(build.getProject(), externals);
        }
        return this.calcChangeLog(build, changelogFile, listener, externals, env);
    }

    private List<External> checkout(AbstractBuild build, FilePath workspace, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        Run lsb;
        if (this.repositoryLocationsNoLongerExist(build, listener, env) && (lsb = build.getProject().getLastSuccessfulBuild()) != null && build.getNumber() - lsb.getNumber() > 10 && build.getTimestamp().getTimeInMillis() - lsb.getTimestamp().getTimeInMillis() > TimeUnit2.DAYS.toMillis(1L)) {
            listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getProject().getName() + ", project will be disabled.");
            build.getProject().makeDisabled(true);
            return null;
        }
        ArrayList<External> externals = new ArrayList<External>();
        for (ModuleLocation location : this.getLocations(env, build)) {
            externals.addAll((Collection)workspace.act((FilePath.FileCallable)new CheckOutTask(build, this, location, build.getTimestamp().getTime(), listener, env)));
        }
        return externals;
    }

    private synchronized Map<AbstractProject, List<External>> getProjectExternalsCache() {
        if (this.projectExternalsCache == null) {
            this.projectExternalsCache = new WeakHashMap<AbstractProject, List<External>>();
        }
        return this.projectExternalsCache;
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        return SubversionSCM.createClientManager(authProvider).getCore();
    }

    public static SvnClientManager createClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SubversionSCM.createSvnAuthenticationManager(authProvider);
        return new SvnClientManager(SVNClientManager.newInstance((ISVNOptions)SubversionSCM.createDefaultSVNOptions(), (ISVNAuthenticationManager)sam));
    }

    public static DefaultSVNOptions createDefaultSVNOptions() {
        DescriptorImpl descriptor;
        DefaultSVNOptions defaultOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        DescriptorImpl descriptorImpl = descriptor = Hudson.getInstance() == null ? null : (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (defaultOptions != null && descriptor != null) {
            defaultOptions.setAuthStorageEnabled(descriptor.isStoreAuthToDisk());
        }
        return defaultOptions;
    }

    public static ISVNAuthenticationManager createSvnAuthenticationManager(ISVNAuthenticationProvider authProvider) {
        File configDir = CONFIG_DIR != null ? new File(CONFIG_DIR) : SVNWCUtil.getDefaultConfigurationDirectory();
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager((File)configDir, null, null);
        sam.setAuthenticationProvider(authProvider);
        SVNAuthStoreHandlerImpl.install(sam);
        return sam;
    }

    public static SVNClientManager createSvnClientManager(AbstractProject context) {
        return SubversionSCM.createClientManager(context).getCore();
    }

    public static SvnClientManager createClientManager(AbstractProject context) {
        return new SvnClientManager(SubversionSCM.createSvnClientManager(((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).createAuthenticationProvider(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SvnClientManager manager = SubversionSCM.createClientManager(authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Map<String, Long> wsRev = SubversionSCM.parseRevisionFile(build, true, true);
        return new SVNRevisionState(wsRev);
    }

    private boolean isPollFromMaster() {
        return this.pollFromMaster;
    }

    void setPollFromMaster(boolean pollFromMaster) {
        this.pollFromMaster = pollFromMaster;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        SVNRevisionState baseline = _baseline instanceof SVNRevisionState ? (SVNRevisionState)_baseline : (project.getLastBuild() != null ? (SVNRevisionState)this.calcRevisionsFromBuild((AbstractBuild)project.getLastBuild(), launcher, listener) : new SVNRevisionState(null));
        if (project.getLastBuild() == null) {
            listener.getLogger().println(Messages.SubversionSCM_pollChanges_noBuilds());
            return PollingResult.BUILD_NOW;
        }
        AbstractBuild lastCompletedBuild = (AbstractBuild)project.getLastCompletedBuild();
        if (lastCompletedBuild != null) {
            EnvVars env = lastCompletedBuild.getEnvironment(listener);
            EnvVarsUtils.overrideAll(env, lastCompletedBuild.getBuildVariables());
            if (this.repositoryLocationsNoLongerExist(lastCompletedBuild, listener, env)) {
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationsNoLongerExist(project));
                project.makeDisabled(true);
                return PollingResult.NO_CHANGES;
            }
            for (ModuleLocation loc : this.getLocations(env, lastCompletedBuild)) {
                String url;
                try {
                    url = loc.getSVNURL().toDecodedString();
                }
                catch (SVNException ex) {
                    ex.printStackTrace(listener.error(Messages.SubversionSCM_pollChanges_exception(loc.getURL())));
                    return PollingResult.BUILD_NOW;
                }
                if (baseline.revisions.containsKey(url)) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationNotInWorkspace(url));
                return PollingResult.BUILD_NOW;
            }
        }
        LocalChannel ch = null;
        Node n = null;
        if (!this.isPollFromMaster()) {
            Computer c;
            Node node = n = lastCompletedBuild != null ? lastCompletedBuild.getBuiltOn() : null;
            if (n != null && (c = n.toComputer()) != null) {
                ch = c.getChannel();
            }
        }
        if (ch == null) {
            ch = Jenkins.MasterComputer.localChannel;
        }
        String nodeName = n != null ? n.getNodeName() : "master";
        SVNLogHandler logHandler = new SVNLogHandler(this.createSVNLogFilter(), listener);
        ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider(project);
        return (PollingResult)ch.call((Callable)new CompareAgainstBaselineCallable(baseline, logHandler, project.getName(), listener, authProvider, nodeName));
    }

    public SVNLogFilter createSVNLogFilter() {
        return new DefaultSVNLogFilter(this.getExcludedRegionsPatterns(), this.getIncludedRegionsPatterns(), this.getExcludedUsersNormalized(), this.getExcludedRevprop(), this.getExcludedCommitMessagesPatterns(), this.isIgnoreDirPropChanges());
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionChangeLogParser(this.ignoreDirPropChanges);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].getLocalDir());
        }
        return workspace;
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        EnvVars env;
        if (build == null) {
            return this.getModuleRoot(workspace);
        }
        LogTaskListener listener = new LogTaskListener(LOGGER, Level.WARNING);
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.getLocations().length > 0) {
            return this._getModuleRoot(workspace, this.getLocations()[0].getLocalDir(), env);
        }
        return workspace;
    }

    @Deprecated
    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].getLocalDir());
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public FilePath[] getModuleRoots(FilePath workspace, AbstractBuild build) {
        EnvVars env;
        if (build == null) {
            return this.getModuleRoots(workspace);
        }
        LogTaskListener listener = new LogTaskListener(LOGGER, Level.WARNING);
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = this._getModuleRoot(workspace, moduleLocations[i].getLocalDir(), env);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace, build)};
    }

    FilePath _getModuleRoot(FilePath workspace, String localDir, EnvVars env) {
        return workspace.child(env.expand(localDir));
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsNoLongerExist(AbstractBuild<?, ?> build, TaskListener listener) {
        return this.repositoryLocationsNoLongerExist(build, listener, null);
    }

    public boolean repositoryLocationsNoLongerExist(AbstractBuild<?, ?> build, TaskListener listener, EnvVars env) {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(env, build)) {
            try {
                if (this.getDescriptor().checkRepositoryPath(build.getProject(), l.getSVNURL()) != SVNNodeKind.NONE) continue;
                out.println("Location '" + l.remote + "' does not exist");
                ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
                if (params != null) {
                    LOGGER.fine("Location could be expanded on build '" + build + "' parameters values:");
                    return false;
                }
                return true;
            }
            catch (SVNException e) {
                LOGGER.log(Level.FINE, "Location check failed", e);
            }
        }
        return false;
    }

    public static void init() {
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        final Level lv = level;
        Logger.enabled = true;
        Logger.logger = new DebugLogger(){
            private final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SCPClient.class.getPackage().getName());

            public void log(int level, String className, String message) {
                this.LOGGER.log(lv, className + ' ' + message);
            }
        };
    }

    static boolean compareSVNAuthentications(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        try {
            return ((Object)SubversionSCM.describeBean(a1)).equals(SubversionSCM.describeBean(a2));
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Map describeBean(Object o) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Map m = PropertyUtils.describe((Object)o);
        for (Map.Entry entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof char[])) continue;
            char[] chars = (char[])v;
            entry.setValue(new String(chars));
        }
        return m;
    }

    private static SVNRevision getRevisionFromRemoteUrl(String remoteUrlPossiblyWithRevision) {
        int idx = remoteUrlPossiblyWithRevision.lastIndexOf(64);
        int slashIdx = remoteUrlPossiblyWithRevision.lastIndexOf(47);
        if (idx > 0 && idx > slashIdx) {
            String n = remoteUrlPossiblyWithRevision.substring(idx + 1);
            return SVNRevision.parse((String)n);
        }
        return null;
    }

    static {
        new Initializer();
        LOGGER = java.util.logging.Logger.getLogger(SubversionSCM.class.getName());
        DEFAULT_TIMEOUT = Integer.getInteger(SubversionSCM.class.getName() + ".timeout", 3600000);
        POLL_FROM_MASTER = Boolean.getBoolean(SubversionSCM.class.getName() + ".pollFromMaster");
        CONFIG_DIR = System.getProperty(SubversionSCM.class.getName() + ".configDir");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public static final class ModuleLocation
    implements Serializable {
        @Exported
        public final String remote;
        @Exported
        public final String local;
        @Exported
        public final String depthOption;
        @Exported
        public boolean ignoreExternalsOption;
        private volatile transient UUID repositoryUUID;
        private volatile transient SVNURL repositoryRoot;
        private static final long serialVersionUID = 1L;

        public ModuleLocation(String remote, String local) {
            this(remote, local, null, false);
        }

        @DataBoundConstructor
        public ModuleLocation(String remote, String local, String depthOption, boolean ignoreExternalsOption) {
            this.remote = Util.removeTrailingSlash((String)Util.fixNull((String)remote).trim());
            this.local = Util.fixEmptyAndTrim((String)local);
            this.depthOption = StringUtils.isEmpty((String)depthOption) ? SVNDepth.INFINITY.getName() : depthOption;
            this.ignoreExternalsOption = ignoreExternalsOption;
        }

        public String getLocalDir() {
            if (this.local == null) {
                return SubversionSCM.getLastPathComponent(SvnHelper.getUrlWithoutRevision(this.remote));
            }
            return this.local;
        }

        public String getURL() {
            return SvnHelper.getUrlWithoutRevision(this.remote);
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIEncoded((String)this.getURL());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UUID getUUID(AbstractProject context) throws SVNException {
            if (this.repositoryUUID == null || this.repositoryRoot == null) {
                ModuleLocation moduleLocation = this;
                synchronized (moduleLocation) {
                    SVNRepository r = this.openRepository(context);
                    r.testConnection();
                    this.repositoryUUID = UUID.fromString(r.getRepositoryUUID(false));
                    this.repositoryRoot = r.getRepositoryRoot(false);
                }
            }
            return this.repositoryUUID;
        }

        public SVNRepository openRepository(AbstractProject context) throws SVNException {
            return ((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getRepository(context, this.getSVNURL());
        }

        public SVNURL getRepositoryRoot(AbstractProject context) throws SVNException {
            this.getUUID(context);
            return this.repositoryRoot;
        }

        public SVNRevision getRevision(SVNRevision defaultValue) {
            SVNRevision revision = SubversionSCM.getRevisionFromRemoteUrl(this.remote);
            return revision != null ? revision : defaultValue;
        }

        private String getExpandedRemote(AbstractBuild<?, ?> build) {
            String outRemote = this.remote;
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outRemote = parameters.substitute(build, this.remote);
            }
            return outRemote;
        }

        private String getExpandedLocalDir(AbstractBuild<?, ?> build) {
            String outLocalDir = this.getLocalDir();
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outLocalDir = parameters.substitute(build, this.getLocalDir());
            }
            return outLocalDir;
        }

        public String getDepthOption() {
            return this.depthOption;
        }

        public boolean isIgnoreExternalsOption() {
            return this.ignoreExternalsOption;
        }

        public ModuleLocation getExpandedLocation(AbstractBuild<?, ?> build) {
            return new ModuleLocation(this.getExpandedRemote(build), this.getExpandedLocalDir(build));
        }

        public ModuleLocation getExpandedLocation(EnvVars env) {
            return new ModuleLocation(env.expand(this.remote), env.expand(this.getLocalDir()), this.getDepthOption(), this.isIgnoreExternalsOption());
        }

        public String toString() {
            return this.remote;
        }

        public static List<ModuleLocation> parse(String[] remoteLocations, String[] localLocations, String[] depthOptions, boolean[] isIgnoreExternals) {
            ArrayList<ModuleLocation> modules = new ArrayList<ModuleLocation>();
            if (remoteLocations != null && localLocations != null) {
                int entries = Math.min(remoteLocations.length, localLocations.length);
                for (int i = 0; i < entries; ++i) {
                    String remoteLoc = Util.nullify((String)remoteLocations[i]);
                    if (remoteLoc == null) continue;
                    remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
                    modules.add(new ModuleLocation(remoteLoc, Util.nullify((String)localLocations[i]), depthOptions != null ? depthOptions[i] : null, isIgnoreExternals != null && isIgnoreExternals[i]));
                }
            }
            return modules;
        }
    }

    private static final class Initializer {
        private Initializer() {
        }

        static {
            if (Boolean.getBoolean("hudson.spool-svn")) {
                DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, true, null));
            } else {
                DAVRepositoryFactory.setup();
            }
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
            if (System.getProperty("svnkit.ssh2.persistent") == null) {
                System.setProperty("svnkit.ssh2.persistent", "false");
            }
            if (System.getProperty("svnkit.http.methods") == null) {
                System.setProperty("svnkit.http.methods", "Digest,Basic,NTLM,Negotiate");
            }
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SubversionWorkspaceSelector());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<SubversionSCM>
    implements ModelObject {
        private final Map<String, Credential> credentials = new Hashtable<String, Credential>();
        private String globalExcludedRevprop = null;
        private int workspaceFormat = 8;
        private boolean validateRemoteUpToVar = false;
        private boolean storeAuthToDisk = true;
        private final transient RemotableSVNAuthenticationProviderImpl remotableProvider = new RemotableSVNAuthenticationProviderImpl();
        private static final Pattern USERNAME_PATTERN = Pattern.compile("(\\w+\\\\)?+(\\w+)");

        public SCM newInstance(StaplerRequest staplerRequest, JSONObject jsonObject) throws Descriptor.FormException {
            return (SCM)super.newInstance(staplerRequest, jsonObject);
        }

        public DescriptorImpl() {
            super(SubversionRepositoryBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public String getDisplayName() {
            return "Subversion";
        }

        public String getGlobalExcludedRevprop() {
            return this.globalExcludedRevprop;
        }

        public int getWorkspaceFormat() {
            if (this.workspaceFormat == 0) {
                return 8;
            }
            return this.workspaceFormat;
        }

        public boolean isValidateRemoteUpToVar() {
            return this.validateRemoteUpToVar;
        }

        public boolean isStoreAuthToDisk() {
            return this.storeAuthToDisk;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.globalExcludedRevprop = Util.fixEmptyAndTrim((String)req.getParameter("svn.global_excluded_revprop"));
            this.workspaceFormat = Integer.parseInt(req.getParameter("svn.workspaceFormat"));
            this.validateRemoteUpToVar = formData.containsKey((Object)"validateRemoteUpToVar");
            this.storeAuthToDisk = formData.containsKey((Object)"storeAuthToDisk");
            this.save();
            return super.configure(req, formData);
        }

        public boolean isBrowserReusable(SubversionSCM x, SubversionSCM y) {
            ModuleLocation[] yl;
            ModuleLocation[] xl = x.getLocations();
            if (xl.length != (yl = y.getLocations()).length) {
                return false;
            }
            for (int i = 0; i < xl.length; ++i) {
                if (xl[i].getURL().equals(yl[i].getURL())) continue;
                return false;
            }
            return true;
        }

        public ISVNAuthenticationProvider createAuthenticationProvider(AbstractProject<?, ?> inContextOf) {
            return new SVNAuthenticationProviderImpl(inContextOf == null ? null : new PerJobCredentialStore(inContextOf), this.remotableProvider);
        }

        public ISVNAuthenticationProvider createAuthenticationProvider() {
            return new SVNAuthenticationProviderImpl(null, this.remotableProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doPostCredential(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Item.CONFIGURE);
            MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
            StringWriter log = new StringWriter();
            PrintWriter logWriter = new PrintWriter(log);
            UserProvidedCredential upc = UserProvidedCredential.fromForm(req, parser);
            try {
                this.postCredential(parser.get("url"), upc, logWriter);
                rsp.sendRedirect("credentialOK");
            }
            catch (SVNException e) {
                logWriter.println("FAILED: " + e.getErrorMessage());
                req.setAttribute("message", (Object)log.toString());
                req.setAttribute("pre", (Object)true);
                req.setAttribute("exception", (Object)e);
                rsp.forward((Object)Hudson.getInstance(), "error", req);
            }
            finally {
                upc.close();
            }
        }

        public void postCredential(String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(null, url, username, password, keyFile, logWriter);
        }

        public void postCredential(AbstractProject inContextOf, String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(url, new UserProvidedCredential(username, password, keyFile, inContextOf), logWriter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCredential(String url, final UserProvidedCredential upc, PrintWriter logWriter) throws SVNException, IOException {
            SVNRepository repository = null;
            try {
                repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
                repository.setTunnelProvider((ISVNTunnelProvider)SubversionSCM.createDefaultSVNOptions());
                UserProvidedCredential userProvidedCredential = upc;
                userProvidedCredential.getClass();
                UserProvidedCredential.AuthenticationManagerImpl authManager = new UserProvidedCredential.AuthenticationManagerImpl(userProvidedCredential, logWriter){
                    {
                        UserProvidedCredential userProvidedCredential2 = x0;
                        userProvidedCredential2.getClass();
                        super(x1);
                    }

                    protected void onSuccess(String realm, Credential cred) {
                        LOGGER.info("Persisted " + cred + " for " + realm);
                        DescriptorImpl.this.credentials.put(realm, cred);
                        DescriptorImpl.this.save();
                        if (upc.inContextOf != null) {
                            new PerJobCredentialStore(upc.inContextOf).acknowledgeAuthentication(realm, cred);
                        }
                    }
                };
                authManager.setAuthenticationForced(true);
                repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
                repository.testConnection();
                authManager.checkIfProtocolCompleted();
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doCheckRemote(StaplerRequest req, @AncestorInPath AbstractProject context, @QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)Messages.SubversionSCM_doCheckRemote_required());
            }
            if (this.isValidateRemoteUpToVar()) {
                String string = url = url.indexOf(36) != -1 ? url.substring(0, url.indexOf(36)) : url;
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return FormValidation.errorWithMarkup((String)Messages.SubversionSCM_doCheckRemote_invalidUrl());
            }
            if (!Hudson.getInstance().hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            try {
                String urlWithoutRevision = SvnHelper.getUrlWithoutRevision(url);
                SVNURL repoURL = SVNURL.parseURIDecoded((String)urlWithoutRevision);
                if (this.checkRepositoryPath(context, repoURL) != SVNNodeKind.NONE) {
                    SVNRevision revision = SubversionSCM.getRevisionFromRemoteUrl(url);
                    if (revision == null) return FormValidation.ok();
                    if (revision.isValid()) return FormValidation.ok();
                    return FormValidation.errorWithMarkup((String)Messages.SubversionSCM_doCheckRemote_invalidRevision());
                }
                SVNRepository repository = null;
                try {
                    String repoPath;
                    repository = this.getRepository(context, repoURL);
                    long rev = repository.getLatestRevision();
                    String p = repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                    while (p.length() > 0) {
                        String head;
                        if (repository.checkPath(p = SVNPathUtil.removeTail((String)p), rev) != SVNNodeKind.DIR) continue;
                        ArrayList entries = new ArrayList();
                        repository.getDir(p, rev, false, entries);
                        ArrayList<String> paths = new ArrayList<String>();
                        for (SVNDirEntry e : entries) {
                            if (e.getKind() != SVNNodeKind.DIR) continue;
                            paths.add(e.getName());
                        }
                        String candidate = EditDistance.findNearest((String)(head = SVNPathUtil.head((String)repoPath.substring(p.length() + 1))), paths);
                        FormValidation formValidation = FormValidation.error((String)Messages.SubversionSCM_doCheckRemote_badPathSuggest(p, head, candidate != null ? "/" + candidate : ""));
                        return formValidation;
                    }
                    FormValidation formValidation = FormValidation.error((String)Messages.SubversionSCM_doCheckRemote_badPath(repoPath));
                    return formValidation;
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
            }
            catch (SVNException e) {
                LOGGER.log(Level.INFO, "Failed to access subversion repository " + url, e);
                String message = Messages.SubversionSCM_doCheckRemote_exceptionMsg1(Util.escape((String)url), Util.escape((String)e.getErrorMessage().getFullMessage()), "javascript:document.getElementById('svnerror').style.display='block';document.getElementById('svnerrorlink').style.display='none';return false;") + "<br/><pre id=\"svnerror\" style=\"display:none\">" + Functions.printThrowable((Throwable)e) + "</pre>" + Messages.SubversionSCM_doCheckRemote_exceptionMsg2("descriptorByName/" + SubversionSCM.class.getName() + "/enterCredential?" + url);
                return FormValidation.errorWithMarkup((String)message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SVNNodeKind checkRepositoryPath(AbstractProject context, SVNURL repoURL) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(context, repoURL);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        protected SVNRepository getRepository(AbstractProject context, SVNURL repoURL) throws SVNException {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL);
            ISVNAuthenticationManager sam = SubversionSCM.createSvnAuthenticationManager(this.createAuthenticationProvider(context));
            sam = new FilterSVNAuthenticationManager(sam){

                public int getReadTimeout(SVNRepository repository) {
                    int r = super.getReadTimeout(repository);
                    if (r <= 0) {
                        r = DEFAULT_TIMEOUT;
                    }
                    return r;
                }
            };
            repository.setTunnelProvider((ISVNTunnelProvider)SubversionSCM.createDefaultSVNOptions());
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(false).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        public FormValidation doCheckLocal(@QueryParameter String value) throws IOException, ServletException {
            String v = Util.nullify((String)value);
            if (v == null) {
                return FormValidation.ok();
            }
            if ((v = v.trim()).startsWith("/") || v.startsWith("\\") || v.startsWith("..") || v.matches("^[A-Za-z]:.*")) {
                return FormValidation.error((String)"absolute path is not allowed");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExcludedRegions(@QueryParameter String value) throws IOException, ServletException {
            for (String region : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                try {
                    Pattern.compile(region);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIncludedRegions(@QueryParameter String value) throws IOException, ServletException {
            return this.doCheckExcludedRegions(value);
        }

        public FormValidation doCheckExcludedUsers(@QueryParameter String value) throws IOException, ServletException {
            for (String user : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                if ("".equals(user = user.trim()) || USERNAME_PATTERN.matcher(user).matches()) continue;
                return FormValidation.error((String)("Invalid username: " + user));
            }
            return FormValidation.ok();
        }

        public List<WorkspaceUpdaterDescriptor> getWorkspaceUpdaterDescriptors() {
            return WorkspaceUpdaterDescriptor.all();
        }

        public FormValidation doCheckExcludedCommitMessages(@QueryParameter String value) throws IOException, ServletException {
            for (String message : Util.fixNull((String)value).trim().split("[\\r\\n]+")) {
                try {
                    Pattern.compile(message);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doCheckRevisionPropertiesSupported(@AncestorInPath AbstractProject context, @QueryParameter String value) throws IOException, ServletException {
            String v = Util.fixNull((String)value).trim();
            if (v.length() == 0) {
                return FormValidation.ok();
            }
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                SVNURL repoURL = SVNURL.parseURIDecoded((String)v);
                if (this.checkRepositoryPath(context, repoURL) != SVNNodeKind.NONE) {
                    return FormValidation.ok();
                }
                SVNRepository repository = null;
                try {
                    repository = this.getRepository(context, repoURL);
                    if (!repository.hasCapability(SVNCapability.LOG_REVPROPS)) return FormValidation.warning((String)Messages.SubversionSCM_excludedRevprop_notSupported(v));
                    FormValidation formValidation = FormValidation.ok();
                    return formValidation;
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
            }
            catch (SVNException e) {
                String message = "";
                message = message + "Unable to access " + Util.escape((String)v) + " : " + Util.escape((String)e.getErrorMessage().getFullMessage());
                LOGGER.log(Level.INFO, "Failed to access subversion repository " + v, e);
                return FormValidation.errorWithMarkup((String)message);
            }
        }

        static {
            new Initializer();
        }

        static final class SVNAuthenticationProviderImpl
        implements ISVNAuthenticationProvider,
        ISVNAuthenticationOutcomeListener,
        Serializable {
            private final RemotableSVNAuthenticationProvider local;
            private final RemotableSVNAuthenticationProvider global;
            private Credential lastCredential;
            private static final long serialVersionUID = 1L;

            public SVNAuthenticationProviderImpl(RemotableSVNAuthenticationProvider local, RemotableSVNAuthenticationProvider global) {
                this.global = global;
                this.local = local;
            }

            private SVNAuthentication fromProvider(SVNURL url, String realm, String kind, RemotableSVNAuthenticationProvider src, String debugName) throws SVNException {
                if (src == null) {
                    return null;
                }
                Credential cred = src.getCredential(url, realm);
                LOGGER.fine(String.format("%s.requestClientAuthentication(%s,%s,%s)=>%s", debugName, kind, url, realm, cred));
                this.lastCredential = cred;
                if (cred != null) {
                    return cred.createSVNAuthentication(kind);
                }
                return null;
            }

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                try {
                    SVNAuthentication auth = this.fromProvider(url, realm, kind, this.local, "local");
                    if (auth == null || SubversionSCM.compareSVNAuthentications(auth, previousAuth)) {
                        auth = this.fromProvider(url, realm, kind, this.global, "global");
                    }
                    if (previousAuth != null && SubversionSCM.compareSVNAuthentications(auth, previousAuth)) {
                        LOGGER.log(Level.FINE, "Previous authentication attempt failed, so aborting: {0}", previousAuth);
                        return null;
                    }
                    if (auth == null && "svn.username".equals(kind)) {
                        return new SVNUserNameAuthentication("", false);
                    }
                    return auth;
                }
                catch (SVNException e) {
                    LOGGER.log(Level.SEVERE, "Failed to authorize", e);
                    throw new RuntimeException("Failed to authorize", e);
                }
            }

            public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
                if (accepted && this.local != null && this.lastCredential != null) {
                    this.local.acknowledgeAuthentication(realm, this.lastCredential);
                }
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 1;
            }
        }

        private final class RemotableSVNAuthenticationProviderImpl
        implements RemotableSVNAuthenticationProvider {
            private static final long serialVersionUID = 1243451839093253666L;

            private RemotableSVNAuthenticationProviderImpl() {
            }

            public Credential getCredential(SVNURL url, String realm) {
                for (SubversionCredentialProvider p : SubversionCredentialProvider.all()) {
                    Credential c = p.getCredential(url, realm);
                    if (c == null) continue;
                    LOGGER.fine(String.format("getCredential(%s)=>%s by %s", realm, c, p));
                    return c;
                }
                LOGGER.fine(String.format("getCredential(%s)=>%s", realm, DescriptorImpl.this.credentials.get(realm)));
                return (Credential)DescriptorImpl.this.credentials.get(realm);
            }

            public void acknowledgeAuthentication(String realm, Credential credential) {
            }

            private Object writeReplace() {
                return Channel.current().export(RemotableSVNAuthenticationProvider.class, (Object)this);
            }
        }

        static interface RemotableSVNAuthenticationProvider
        extends Serializable {
            public Credential getCredential(SVNURL var1, String var2);

            public void acknowledgeAuthentication(String var1, Credential var2);
        }

        public static final class SslClientCertificateCredential
        extends Credential {
            private static final long serialVersionUID = 5455755079546887446L;
            private final Secret certificate;
            private final String password;

            public SslClientCertificateCredential(File certificate, String password) throws IOException {
                this.password = Scrambler.scramble((String)password);
                this.certificate = Secret.fromString((String)new String(Base64.encode((byte[])FileUtils.readFileToByteArray((File)certificate))));
            }

            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssl.client-passphrase")) {
                    try {
                        return new SVNSSLAuthentication(Base64.decode((char[])this.certificate.getPlainText().toCharArray()), Scrambler.descramble((String)this.password), false);
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }
        }

        public static final class SshPublicKeyCredential
        extends Credential {
            private static final long serialVersionUID = -4649332611621900514L;
            private final String userName;
            private final String passphrase;
            private final String id;

            public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
                this.userName = userName;
                this.passphrase = Scrambler.scramble((String)passphrase);
                Random r = new Random();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    buf.append(Integer.toHexString(r.nextInt(16)));
                }
                this.id = buf.toString();
                try {
                    File savedKeyFile = this.getKeyFile();
                    FileUtils.copyFile((File)keyFile, (File)savedKeyFile);
                    this.setFilePermissions(savedKeyFile, "600");
                }
                catch (IOException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to save private key").initCause((Throwable)e));
                }
            }

            private File getKeyFile() {
                File dir = new File(Hudson.getInstance().getRootDir(), "subversion-credentials");
                if (dir.mkdirs()) {
                    this.setFilePermissions(dir, "600");
                }
                return new File(dir, this.id);
            }

            private boolean setFilePermissions(File file, String perms) {
                try {
                    Chmod chmod = new Chmod();
                    chmod.setProject(new Project());
                    chmod.setFile(file);
                    chmod.setPerm(perms);
                    chmod.execute();
                }
                catch (BuildException e) {
                    LOGGER.log(Level.WARNING, "Failed to set permission of " + file, e);
                    return false;
                }
                return true;
            }

            public SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
                if (kind.equals("svn.ssh")) {
                    try {
                        Channel channel = Channel.current();
                        String privateKey = channel != null ? (String)channel.call((Callable)new Callable<String, IOException>(){
                            private static final long serialVersionUID = -3088632649290496373L;

                            public String call() throws IOException {
                                return FileUtils.readFileToString((File)SshPublicKeyCredential.this.getKeyFile(), (String)"iso-8859-1");
                            }
                        }) : FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1");
                        return new SVNSSHAuthentication(this.userName, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key").initCause((Throwable)e));
                    }
                    catch (InterruptedException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key").initCause((Throwable)e));
                    }
                }
                return null;
            }
        }

        public static final class PasswordCredential
        extends Credential {
            private static final long serialVersionUID = -1676145651108866745L;
            private final String userName;
            private final String password;

            public PasswordCredential(String userName, String password) {
                this.userName = userName;
                this.password = Scrambler.scramble((String)password);
            }

            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, Scrambler.descramble((String)this.password), -1, false);
                }
                return new SVNPasswordAuthentication(this.userName, Scrambler.descramble((String)this.password), false);
            }
        }

        public static abstract class Credential
        implements Serializable {
            private static final long serialVersionUID = -3707951427730113110L;

            public abstract SVNAuthentication createSVNAuthentication(String var1) throws SVNException;
        }
    }

    static final class SVNLogHandler
    implements ISVNLogEntryHandler,
    Serializable {
        private boolean changesFound = false;
        private SVNLogFilter filter;
        private static final long serialVersionUID = 1L;

        SVNLogHandler(SVNLogFilter svnLogFilter, TaskListener listener) {
            this.filter = svnLogFilter;
            this.filter.setTaskListener(listener);
        }

        public boolean isChangesFound() {
            return this.changesFound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean findNonExcludedChanges(SVNURL url, long from, long to, ISVNAuthenticationProvider authProvider) throws SVNException {
            if (from > to) {
                return false;
            }
            if (!this.filter.hasExclusionRule()) {
                return true;
            }
            SvnClientManager manager = SubversionSCM.createClientManager(authProvider);
            try {
                manager.getLogClient().doLog(url, null, SVNRevision.UNDEFINED, SVNRevision.create((long)from), SVNRevision.create((long)to), false, true, false, 0L, null, (ISVNLogEntryHandler)this);
            }
            finally {
                manager.dispose();
            }
            return this.isChangesFound();
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.filter.isIncluded(logEntry)) {
                this.changesFound = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildRevisionMapTask
    implements FilePath.FileCallable<List<SvnInfoP>> {
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener listener;
        private final List<External> externals;
        private final ModuleLocation[] locations;
        private static final long serialVersionUID = 1L;

        public BuildRevisionMapTask(AbstractBuild<?, ?> build, SubversionSCM parent, TaskListener listener, List<External> externals, EnvVars env) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
            this.listener = listener;
            this.externals = externals;
            this.locations = parent.getLocations(env, build);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SvnInfoP> invoke(File ws, VirtualChannel channel) throws IOException {
            ArrayList<SvnInfoP> revisions = new ArrayList<SvnInfoP>();
            SvnClientManager manager = SubversionSCM.createClientManager(this.authProvider);
            try {
                SVNWCClient svnWc = manager.getWCClient();
                for (ModuleLocation module : this.locations) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, module.getLocalDir()), SVNRevision.WORKING));
                        revisions.add(new SvnInfoP(info, false));
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for " + module.remote));
                    }
                }
                for (External ext : this.externals) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, ext.path), SVNRevision.WORKING));
                        revisions.add(new SvnInfoP(info, ext.isRevisionFixed()));
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for external " + ext.url + " at " + ext.path));
                    }
                }
                ArrayList<SvnInfoP> arrayList = revisions;
                return arrayList;
            }
            finally {
                manager.dispose();
            }
        }
    }

    public static final class External
    implements Serializable {
        public final String path;
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;
        private static final XStream XSTREAM = new XStream2();

        public External(String path, SVNURL url, long revision) {
            this.path = path;
            this.url = url.toDecodedString();
            this.revision = revision;
        }

        public boolean isRevisionFixed() {
            return this.revision != -1L;
        }

        static {
            XSTREAM.alias("external", External.class);
        }
    }

    private static final class SvnInfoP
    implements Serializable {
        public final SvnInfo info;
        public final boolean pinned;
        private static final long serialVersionUID = 1L;

        public SvnInfoP(SvnInfo info, boolean pinned) {
            this.info = info;
            this.pinned = pinned;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SvnInfo
    implements Serializable,
    Comparable<SvnInfo> {
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;

        public SvnInfo(String url, long revision) {
            this.url = url;
            this.revision = revision;
        }

        public SvnInfo(SVNInfo info) {
            this(info.getURL().toDecodedString(), info.getCommittedRevision().getNumber());
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIDecoded((String)this.url);
        }

        @Override
        public int compareTo(SvnInfo that) {
            int r = this.url.compareTo(that.url);
            if (r != 0) {
                return r;
            }
            if (this.revision < that.revision) {
                return -1;
            }
            if (this.revision > that.revision) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SvnInfo svnInfo = (SvnInfo)o;
            return this.revision == svnInfo.revision && this.url.equals(svnInfo.url);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s (rev.%s)", this.url, this.revision);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckOutTask
    extends WorkspaceUpdater.UpdateTask
    implements FilePath.FileCallable<List<External>> {
        private final WorkspaceUpdater.UpdateTask task;
        private static final long serialVersionUID = 1L;

        public CheckOutTask(AbstractBuild<?, ?> build, SubversionSCM parent, ModuleLocation location, Date timestamp, TaskListener listener, EnvVars env) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
            this.timestamp = timestamp;
            this.listener = listener;
            this.location = location;
            this.revisions = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
            this.task = parent.getWorkspaceUpdater().createTask();
        }

        public List<External> invoke(File ws, VirtualChannel channel) throws IOException {
            this.clientManager = SubversionSCM.createClientManager(this.authProvider);
            this.manager = this.clientManager.getCore();
            this.ws = ws;
            try {
                List<External> externals = this.perform();
                this.checkClockOutOfSync();
                List<External> list = externals;
                return list;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            finally {
                this.clientManager.dispose();
            }
        }

        @Override
        public List<External> perform() throws IOException, InterruptedException {
            return this.delegateTo(this.task);
        }

        private void checkClockOutOfSync() {
            try {
                SVNDirEntry dir = this.clientManager.createRepository(this.location.getSVNURL(), true).info("/", -1L);
                if (dir != null && dir.getDate() != null && dir.getDate().after(new Date())) {
                    this.listener.getLogger().println(Messages.SubversionSCM_ClockOutOfSync());
                }
            }
            catch (SVNAuthenticationException e) {
                LOGGER.log(Level.FINE, "Failed to estimate the remote time stamp", e);
            }
            catch (SVNException e) {
                LOGGER.log(Level.INFO, "Failed to estimate the remote time stamp", e);
            }
        }
    }
}

