/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import hudson.util.QueryParameterMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;

public class SubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private JobProvider jobProvider = new JobProvider(){

        @Override
        public List<AbstractProject> getAllJobs() {
            return Hudson.getInstance().getAllItems(AbstractProject.class);
        }
    };
    private static Method IS_IGNORE_POST_COMMIT_HOOKS_METHOD;
    private static final Logger LOGGER;

    public SubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    void setJobProvider(JobProvider jobProvider) {
        this.jobProvider = jobProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        BufferedReader r = new BufferedReader(req.getReader());
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Reading line: " + line);
                }
                affectedPath.add(line.substring(4));
                if (!line.startsWith("svnlook changed --revision ")) continue;
                String msg = "Expecting the output from the svnlook command but instead you just sent me the svnlook invocation command line: " + line;
                LOGGER.warning(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        boolean scmFound = false;
        boolean triggerFound = false;
        boolean uuidFound = false;
        boolean pathFound = false;
        QueryParameterMap query = new QueryParameterMap((HttpServletRequest)req);
        String revParam = query.get("rev");
        if (revParam == null) {
            revParam = req.getHeader("X-Hudson-Subversion-Revision");
        }
        long rev = -1L;
        if (revParam != null) {
            rev = Long.parseLong(revParam);
        }
        for (AbstractProject p : this.jobProvider.getAllJobs()) {
            if (p.isDisabled()) continue;
            try {
                SCM scm = p.getScm();
                if (!(scm instanceof SubversionSCM)) continue;
                scmFound = true;
                SCMTrigger trigger = (SCMTrigger)p.getTrigger(SCMTrigger.class);
                if (trigger == null || this.doesIgnorePostCommitHooks(trigger)) continue;
                triggerFound = true;
                SubversionSCM sscm = (SubversionSCM)scm;
                ArrayList<SubversionSCM.SvnInfo> infos = new ArrayList<SubversionSCM.SvnInfo>();
                boolean projectMatches = false;
                for (SubversionSCM.ModuleLocation loc : sscm.getProjectLocations(p)) {
                    String n;
                    if (!loc.getUUID(p).equals(this.uuid)) continue;
                    uuidFound = true;
                    String m = loc.getSVNURL().getPath();
                    if (!m.startsWith(n = loc.getRepositoryRoot(p).getPath())) continue;
                    String remaining = m.substring(n.length());
                    if (remaining.startsWith("/")) {
                        remaining = remaining.substring(1);
                    }
                    String remainingSlash = remaining + '/';
                    if (rev != -1L) {
                        infos.add(new SubversionSCM.SvnInfo(loc.getURL(), rev));
                    }
                    for (String path : affectedPath) {
                        if (!path.equals(remaining) && !path.startsWith(remainingSlash) && remaining.length() != 0) continue;
                        projectMatches = true;
                        pathFound = true;
                    }
                }
                if (!projectMatches) continue;
                LOGGER.fine("Scheduling the immediate polling of " + p);
                RevisionParameterAction[] actions = infos.isEmpty() ? new RevisionParameterAction[]{} : new RevisionParameterAction[]{new RevisionParameterAction(infos)};
                trigger.run((Action[])actions);
            }
            catch (SVNException e) {
                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
            }
        }
        if (!scmFound) {
            LOGGER.warning("No subversion jobs found");
        } else if (!triggerFound) {
            LOGGER.warning("No subversion jobs using SCM polling or all jobs using SCM polling are ignoring post-commit hooks");
        } else if (!uuidFound) {
            LOGGER.warning("No subversion jobs using repository: " + this.uuid);
        } else if (!pathFound) {
            LOGGER.fine("No jobs found matching the modified files");
        }
        rsp.setStatus(200);
    }

    private boolean doesIgnorePostCommitHooks(SCMTrigger trigger) {
        if (IS_IGNORE_POST_COMMIT_HOOKS_METHOD == null) {
            return false;
        }
        try {
            return (Boolean)IS_IGNORE_POST_COMMIT_HOOKS_METHOD.invoke((Object)trigger, (Object[])null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure when calling isIgnorePostCommitHooks", e);
            return false;
        }
    }

    static {
        try {
            IS_IGNORE_POST_COMMIT_HOOKS_METHOD = SCMTrigger.class.getMethod("isIgnorePostCommitHooks", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(SubversionRepositoryStatus.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface JobProvider {
        public List<AbstractProject> getAllJobs();
    }
}

