/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;

public class UninstantiatedDescribable
implements Serializable {
    private String symbol;
    private String klass;
    private final Map<String, ?> arguments;
    private DescribableModel model;
    private static final long serialVersionUID = 1L;
    public static final String ANONYMOUS_KEY = "<anonymous>";

    public UninstantiatedDescribable(String symbol, String klass, Map<String, ?> arguments) {
        this.symbol = symbol;
        this.klass = klass;
        this.arguments = arguments;
    }

    public UninstantiatedDescribable(Map<String, ?> arguments) {
        this(null, null, arguments);
    }

    public UninstantiatedDescribable withArguments(Map<String, ?> arguments) {
        UninstantiatedDescribable copy = new UninstantiatedDescribable(this.symbol, this.klass, arguments);
        copy.model = this.model;
        return copy;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Nullable
    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    @CheckForNull
    public DescribableModel getModel() {
        return this.model;
    }

    public void setModel(DescribableModel model) {
        this.model = model;
    }

    public Map<String, ?> getArguments() {
        return this.arguments;
    }

    public boolean hasSoleRequiredArgument() {
        if (this.arguments.size() != 1) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        DescribableParameter p = this.model.getSoleRequiredParameter();
        if (p == null) {
            return false;
        }
        return this.arguments.containsKey(p.getName());
    }

    public Map<String, Object> toMap() {
        Map<String, Object> r = this.toShallowMap();
        for (Map.Entry<String, ?> e : this.arguments.entrySet()) {
            Object v = e.getValue();
            if ((v = UninstantiatedDescribable.toMap(v)) instanceof List) {
                ArrayList<Object> l = new ArrayList<Object>(((List)v).size());
                for (Object o : (List)v) {
                    l.add(UninstantiatedDescribable.toMap(o));
                }
                v = l;
            }
            r.put(e.getKey(), v);
        }
        return r;
    }

    public Map<String, Object> toShallowMap() {
        TreeMap<String, Object> r = new TreeMap<String, Object>(this.arguments);
        if (this.klass != null) {
            r.put("$class", this.klass);
        }
        return r;
    }

    private static Object toMap(Object v) {
        if (v instanceof UninstantiatedDescribable) {
            UninstantiatedDescribable ud = (UninstantiatedDescribable)v;
            return ud.toMap();
        }
        return v;
    }

    public Object instantiate() throws Exception {
        DescribableModel m = this.getModel();
        return this.instantiate(m != null ? m.getType() : Object.class);
    }

    public <T> T instantiate(Class<T> base) throws Exception {
        Class<T> c = DescribableModel.resolveClass(base, this.klass, this.symbol);
        return base.cast(new DescribableModel<T>(c).instantiate(this.arguments));
    }

    public static UninstantiatedDescribable from(Object o) {
        return DescribableModel.uninstantiate2_(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UninstantiatedDescribable that = (UninstantiatedDescribable)o;
        if (this.symbol != null ? !this.symbol.equals(that.symbol) : that.symbol != null) {
            return false;
        }
        if (this.klass != null ? !this.klass.equals(that.klass) : that.klass != null) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.symbol != null ? this.symbol.hashCode() : 0;
        result = 31 * result + (this.klass != null ? this.klass.hashCode() : 0);
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.symbol != null) {
            b.append('@').append(this.symbol);
        }
        if (this.klass != null) {
            b.append('$').append(this.klass);
        }
        b.append('(');
        boolean first = true;
        for (Map.Entry<String, ?> e : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(e.getKey()).append('=').append(e.getValue());
        }
        b.append(')');
        return b.toString();
    }
}

