/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.codehaus.groovy.tools.Utilities;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.annotation_indexer.Index;

@Extension
public class SymbolLookup {
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>();
    private final ConcurrentMap<Key, Object> noHitCache = new ConcurrentHashMap<Key, Object>();
    static final Object NO_HIT = new Object();
    @Inject
    PluginManager pluginManager;
    @Inject
    Jenkins jenkins;
    Set<String> pluginNames = Collections.EMPTY_SET;
    private static final Logger LOGGER = Logger.getLogger(SymbolLookup.class.getName());

    private static HashSet<String> pluginsToNames(List<PluginWrapper> plugins) {
        HashSet<String> pluginNames = new HashSet<String>(plugins.size());
        for (PluginWrapper pw : plugins) {
            pluginNames.add(pw.getShortName());
        }
        return pluginNames;
    }

    private synchronized void checkPluginsForChangeAndRefresh() {
        List wrap = this.pluginManager.getPlugins();
        HashSet<String> names = SymbolLookup.pluginsToNames(wrap);
        if (wrap.size() != this.pluginNames.size() || !this.pluginNames.containsAll(names)) {
            this.pluginNames = names;
            this.noHitCache.clear();
            return;
        }
    }

    public <T> T find(Class<T> type, String symbol) {
        try {
            Key k = new Key("find", type, symbol);
            Object i = this.cache.get(k);
            if (i != null) {
                return type.cast(i);
            }
            if (!Utilities.isJavaIdentifier((String)symbol)) {
                return null;
            }
            this.checkPluginsForChangeAndRefresh();
            Object miss = this.noHitCache.get(k);
            if (miss == NO_HIT) {
                return null;
            }
            for (Class e : Index.list(Symbol.class, (ClassLoader)this.pluginManager.uberClassLoader, Class.class)) {
                Symbol s;
                if (!type.isAssignableFrom(e) || (s = e.getAnnotation(Symbol.class)) == null) continue;
                for (String t : s.value()) {
                    if (!t.equals(symbol)) continue;
                    i = this.jenkins.getInjector().getInstance(e);
                    this.cache.put(k, i);
                    return type.cast(i);
                }
            }
            this.noHitCache.put(k, NO_HIT);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to find @Symbol", e);
            return null;
        }
    }

    public Descriptor<?> findDescriptor(Class<?> type, String symbol) {
        try {
            Key k = new Key("findDescriptor", type, symbol);
            Object i = this.cache.get(k);
            if (i != null) {
                return (Descriptor)i;
            }
            if (!Utilities.isJavaIdentifier((String)symbol)) {
                return null;
            }
            this.checkPluginsForChangeAndRefresh();
            Object miss = this.noHitCache.get(k);
            if (miss == NO_HIT) {
                return null;
            }
            for (Class e : Index.list(Symbol.class, (ClassLoader)this.pluginManager.uberClassLoader, Class.class)) {
                Symbol s;
                if (!Descriptor.class.isAssignableFrom(e) || (s = e.getAnnotation(Symbol.class)) == null) continue;
                for (String t : s.value()) {
                    if (!t.equals(symbol)) continue;
                    Descriptor d = (Descriptor)this.jenkins.getInjector().getInstance(e);
                    if (!type.isAssignableFrom(d.clazz)) continue;
                    this.cache.put(k, d);
                    return d;
                }
            }
            this.noHitCache.put(k, NO_HIT);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to find @Symbol", e);
            return null;
        }
    }

    public static SymbolLookup get() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException();
        }
        return (SymbolLookup)j.getInjector().getInstance(SymbolLookup.class);
    }

    @Nonnull
    public static Set<String> getSymbolValue(@Nonnull Object o) {
        if (o instanceof Describable) {
            return SymbolLookup.getSymbolValue(((Describable)o).getDescriptor().getClass());
        }
        return SymbolLookup.getSymbolValue(o.getClass());
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() can return null in theory.")
    public static Set<String> getSymbolValue(@Nonnull Class<?> c) {
        LinkedHashSet<String> symbolValues = new LinkedHashSet<String>();
        Jenkins j = Jenkins.getInstanceOrNull();
        if (Describable.class.isAssignableFrom(c) && !Descriptor.class.isAssignableFrom(c) && j != null) {
            Descriptor d = j.getDescriptor(c.asSubclass(Describable.class));
            if (d != null) {
                symbolValues.addAll(SymbolLookup.getSymbolValue(d));
            }
        } else {
            Symbol s = c.getAnnotation(Symbol.class);
            if (s != null) {
                Collections.addAll(symbolValues, s.value());
            } else if (j != null && ParameterValue.class.isAssignableFrom(c)) {
                try {
                    symbolValues.addAll(SymbolLookup.getSymbolValue(c.getClassLoader().loadClass(c.getName().replaceFirst("Value$", "Definition"))));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return symbolValues;
    }

    private static class Key {
        private final String tag;
        private final Class type;
        private final String name;

        public Key(String tag, Class type, String name) {
            this.tag = tag;
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.type == key.type && this.tag.equals(key.tag) && this.name.equals(key.name);
        }

        public int hashCode() {
            int h = this.type.hashCode();
            h = h * 31 + this.tag.hashCode();
            h = h * 31 + this.name.hashCode();
            return h;
        }
    }
}

