/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.gssh.client;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jenkins.plugins.ssh2easy.gssh.GsshPluginException;
import jenkins.plugins.ssh2easy.gssh.ServerGroup;
import jenkins.plugins.ssh2easy.gssh.client.DefaultSshClient;
import jenkins.plugins.ssh2easy.gssh.client.SshClient;
import org.apache.log4j.Logger;

public class JenkinsSshClient
extends DefaultSshClient {
    private static final Logger LOG = Logger.getLogger(JenkinsSshClient.class);

    public JenkinsSshClient(String ip, int port, String username, String password) {
        super(ip, port, username, password);
    }

    public JenkinsSshClient(ServerGroup serverGroup, String ip) {
        super(serverGroup, ip);
    }

    public static SshClient newInstance(String ip, int port, String username, String password) {
        return new JenkinsSshClient(ip, port, username, password);
    }

    public static SshClient newInstance(ServerGroup group, String ip) {
        return new JenkinsSshClient(group, ip);
    }

    public Connection getConnection() throws IOException {
        Connection conn = new Connection(this.getIp(), this.getPort());
        conn.connect();
        boolean isAuthenticated = conn.authenticateWithPassword(this.getUsername(), this.getPassword());
        if (!isAuthenticated) {
            throw new IOException("Authentication failed.");
        }
        LOG.info((Object)("create ssh session success with ip=[" + this.getIp() + "],port=[" + this.getPort() + "],username=[" + this.getUsername() + "],password=[*******]"));
        return conn;
    }

    @Override
    public int executeCommand(PrintStream logger, String command) {
        Connection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            logger.println("create ssh session failed with ip=[" + this.getIp() + "],port=[" + this.getPort() + "],username=[" + this.getUsername() + "],password=[*******]");
            e.printStackTrace(logger);
            throw new GsshPluginException(e);
        }
        Session session = null;
        String wrappedCommand = this.wrapperInput(command);
        try {
            session = conn.openSession();
            session.requestPTY("dumb");
            session.startShell();
            ExecutorService exec = Executors.newSingleThreadExecutor();
            Future<Boolean> task = exec.submit(new OutputTask(session, logger));
            PrintWriter out = new PrintWriter(session.getStdin());
            String[] commands = wrappedCommand.split("\n");
            for (int i = 0; i < commands.length; ++i) {
                String cmd = commands[i];
                if ("".equals(cmd.trim())) continue;
                out.println(cmd);
            }
            out.close();
            task.get();
            exec.shutdown();
            int status = session.getExitStatus();
            logger.println("execute command exit status -->" + status);
            int n = status;
            return n;
        }
        catch (Exception e) {
            String msg = "execute commds=[" + wrappedCommand + "]failed !";
            logger.println(msg);
            e.printStackTrace(logger);
            throw new GsshPluginException(msg, e);
        }
        finally {
            if (null != session) {
                session.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
    }

    class OutputTask
    implements Callable<Boolean> {
        private PrintStream logger;
        private Session session;

        public boolean execute() throws IOException, InterruptedException {
            InputStream stdout = this.session.getStdout();
            InputStream stderr = this.session.getStderr();
            byte[] buffer = new byte[8192];
            boolean result = true;
            do {
                int len;
                if (stdout.available() == 0 && stderr.available() == 0) {
                    int conditions = this.session.waitForCondition(44, 0L);
                    if ((conditions & 1) != 0) {
                        this.logger.println("wait timeout and exit now !");
                        break;
                    }
                    if ((conditions & 0x20) != 0) break;
                }
                while (stdout.available() > 0) {
                    len = stdout.read(buffer);
                    if (len <= 0) continue;
                    this.logger.write(buffer, 0, len);
                }
                while (stderr.available() > 0) {
                    len = stderr.read(buffer);
                    if (len > 0) {
                        this.logger.write(buffer, 0, len);
                    }
                    result = false;
                }
            } while (result);
            this.logger.println("####################################");
            return result;
        }

        @Override
        public Boolean call() throws Exception {
            Thread.sleep(2000L);
            return this.execute();
        }

        public OutputTask(Session session, PrintStream logger) {
            this.session = session;
            this.logger = logger;
        }
    }
}

