/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import java.util.Map;
import java.util.Set;

public class VariableReplacerUtil {
    public static String preludeWithEnvVars(String originalCommand, Map<String, String> vars) {
        if (originalCommand == null) {
            return null;
        }
        if (vars == null) {
            return originalCommand;
        }
        vars.remove("_");
        StringBuilder sb = new StringBuilder();
        for (String variable : vars.keySet()) {
            if (!originalCommand.contains(variable)) continue;
            sb.append(variable).append("=\"").append(vars.get(variable)).append("\"\n");
        }
        sb.append("\n");
        sb.append(originalCommand);
        return sb.toString();
    }

    public static String scrub(String command, Map<String, String> vars, Set<String> eyesOnlyVars) {
        if (command == null || vars == null || eyesOnlyVars == null) {
            return command;
        }
        vars.remove("_");
        block0: for (String sensitive : eyesOnlyVars) {
            for (String variable : vars.keySet()) {
                if (!variable.equals(sensitive)) continue;
                String value = vars.get(variable);
                if (!command.contains(value)) continue block0;
                if (command.contains("\"" + value + "\"")) {
                    command = command.replace("\"" + value + "\"", "**********");
                }
                command = command.replace(value, "**********");
                continue block0;
            }
        }
        return command;
    }
}

