/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.KnownHosts;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class KnownHostsFileKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    public static final String KNOWN_HOSTS_DEFAULT = Paths.get(System.getProperty("user.home"), ".ssh", "known_hosts").toString();
    public static final String KNOWN_HOSTS_PROPERTY = KnownHostsFileKeyVerificationStrategy.class.getName() + ".known_hosts_file";
    private static final String KNOWN_HOSTS_FILE_PATH = StringUtils.defaultIfBlank((String)System.getProperty(KNOWN_HOSTS_PROPERTY), (String)KNOWN_HOSTS_DEFAULT);
    private static final File KNOWN_HOSTS_FILE = new File(KNOWN_HOSTS_FILE_PATH);

    @DataBoundConstructor
    public KnownHostsFileKeyVerificationStrategy() {
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws Exception {
        ComputerLauncher launcher = computer.getLauncher();
        if (!(launcher instanceof SSHLauncher)) {
            return false;
        }
        if (!KNOWN_HOSTS_FILE.exists()) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NoKnownHostsFile(KNOWN_HOSTS_FILE.getAbsolutePath()));
            return false;
        }
        SSHLauncher sshLauncher = (SSHLauncher)launcher;
        String host = sshLauncher.getHost();
        String hostPort = host + ":" + sshLauncher.getPort();
        listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_SearchingFor(host, KNOWN_HOSTS_FILE));
        int resultHost = this.verify(host, hostKey.getAlgorithm(), hostKey.getKey());
        listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_SearchingFor(hostPort, KNOWN_HOSTS_FILE));
        int resultHostPort = this.verify(hostPort, hostKey.getAlgorithm(), hostKey.getKey());
        if (0 == resultHost || 0 == resultHostPort) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_KeyTrusted(SSHLauncher.getTimestamp()));
            return true;
        }
        if (1 == resultHost && 1 == resultHostPort) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NewKeyNotTrusted(SSHLauncher.getTimestamp()));
            return false;
        }
        listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_ChangedKeyNotTrusted(SSHLauncher.getTimestamp()));
        return false;
    }

    private int verify(String host, String algorithm, byte[] key) throws IOException {
        KnownHosts knownHosts = new KnownHosts(KNOWN_HOSTS_FILE);
        return knownHosts.verifyHostkey(host, algorithm, key);
    }

    @Override
    public String[] getPreferredKeyAlgorithms(SlaveComputer computer) throws IOException {
        ComputerLauncher launcher = computer.getLauncher();
        if (!(launcher instanceof SSHLauncher) || !KNOWN_HOSTS_FILE.exists()) {
            return super.getPreferredKeyAlgorithms(computer);
        }
        KnownHosts knownHosts = new KnownHosts(KNOWN_HOSTS_FILE);
        return knownHosts.getPreferredServerHostkeyAlgorithmOrder(((SSHLauncher)launcher).getHost());
    }

    @Restricted(value={NoExternalUse.class})
    public File getKnownHostsFile() {
        return KNOWN_HOSTS_FILE;
    }

    @Extension
    public static class KnownHostsFileKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.KnownHostsFileHostKeyVerifier_DisplayName();
        }
    }
}

