/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.KnownHosts;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class KnownHostsFileKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private static final File KNOWN_HOSTS_FILE = new File(new File(new File(System.getProperty("user.home")), ".ssh"), "known_hosts");

    @DataBoundConstructor
    public KnownHostsFileKeyVerificationStrategy() {
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws Exception {
        ComputerLauncher launcher = computer.getLauncher();
        if (!(launcher instanceof SSHLauncher)) {
            return false;
        }
        if (!KNOWN_HOSTS_FILE.exists()) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NoKnownHostsFile(KNOWN_HOSTS_FILE.getAbsolutePath()));
            return false;
        }
        KnownHosts knownHosts = new KnownHosts(KNOWN_HOSTS_FILE);
        int result = knownHosts.verifyHostkey(((SSHLauncher)launcher).getHost(), hostKey.getAlgorithm(), hostKey.getKey());
        if (0 == result) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_KeyTrusted(SSHLauncher.getTimestamp()));
            return true;
        }
        if (1 == result) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NewKeyNotTrusted(SSHLauncher.getTimestamp()));
            return false;
        }
        listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_ChangedKeyNotTrusted(SSHLauncher.getTimestamp()));
        return false;
    }

    @Override
    public String[] getPreferredKeyAlgorithms(SlaveComputer computer) throws IOException {
        ComputerLauncher launcher = computer.getLauncher();
        if (!(launcher instanceof SSHLauncher) || !KNOWN_HOSTS_FILE.exists()) {
            return super.getPreferredKeyAlgorithms(computer);
        }
        KnownHosts knownHosts = new KnownHosts(KNOWN_HOSTS_FILE);
        return knownHosts.getPreferredServerHostkeyAlgorithmOrder(((SSHLauncher)launcher).getHost());
    }

    @Extension
    public static class KnownHostsFileKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.KnownHostsFileHostKeyVerifier_DisplayName();
        }
    }
}

