/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.SlaveComputer;
import hudson.tools.ToolLocationNodeProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;

@Extension
public class DefaultJavaProvider
extends JavaProvider {
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String BIN_JAVA = "/bin/java";
    public static final String JDK_BIN_JAVA = "/jdk/bin/java";

    @Override
    public List<String> getJavas(SlaveComputer computer, TaskListener listener, Connection connection) {
        ArrayList<String> javas = new ArrayList<String>();
        String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
        if (workingDirectory != null) {
            javas.add(workingDirectory + JDK_BIN_JAVA);
        }
        Slave node = computer.getNode();
        javas.addAll(this.lookForJavaHome((Node)node));
        javas.addAll(this.lookForTools((Node)node));
        javas.addAll(Arrays.asList("java", "/usr/bin/java", "/usr/java/default/bin/java", "/usr/java/latest/bin/java", "/usr/local/bin/java", "/usr/local/java/bin/java"));
        return javas;
    }

    private List<String> lookForJavaHome(Node node) {
        ArrayList<String> ret = new ArrayList<String>();
        if (node != null && node.getNodeProperties() != null) {
            for (NodeProperty property : node.getNodeProperties()) {
                EnvVars env;
                if (!(property instanceof EnvironmentVariablesNodeProperty) || (env = ((EnvironmentVariablesNodeProperty)property).getEnvVars()) == null || !env.containsKey((Object)JAVA_HOME)) continue;
                ret.add((String)env.get((Object)JAVA_HOME) + BIN_JAVA);
            }
        }
        return ret;
    }

    private List<String> lookForTools(Node node) {
        ArrayList<String> ret = new ArrayList<String>();
        Descriptor jdk = Jenkins.getActiveInstance().getDescriptorByType(JDK.DescriptorImpl.class);
        if (node != null && node.getNodeProperties() != null) {
            for (NodeProperty property : node.getNodeProperties()) {
                if (!(property instanceof ToolLocationNodeProperty)) continue;
                for (ToolLocationNodeProperty.ToolLocation tool : ((ToolLocationNodeProperty)property).getLocations()) {
                    if (tool.getType() != jdk) continue;
                    ret.add(tool.getHome() + BIN_JAVA);
                }
            }
        }
        return ret;
    }
}

