/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.HostKeyHelper;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.TrustHostKeyAction;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManuallyTrustedKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private final boolean requireInitialManualTrust;

    @DataBoundConstructor
    public ManuallyTrustedKeyVerificationStrategy(boolean requireInitialManualTrust) {
        this.requireInitialManualTrust = requireInitialManualTrust;
    }

    public boolean isRequireInitialManualTrust() {
        return this.requireInitialManualTrust;
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws IOException {
        HostKeyHelper hostManager = HostKeyHelper.getInstance();
        HostKey existingHostKey = hostManager.getHostKey((Computer)computer);
        if (null == existingHostKey) {
            if (this.isRequireInitialManualTrust()) {
                listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
                if (!this.hasExistingTrustAction(computer, hostKey)) {
                    computer.addAction((Action)new TrustHostKeyAction((Computer)computer, hostKey));
                }
                return false;
            }
            listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyAutoTrusted(SSHLauncher.getTimestamp(), hostKey.getFingerprint()));
            HostKeyHelper.getInstance().saveHostKey((Computer)computer, hostKey);
            return true;
        }
        if (!existingHostKey.equals(hostKey)) {
            listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
            if (!this.hasExistingTrustAction(computer, hostKey)) {
                computer.addAction((Action)new TrustHostKeyAction((Computer)computer, hostKey));
            }
            return false;
        }
        listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyTrused(SSHLauncher.getTimestamp()));
        return true;
    }

    private boolean hasExistingTrustAction(SlaveComputer computer, HostKey hostKey) {
        for (TrustHostKeyAction action : computer.getActions(TrustHostKeyAction.class)) {
            if (action.isComplete() || !action.getHostKey().equals(hostKey)) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static class ManuallyTrustedKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.ManualTrustingHostKeyVerifier_DescriptorDisplayName();
        }
    }
}

