/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class TrileadSSHPublicKeyAuthenticator
extends SSHAuthenticator<Connection, SSHUserPrivateKey> {
    private static final Logger LOGGER = Logger.getLogger(TrileadSSHPublicKeyAuthenticator.class.getName());

    public TrileadSSHPublicKeyAuthenticator(Connection connection, SSHUserPrivateKey user) {
        this(connection, user, (String)null);
    }

    public TrileadSSHPublicKeyAuthenticator(@NonNull Connection connection, @NonNull SSHUserPrivateKey user, @CheckForNull String username) {
        super(connection, user, username);
    }

    @Override
    public boolean canAuthenticate() {
        try {
            return this.getRemainingAuthMethods().contains("publickey");
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Failed to authenticate"));
            return false;
        }
    }

    private List<String> getRemainingAuthMethods() throws IOException {
        return Arrays.asList(((Connection)this.getConnection()).getRemainingAuthMethods(this.getUsername()));
    }

    @Override
    protected boolean doAuthenticate() {
        SSHUserPrivateKey user = (SSHUserPrivateKey)this.getUser();
        String username = this.getUsername();
        try {
            Connection connection = (Connection)this.getConnection();
            Secret userPassphrase = user.getPassphrase();
            String passphrase = userPassphrase == null ? null : userPassphrase.getPlainText();
            List<String> availableMethods = this.getRemainingAuthMethods();
            if (availableMethods.contains("publickey")) {
                int count = 0;
                ArrayList<IOException> ioe = new ArrayList<IOException>();
                for (String privateKey : TrileadSSHPublicKeyAuthenticator.getPrivateKeys(user)) {
                    try {
                        if (connection.authenticateWithPublicKey(username, privateKey.toCharArray(), passphrase)) {
                            LOGGER.fine("Authentication with 'publickey' succeeded.");
                            return true;
                        }
                    }
                    catch (IOException e) {
                        ioe.add(e);
                    }
                    this.getListener().error("Server rejected the %d private key(s) for %s (credentialId:%s/method:publickey)", new Object[]{++count, username, user.getId()});
                }
                for (IOException e : ioe) {
                    e.printStackTrace(this.getListener().error("Failed to authenticate as %s with credential=%s", new Object[]{username, ((SSHUserPrivateKey)this.getUser()).getId()}));
                }
                return false;
            }
            this.getListener().error("The server does not allow public key authentication. Available options are %s", new Object[]{availableMethods});
            return false;
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Failed to authenticate as %s with credential=%s", new Object[]{username, ((SSHUserPrivateKey)this.getUser()).getId()}));
            return false;
        }
    }

    @Extension
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Override
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            return this.newInstance(connection, user, null);
        }

        @Override
        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user, @CheckForNull String username) {
            if (this.supports(connection.getClass(), user.getClass())) {
                return new TrileadSSHPublicKeyAuthenticator((Connection)connection, (SSHUserPrivateKey)user, username);
            }
            return null;
        }

        @Override
        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return Connection.class.isAssignableFrom(connectionClass) && SSHUserPrivateKey.class.isAssignableFrom(userClass);
        }
    }
}

