/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.plugins.credentials.BaseCredentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.commons.lang.StringUtils;

public class BaseSSHUser
extends BaseCredentials
implements SSHUser,
StandardUsernameCredentials {
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final String description;
    protected final String username;

    public BaseSSHUser(CredentialsScope scope, String id, String username, String description) {
        super(scope);
        this.id = IdCredentials.Helpers.fixEmptyId((String)id);
        this.username = username;
        this.description = description;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getUsername() {
        return StringUtils.isEmpty((String)this.username) ? System.getProperty("user.name") : this.username;
    }

    @NonNull
    public String getDescription() {
        return StringUtils.isNotEmpty((String)this.description) ? this.description : "";
    }

    public boolean equals(Object o) {
        return IdCredentials.Helpers.equals((IdCredentials)this, (Object)o);
    }

    public int hashCode() {
        return IdCredentials.Helpers.hashCode((IdCredentials)this);
    }
}

