/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.exec;

import com.cloudbees.jenkins.plugins.sshagent.LauncherProvider;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgentFactory;
import com.cloudbees.jenkins.plugins.sshagent.exec.ExecRemoteAgent;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Extension
public class ExecRemoteAgentFactory
extends RemoteAgentFactory {
    @Override
    public String getDisplayName() {
        return "Exec ssh-agent (binary ssh-agent on a remote machine)";
    }

    @Override
    public boolean isSupported(Launcher launcher, TaskListener listener) {
        try {
            int status = launcher.launch().cmds(new String[]{"ssh-agent", "-k"}).quiet(true).start().joinWithTimeout(1L, TimeUnit.MINUTES, listener);
            return status == 0 || status == 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("Could not find ssh-agent: IOException: " + e.getMessage());
            listener.getLogger().println("Check if ssh-agent is installed and in PATH");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("Could not find ssh-agent: InterruptedException: " + e.getMessage());
            return false;
        }
    }

    @Override
    public RemoteAgent start(LauncherProvider launcherProvider, TaskListener listener, FilePath temp) throws Throwable {
        return new ExecRemoteAgent(launcherProvider, listener, temp);
    }
}

