/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.LauncherProvider;
import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgentFactory;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentBuildWrapper;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentStep;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class SSHAgentStepExecution
extends AbstractStepExecutionImpl
implements LauncherProvider {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient Run<?, ?> build;
    @StepContextParameter
    private transient Launcher launcher;
    @StepContextParameter
    private transient FilePath workspace;
    @Inject(optional=true)
    private SSHAgentStep step;
    private String socket;
    private List<String> sockets;
    private transient RemoteAgent agent = null;

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.sockets = new ArrayList<String>();
        this.initRemoteAgent();
        context.newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this))).withCallback((BodyExecutionCallback)new Callback(this)).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.agent != null) {
            this.agent.stop(this.listener);
            this.listener.getLogger().println(Messages.SSHAgentBuildWrapper_Stopped());
        }
        this.purgeSockets();
    }

    public void onResume() {
        super.onResume();
        try {
            this.purgeSockets();
            this.initRemoteAgent();
        }
        catch (IOException | InterruptedException x) {
            this.listener.getLogger().println(Messages.SSHAgentBuildWrapper_CouldNotStartAgent());
            x.printStackTrace(this.listener.getLogger());
        }
    }

    static FilePath tempDir(FilePath ws) {
        return WorkspaceList.tempDir((FilePath)ws);
    }

    private void initRemoteAgent() throws IOException, InterruptedException {
        ArrayList<SSHUserPrivateKey> userPrivateKeys = new ArrayList<SSHUserPrivateKey>();
        for (String id : new LinkedHashSet<String>(this.step.getCredentials())) {
            SSHUserPrivateKey sSHUserPrivateKey = (SSHUserPrivateKey)CredentialsProvider.findCredentialById((String)id, SSHUserPrivateKey.class, this.build, (DomainRequirement[])new DomainRequirement[0]);
            CredentialsProvider.track(this.build, (Credentials)sSHUserPrivateKey);
            if (sSHUserPrivateKey == null && !this.step.isIgnoreMissing()) {
                this.listener.fatalError(Messages.SSHAgentBuildWrapper_CredentialsNotFound());
            }
            if (sSHUserPrivateKey == null || userPrivateKeys.contains(sSHUserPrivateKey)) continue;
            userPrivateKeys.add(sSHUserPrivateKey);
        }
        for (SSHUserPrivateKey userPrivateKey : userPrivateKeys) {
            this.listener.getLogger().println(Messages.SSHAgentBuildWrapper_UsingCredentials(SSHAgentBuildWrapper.description((StandardUsernameCredentials)userPrivateKey)));
        }
        this.listener.getLogger().println("[ssh-agent] Looking for ssh-agent implementation...");
        LinkedHashMap<String, Throwable> faults = new LinkedHashMap<String, Throwable>();
        for (RemoteAgentFactory remoteAgentFactory : Jenkins.getActiveInstance().getExtensionList(RemoteAgentFactory.class)) {
            if (!remoteAgentFactory.isSupported(this.launcher, this.listener)) continue;
            try {
                this.listener.getLogger().println("[ssh-agent]   " + remoteAgentFactory.getDisplayName());
                this.agent = remoteAgentFactory.start(this, this.listener, SSHAgentStepExecution.tempDir(this.workspace));
                break;
            }
            catch (Throwable t) {
                faults.put(remoteAgentFactory.getDisplayName(), t);
            }
        }
        if (this.agent == null) {
            this.listener.getLogger().println("[ssh-agent] FATAL: Could not find a suitable ssh-agent provider");
            this.listener.getLogger().println("[ssh-agent] Diagnostic report");
            for (Map.Entry entry : faults.entrySet()) {
                this.listener.getLogger().println("[ssh-agent] * " + (String)entry.getKey());
                StringWriter sw = new StringWriter();
                ((Throwable)entry.getValue()).printStackTrace(new PrintWriter(sw));
                for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                    this.listener.getLogger().println("[ssh-agent]     " + line);
                }
            }
            throw new RuntimeException("[ssh-agent] Could not find a suitable ssh-agent provider.");
        }
        for (SSHUserPrivateKey sSHUserPrivateKey : userPrivateKeys) {
            Secret passphrase = sSHUserPrivateKey.getPassphrase();
            String effectivePassphrase = passphrase == null ? null : passphrase.getPlainText();
            for (String privateKey : sSHUserPrivateKey.getPrivateKeys()) {
                this.agent.addIdentity(privateKey, effectivePassphrase, SSHAgentBuildWrapper.description((StandardUsernameCredentials)sSHUserPrivateKey), this.listener);
            }
        }
        this.listener.getLogger().println(Messages.SSHAgentBuildWrapper_Started());
        this.socket = this.agent.getSocket();
        this.sockets.add(this.socket);
    }

    private void cleanUp() throws Exception {
        try {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            if (this.agent != null) {
                this.agent.stop(listener);
                listener.getLogger().println(Messages.SSHAgentBuildWrapper_Stopped());
            }
        }
        finally {
            this.purgeSockets();
        }
    }

    private void purgeSockets() {
        Iterator<String> it = this.sockets.iterator();
        while (it.hasNext()) {
            File socket = new File(it.next());
            if (socket.exists() && !socket.delete()) {
                this.listener.getLogger().format("It was a problem removing this socket file %s", socket.getAbsolutePath());
            }
            it.remove();
        }
    }

    @CheckReturnValue
    private String getSocket() {
        return this.socket;
    }

    @Override
    public Launcher getLauncher() throws IOException, InterruptedException {
        return (Launcher)this.getContext().get(Launcher.class);
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final SSHAgentStepExecution execution;

        ExpanderImpl(SSHAgentStepExecution execution) {
            this.execution = execution;
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.override("SSH_AUTH_SOCK", this.execution.getSocket());
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final SSHAgentStepExecution execution;

        Callback(SSHAgentStepExecution execution) {
            this.execution = execution;
        }

        protected void finished(StepContext context) throws Exception {
            this.execution.cleanUp();
        }
    }
}

