/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.LauncherProvider;
import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgentFactory;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentStepExecution;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.IOException2;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class SSHAgentBuildWrapper
extends BuildWrapper {
    private transient String user;
    private final List<String> credentialIds;
    private final boolean ignoreMissing;

    @Deprecated
    public SSHAgentBuildWrapper(String user) {
        this(Collections.singletonList(user), false);
    }

    @DataBoundConstructor
    public SSHAgentBuildWrapper(CredentialHolder[] credentialHolders, boolean ignoreMissing) {
        this(CredentialHolder.toIdList(credentialHolders), ignoreMissing);
    }

    public SSHAgentBuildWrapper(List<String> credentialIds, boolean ignoreMissing) {
        this.credentialIds = new ArrayList<String>(new LinkedHashSet<String>(credentialIds));
        this.ignoreMissing = ignoreMissing;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.user != null) {
            return new SSHAgentBuildWrapper(Collections.singletonList(this.user), false);
        }
        return this;
    }

    @Deprecated
    public String getUser() {
        return this.credentialIds.isEmpty() ? null : this.credentialIds.get(0);
    }

    public List<String> getCredentialIds() {
        return Collections.unmodifiableList(this.credentialIds);
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public CredentialHolder[] getCredentialHolders() {
        ArrayList<CredentialHolder> result = new ArrayList<CredentialHolder>(this.credentialIds.size());
        for (String id : this.credentialIds) {
            result.add(new CredentialHolder(id));
        }
        return result.toArray(new CredentialHolder[result.size()]);
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArrayList<SSHUserPrivateKey> keys = new ArrayList<SSHUserPrivateKey>();
        for (String id : new LinkedHashSet<String>(this.getCredentialIds())) {
            SSHUserPrivateKey c = (SSHUserPrivateKey)CredentialsProvider.findCredentialById((String)id, SSHUserPrivateKey.class, (Run)build, (DomainRequirement[])new DomainRequirement[0]);
            CredentialsProvider.track((Run)build, (Credentials)c);
            if (c == null && !this.ignoreMissing) {
                IOException ioe = new IOException(Messages.SSHAgentBuildWrapper_CredentialsNotFound());
                ioe.printStackTrace(listener.fatalError(""));
                throw ioe;
            }
            if (c == null || keys.contains(c)) continue;
            keys.add(c);
        }
        SSHAgentEnvironment environment = null;
        for (Environment env : build.getEnvironments()) {
            if (!(env instanceof SSHAgentEnvironment)) continue;
            environment = (SSHAgentEnvironment)env;
        }
        if (environment == null) {
            environment = this.createSSHAgentEnvironment(build, launcher, listener);
            build.getEnvironments().add((Object)environment);
        }
        for (SSHUserPrivateKey key : keys) {
            environment.add(key);
            listener.getLogger().println(Messages.SSHAgentBuildWrapper_UsingCredentials(SSHAgentBuildWrapper.description((StandardUsernameCredentials)key)));
        }
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new NoOpEnvironment();
    }

    private SSHAgentEnvironment createSSHAgentEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            return new SSHAgentEnvironment(launcher, listener, build.getWorkspace());
        }
        catch (IOException e) {
            throw new IOException2(Messages.SSHAgentBuildWrapper_CouldNotStartAgent(), (Throwable)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.fatalError(Messages.SSHAgentBuildWrapper_CouldNotStartAgent()));
            throw e;
        }
        catch (Throwable e) {
            throw new IOException2(Messages.SSHAgentBuildWrapper_CouldNotStartAgent(), e);
        }
    }

    @Nonnull
    public static String description(@Nonnull StandardUsernameCredentials c) {
        String description = Util.fixEmptyAndTrim((String)c.getDescription());
        return c.getUsername() + (description != null ? " (" + description + ")" : "");
    }

    private static class SingletonLauncherProvider
    implements LauncherProvider {
        private final Launcher launcher;

        private SingletonLauncherProvider(Launcher launcher) {
            this.launcher = launcher;
        }

        @Override
        public Launcher getLauncher() throws IOException, InterruptedException {
            return this.launcher;
        }
    }

    private class NoOpEnvironment
    extends BuildWrapper.Environment {
        private NoOpEnvironment() {
            super((BuildWrapper)SSHAgentBuildWrapper.this);
        }
    }

    public static class CredentialHolder
    extends AbstractDescribableImpl<CredentialHolder> {
        private final String id;

        @DataBoundConstructor
        public CredentialHolder(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @NonNull
        public static List<String> toIdList(@Nullable CredentialHolder[] credentialHolders) {
            ArrayList<String> result = new ArrayList<String>(credentialHolders == null ? 0 : credentialHolders.length);
            if (credentialHolders != null) {
                for (CredentialHolder h : credentialHolders) {
                    result.add(h.getId());
                }
            }
            return result;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CredentialHolder> {
            public String getDisplayName() {
                return Messages.SSHAgentBuildWrapper_CredentialHolder_DisplayName();
            }

            public ListBoxModel doFillIdItems() {
                Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
                return new StandardUsernameListBoxModel().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, SSHUserPrivateKey.class, Collections.emptyList(), SSHAuthenticator.matcher());
            }
        }
    }

    private class SSHAgentEnvironment
    extends BuildWrapper.Environment {
        private final RemoteAgent agent;
        private final Launcher launcher;
        private final BuildListener listener;

        @Deprecated
        public SSHAgentEnvironment(Launcher launcher, BuildListener listener, SSHUserPrivateKey sshUserPrivateKey) throws Throwable {
            this(launcher, listener, Collections.singletonList(sshUserPrivateKey));
        }

        @Deprecated
        public SSHAgentEnvironment(Launcher launcher, BuildListener listener, List<SSHUserPrivateKey> sshUserPrivateKeys) throws Throwable {
            this(launcher, listener);
            for (SSHUserPrivateKey sshUserPrivateKey : sshUserPrivateKeys) {
                this.add(sshUserPrivateKey);
            }
        }

        @Deprecated
        public SSHAgentEnvironment(Launcher launcher, BuildListener listener) throws Throwable {
            this(launcher, listener, (FilePath)null);
        }

        public SSHAgentEnvironment(Launcher launcher, @CheckForNull BuildListener listener, FilePath workspace) throws Throwable {
            super((BuildWrapper)SSHAgentBuildWrapper.this);
            RemoteAgent agent = null;
            this.launcher = launcher;
            this.listener = listener;
            listener.getLogger().println("[ssh-agent] Looking for ssh-agent implementation...");
            LinkedHashMap<String, Throwable> faults = new LinkedHashMap<String, Throwable>();
            for (RemoteAgentFactory factory : Jenkins.getActiveInstance().getExtensionList(RemoteAgentFactory.class)) {
                if (!factory.isSupported(launcher, (TaskListener)listener)) continue;
                try {
                    listener.getLogger().println("[ssh-agent]   " + factory.getDisplayName());
                    agent = factory.start(new SingletonLauncherProvider(launcher), (TaskListener)listener, workspace != null ? SSHAgentStepExecution.tempDir(workspace) : null);
                    break;
                }
                catch (Throwable t) {
                    faults.put(factory.getDisplayName(), t);
                }
            }
            if (agent == null) {
                listener.getLogger().println("[ssh-agent] FATAL: Could not find a suitable ssh-agent provider");
                listener.getLogger().println("[ssh-agent] Diagnostic report");
                for (Map.Entry fault : faults.entrySet()) {
                    listener.getLogger().println("[ssh-agent] * " + (String)fault.getKey());
                    StringWriter sw = new StringWriter();
                    ((Throwable)fault.getValue()).printStackTrace(new PrintWriter(sw));
                    for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                        listener.getLogger().println("[ssh-agent]     " + line);
                    }
                }
                throw new RuntimeException("[ssh-agent] Could not find a suitable ssh-agent provider.");
            }
            this.agent = agent;
            listener.getLogger().println(Messages.SSHAgentBuildWrapper_Started());
        }

        public void add(SSHUserPrivateKey key) throws IOException, InterruptedException {
            Secret passphrase = key.getPassphrase();
            String effectivePassphrase = passphrase == null ? null : passphrase.getPlainText();
            for (String privateKey : key.getPrivateKeys()) {
                this.agent.addIdentity(privateKey, effectivePassphrase, SSHAgentBuildWrapper.description((StandardUsernameCredentials)key), (TaskListener)this.listener);
            }
        }

        public void buildEnvVars(Map<String, String> env) {
            env.put("SSH_AUTH_SOCK", this.agent.getSocket());
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.agent != null) {
                this.agent.stop((TaskListener)listener);
                listener.getLogger().println(Messages.SSHAgentBuildWrapper_Stopped());
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SSHAgentBuildWrapper_DisplayName();
        }
    }
}

