/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.jna;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.posix.POSIXFactory;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class AgentServer {
    private final SshAgent agent;
    private String authSocket;
    private Thread thread;
    private UnixSocketAddress address;
    private UnixServerSocketChannel channel;
    private UnixServerSocket socket;
    private Selector selector;
    private volatile boolean selectable = true;
    @CheckForNull
    private final File temp;
    private static final Logger LOGGER = Logger.getLogger(AgentServer.class.getName());

    public AgentServer(File temp) {
        this((SshAgent)new AgentImpl(), temp);
    }

    public AgentServer(SshAgent agent, File temp) {
        this.agent = agent;
        this.temp = temp;
    }

    public SshAgent getAgent() {
        return this.agent;
    }

    public String start() throws Exception {
        this.authSocket = this.createLocalSocketAddress();
        this.address = new UnixSocketAddress(new File(this.authSocket));
        this.channel = UnixServerSocketChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
        this.socket.bind((SocketAddress)this.address);
        this.selector = NativeSelectorProvider.getInstance().openSelector();
        this.channel.register(this.selector, 16, (Object)new SshAgentServerSocketHandler());
        POSIXFactory.getPOSIX().chmod(this.authSocket, 384);
        if (!new File(this.authSocket).exists()) {
            throw new IllegalStateException("failed to create " + this.authSocket + " of length " + this.authSocket.length() + " (check UNIX_PATH_MAX)");
        }
        this.thread = new Thread((Runnable)new AgentSocketAcceptor(), "SSH Agent socket acceptor " + this.authSocket);
        this.thread.setDaemon(true);
        this.thread.start();
        return this.authSocket;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="createTempFile will fail anyway if there is a problem with mkdirs")
    private String createLocalSocketAddress() throws IOException {
        String name;
        if (this.temp != null) {
            this.temp.mkdirs();
        }
        if (OsUtils.isUNIX()) {
            File socket = File.createTempFile("ssh", "", this.temp);
            if (socket.getAbsolutePath().length() >= 108) {
                LOGGER.log(Level.WARNING, "Cannot use {0} due to UNIX_PATH_MAX; falling back to system temp dir", socket);
                socket = File.createTempFile("ssh", "");
            }
            FileUtils.deleteQuietly((File)socket);
            name = socket.getAbsolutePath();
        } else {
            File socket = File.createTempFile("ssh", "", this.temp);
            FileUtils.deleteQuietly((File)socket);
            name = "\\\\.\\pipe\\" + socket.getName();
        }
        return name;
    }

    public void close() {
        this.selectable = false;
        this.selector.wakeup();
        for (SelectionKey key : this.selector.keys()) {
            if (key == null) continue;
            AgentServer.safelyClose(key.channel());
        }
        AgentServer.safelyClose(this.selector);
        AgentServer.safelyClose((Closeable)this.agent);
        AgentServer.safelyClose((Closeable)this.channel);
        if (this.authSocket != null) {
            FileUtils.deleteQuietly((File)new File(this.authSocket));
        }
    }

    private static void safelyClose(Closeable channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Error while closing resource", e);
            }
        }
    }

    final class SshAgentSessionSocketHandler
    extends AbstractAgentClient
    implements EventHandler {
        public static final byte SSH_AGENTC_REQUEST_RSA_IDENTITIES = 1;
        public static final byte SSH_AGENT_RSA_IDENTITIES_ANSWER = 2;
        private final UnixSocketChannel sessionChannel;

        public SshAgentSessionSocketHandler(UnixSocketChannel sessionChannel) {
            super(AgentServer.this.agent);
            this.sessionChannel = sessionChannel;
        }

        @Override
        public void process(SelectionKey key) {
            try {
                int result;
                ByteBuffer buf = ByteBuffer.allocate(1024);
                while (0 < (result = this.sessionChannel.read(buf))) {
                    buf.flip();
                    this.messageReceived((Buffer)new ByteArrayBuffer(buf.array(), buf.position(), buf.remaining()));
                    if (result == 1024) {
                        buf.rewind();
                        continue;
                    }
                    return;
                }
                if (result == -1) {
                    key.cancel();
                    this.sessionChannel.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Could not write response to socket", e);
                key.cancel();
                AgentServer.safelyClose((Closeable)this.sessionChannel);
            }
        }

        protected void reply(Buffer buf) throws IOException {
            ByteBuffer b = ByteBuffer.wrap(buf.array(), buf.rpos(), buf.available());
            int result = this.sessionChannel.write(b);
            if (result < 0) {
                throw new IOException("Could not write response to socket");
            }
        }

        protected void process(int cmd, Buffer req, Buffer rep) throws Exception {
            switch (cmd) {
                case 1: {
                    rep.putByte((byte)2);
                    rep.putInt(0L);
                    break;
                }
                default: {
                    super.process(cmd, req, rep);
                }
            }
        }
    }

    final class SshAgentServerSocketHandler
    implements EventHandler {
        SshAgentServerSocketHandler() {
        }

        @Override
        public final void process(SelectionKey key) throws IOException {
            try {
                UnixSocketChannel clientChannel = AgentServer.this.channel.accept();
                clientChannel.configureBlocking(false);
                clientChannel.register(AgentServer.this.selector, 1, (Object)new SshAgentSessionSocketHandler(clientChannel));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "failed to accept new connection", ex);
                AgentServer.safelyClose((Closeable)AgentServer.this.channel);
                throw ex;
            }
        }
    }

    static interface EventHandler {
        public void process(SelectionKey var1) throws IOException;
    }

    final class AgentSocketAcceptor
    implements Runnable {
        AgentSocketAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (AgentServer.this.selectable) {
                    if (AgentServer.this.selector.select() <= 0) continue;
                    Iterator<SelectionKey> selectedKeys = AgentServer.this.selector.selectedKeys().iterator();
                    while (selectedKeys.hasNext()) {
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        if (!key.isValid()) continue;
                        EventHandler processor = (EventHandler)key.attachment();
                        processor.process(key);
                    }
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Error while waiting for events", ioe);
            }
            finally {
                if (AgentServer.this.selectable) {
                    LOGGER.log(Level.WARNING, "Unexpected death of thread {0}", Thread.currentThread().getName());
                } else {
                    LOGGER.log(Level.FINE, "Thread {0} termination initiated by call to AgentServer.close()", Thread.currentThread().getName());
                }
            }
        }
    }
}

