/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.mina;

import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgentFactory;
import com.cloudbees.jenkins.plugins.sshagent.RemoteHelper;
import com.cloudbees.jenkins.plugins.sshagent.mina.MinaRemoteAgentStarter;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tomcat.jni.Library;

@Extension
public class MinaRemoteAgentFactory
extends RemoteAgentFactory {
    @Override
    public String getDisplayName() {
        return "Java/tomcat-native ssh-agent";
    }

    @Override
    public boolean isSupported(Launcher launcher, TaskListener listener) {
        try {
            return (Boolean)launcher.getChannel().call((Callable)new TomcatNativeInstalled(listener));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public RemoteAgent start(Launcher launcher, TaskListener listener, FilePath temp) throws Throwable {
        RemoteHelper.registerBouncyCastle(launcher.getChannel(), listener);
        return (RemoteAgent)launcher.getChannel().call((Callable)new MinaRemoteAgentStarter(listener));
    }

    private static class TomcatNativeInstalled
    extends MasterToSlaveCallable<Boolean, Throwable> {
        private static final long serialVersionUID = 3234893369850673438L;
        private final TaskListener listener;

        public TomcatNativeInstalled(TaskListener listener) {
            this.listener = listener;
        }

        public Boolean call() throws Throwable {
            try {
                Library.initialize(null);
                return true;
            }
            catch (Exception e) {
                this.listener.getLogger().println("[ssh-agent] Could not find Tomcat Native library");
                return false;
            }
        }
    }
}

