/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentStepExecution;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;

public class SSHAgentStep
extends AbstractStepImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> credentials;
    private boolean ignoreMissing;

    @DataBoundConstructor
    public SSHAgentStep(List<String> credentials) {
        this.credentials = credentials;
        this.ignoreMissing = false;
    }

    @DataBoundSetter
    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public List<String> getCredentials() {
        return this.credentials;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(SSHAgentStepExecution.class);
        }

        public String getFunctionName() {
            return "sshagent";
        }

        public String getDisplayName() {
            return Messages.SSHAgentBuildWrapper_DisplayName();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillCredentialsItems() {
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            return new StandardUsernameListBoxModel().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, SSHUserPrivateKey.class, Collections.emptyList(), SSHAuthenticator.matcher());
        }
    }
}

