/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class UrlProxyHttpResponse
implements HttpResponse {
    private final URL url;

    public UrlProxyHttpResponse(URL url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateResponse(StaplerRequest request, StaplerResponse response, Object node) throws IOException {
        InputStream inputStream = this.url.openStream();
        try {
            int read;
            byte[] buffer = new byte[4096];
            int size = 0;
            response.setContentType(UrlProxyHttpResponse.getContentType(this.url));
            response.addHeader("rawUrl", this.url.toString());
            ServletOutputStream outputStream = response.getOutputStream();
            while ((read = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
                size += read;
            }
            response.addHeader("audioSize", "" + size);
            outputStream.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static String getContentType(URL url) {
        return new MimetypesFileTypeMap().getContentType(url.getPath());
    }
}

