/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.hurstfrost.hudson.sounds.CancelSoundsMarker;
import net.hurstfrost.hudson.sounds.HudsonSoundsNotifier;
import net.hurstfrost.hudson.sounds.ImmediateDataTimestampedSound;
import net.hurstfrost.hudson.sounds.JSONHttpResponse;
import net.hurstfrost.hudson.sounds.TimestampedSound;
import net.hurstfrost.hudson.sounds.UrlProxyHttpResponse;
import net.hurstfrost.hudson.sounds.UrlTimestampedSound;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SoundsAgentAction
implements RootAction,
Describable<SoundsAgentAction> {
    public static final int IMMEDIATE_POLL_INTERVAL = 100;
    public static final int DEFAULT_POLL_INTERVAL = 2000;
    public static final int MUTED_POLL_INTERVAL = 60000;
    public static final long SOUND_QUEUE_EXPIRATION_PERIOD_MS = 5000L;
    public static final long EXPIRY_EXTENSION = 1000L;
    public static final int LATENCY_COMPENSATION = 200;
    protected static final String COOKIE_NAME = "SoundsAgentActionDescriptorVersion";
    protected static final String MUTE_COOKIE_NAME = "SoundsAgentAction_mute";
    public static final Permission PERMISSION = Permission.CONFIGURE;

    public String getIconFileName() {
        return "/plugin/sounds/icon/s_on_24x24.png";
    }

    public String getUrlName() {
        return "/sounds";
    }

    public String getDisplayName() {
        return "Sounds";
    }

    public SoundsAgentActionDescriptor getDescriptor() {
        return (SoundsAgentActionDescriptor)Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static ExtensionList<SoundsAgentAction> all() {
        return Hudson.getInstance().getExtensionList(SoundsAgentAction.class);
    }

    public String getRootURL() {
        return Hudson.getInstance().getRootUrl();
    }

    public HudsonSoundsNotifier.HudsonSoundsDescriptor getSoundsDescriptor() {
        return HudsonSoundsNotifier.getSoundsDescriptor();
    }

    public HttpResponse doPlaySound(@QueryParameter String src, @QueryParameter Integer delay) {
        if (StringUtils.isEmpty((String)src)) {
            return FormValidation.error((String)"Missing src parameter");
        }
        URL url = null;
        try {
            url = new URL(src);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && src.startsWith("data:") || url.getProtocol().equalsIgnoreCase("data")) {
            this.getDescriptor().addSound(src, null);
            return FormValidation.ok();
        }
        if (url == null) {
            return FormValidation.error((String)"Invalid URL");
        }
        try {
            URLConnection connection = url.openConnection();
            this.playSound(connection.getInputStream(), delay);
            return FormValidation.ok();
        }
        catch (Exception e) {
            if (url.getProtocol().toLowerCase().startsWith("http")) {
                this.playSound(url, delay);
                return FormValidation.ok();
            }
            if (url.getProtocol().toLowerCase().startsWith("file")) {
                this.playSound(url, delay);
                return FormValidation.ok();
            }
            return FormValidation.error((Throwable)e, (String)("Unplayable sound (" + e + ")"));
        }
    }

    public HttpResponse doCancelSounds() {
        Hudson.getInstance().checkPermission(PERMISSION);
        SoundsAgentActionDescriptor descriptor = this.getDescriptor();
        descriptor.cancelSounds();
        return HttpResponses.forwardToPreviousPage();
    }

    public String getNextSound() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Integer version = null;
        try {
            version = new Integer(request.getParameter("version"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.doGetSounds((StaplerRequest)request, (StaplerResponse)Stapler.getCurrentResponse(), (Integer)version).jsonObject.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONHttpResponse doGetSounds(StaplerRequest req, StaplerResponse rsp, @QueryParameter Integer version) {
        JSONObject jsonObject = new JSONObject();
        if (HudsonSoundsNotifier.getSoundsDescriptor().getPlayMethod() == HudsonSoundsNotifier.PLAY_METHOD.BROWSER) {
            SoundsAgentActionDescriptor descriptor;
            SoundsAgentActionDescriptor soundsAgentActionDescriptor = descriptor = this.getDescriptor();
            synchronized (soundsAgentActionDescriptor) {
                TimestampedSound sound;
                int newVersion = descriptor.version + descriptor.wavsToPlay.size();
                jsonObject.element("p", 2000);
                if (version == null) {
                    Cookie[] cookies;
                    for (Cookie cookie : cookies = req.getCookies()) {
                        if (!cookie.getName().equals(COOKIE_NAME)) continue;
                        try {
                            version = Integer.parseInt(cookie.getValue());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (version != null && !this.isMuted(req) && (sound = descriptor.soundAtOffset(version)) != null) {
                    if (!sound.expired(0L) && !sound.isCancel()) {
                        jsonObject.element("play", (Object)sound.getUrl(version));
                        newVersion = version + 1;
                        long delayBy = sound.getPlayAt() - System.currentTimeMillis();
                        if (delayBy > 0L) {
                            jsonObject.element("d", delayBy);
                        }
                        jsonObject.element("p", 100);
                    }
                    if (sound.isCancel()) {
                        jsonObject.put("x", (Object)true);
                    }
                }
                if (this.isMuted(req)) {
                    jsonObject.element("p", 60000);
                    newVersion = -1;
                }
                jsonObject.element("v", newVersion);
                Cookie cookie = new Cookie(COOKIE_NAME, "" + newVersion);
                cookie.setPath("/");
                cookie.setMaxAge(-1);
                rsp.addCookie(cookie);
            }
        } else {
            jsonObject.element("p", 60000);
        }
        return new JSONHttpResponse(jsonObject);
    }

    public HttpResponse doSound(StaplerRequest request, StaplerResponse response) {
        final SoundsAgentActionDescriptor descriptor = this.getDescriptor();
        Integer version = null;
        try {
            version = Integer.parseInt(request.getParameter("v"));
            TimestampedSound sound = descriptor.soundAtOffset(version);
            if (sound != null && sound instanceof UrlTimestampedSound) {
                UrlTimestampedSound urlTimestampedSound = (UrlTimestampedSound)sound;
                return new UrlProxyHttpResponse(urlTimestampedSound.getRawUrl());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        final int finalVersion = version != null ? version : 0;
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.sendError(404, "No sound at version " + finalVersion + "(" + descriptor.version + ":" + descriptor.wavsToPlay + ")");
            }
        };
    }

    public HttpResponse doLocalMute(StaplerRequest req, StaplerResponse rsp) {
        Cookie cookie = new Cookie(MUTE_COOKIE_NAME, "mute");
        cookie.setPath("/");
        if (this.isLocalMute(req)) {
            cookie.setMaxAge(0);
        } else {
            cookie.setMaxAge(-1);
        }
        rsp.addCookie(cookie);
        return HttpResponses.forwardToPreviousPage();
    }

    public boolean isLocalMute() {
        return this.isLocalMute(Stapler.getCurrentRequest());
    }

    public boolean isLocalMute(StaplerRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(MUTE_COOKIE_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpResponse doGlobalMute(StaplerRequest req, StaplerResponse rsp) {
        Hudson.getInstance().checkPermission(PERMISSION);
        this.getDescriptor().setGlobalMute(!this.getDescriptor().isGlobalMute());
        this.getDescriptor().cancelSounds();
        return HttpResponses.forwardToPreviousPage();
    }

    public boolean isGlobalMute() {
        return this.getDescriptor().isGlobalMute();
    }

    protected boolean isMuted(StaplerRequest req) {
        return this.isGlobalMute() || this.isLocalMute(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(HudsonSoundsNotifier.HudsonSoundsDescriptor.SoundBite soundBite, Integer afterDelayMs) {
        try {
            URL url = new URL(soundBite.url);
            URLConnection connection = url.openConnection();
            ZipInputStream zipInputStream = new ZipInputStream(connection.getInputStream());
            try {
                ZipEntry entry;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    if (!entry.getName().equals(soundBite.entryName)) continue;
                    BufferedInputStream stream = new BufferedInputStream(zipInputStream);
                    this.playSound(stream, afterDelayMs);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipInputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void playSound(InputStream stream, Integer afterDelayMs) throws UnsupportedAudioFileException, IOException {
        AudioInputStream source = AudioSystem.getAudioInputStream(stream);
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        AudioSystem.write(source, AudioFileFormat.Type.WAVE, dest);
        String encodeBase64String = "data:audio/wav;base64," + new String(Base64.encodeBase64((byte[])dest.toByteArray(), (boolean)false));
        this.getDescriptor().addSound(encodeBase64String, afterDelayMs);
    }

    protected void playSound(URL url, Integer afterDelayMs) {
        this.getDescriptor().addSound(url, afterDelayMs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class SoundsAgentActionDescriptor
    extends Descriptor<SoundsAgentAction> {
        protected transient List<TimestampedSound> wavsToPlay = new ArrayList<TimestampedSound>();
        protected transient int version;
        protected boolean globalMute;

        public SoundsAgentActionDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return this.clazz.getSimpleName();
        }

        protected synchronized void addSound(String sound, Integer delay) {
            this.purgeExpiredSounds(1000L);
            this.wavsToPlay.add(new ImmediateDataTimestampedSound(sound, System.currentTimeMillis() + (long)(delay == null ? 2200 : delay)));
        }

        public synchronized void addSound(URL url, Integer delay) {
            this.purgeExpiredSounds(1000L);
            this.wavsToPlay.add(new UrlTimestampedSound(url, System.currentTimeMillis() + (long)(delay == null ? 2200 : delay)));
        }

        public synchronized void cancelSounds() {
            for (int o = 0; o < this.wavsToPlay.size(); ++o) {
                this.wavsToPlay.set(o, new CancelSoundsMarker(System.currentTimeMillis()));
            }
            this.wavsToPlay.add(new CancelSoundsMarker(System.currentTimeMillis()));
        }

        public synchronized TimestampedSound soundAtOffset(int o) {
            this.purgeExpiredSounds(1000L);
            if (o < this.version || o - this.version >= this.wavsToPlay.size()) {
                return null;
            }
            return this.wavsToPlay.get(o - this.version);
        }

        private void purgeExpiredSounds(long expiryExtension) {
            TimestampedSound timestampedSound;
            while (this.wavsToPlay.size() > 0 && (timestampedSound = this.wavsToPlay.get(0)).expired(expiryExtension)) {
                this.wavsToPlay.remove(0);
                ++this.version;
            }
        }

        public List<HudsonSoundsNotifier.HudsonSoundsDescriptor.SoundBite> getSounds() {
            HudsonSoundsNotifier.HudsonSoundsDescriptor hudsonSoundsDescriptor = HudsonSoundsNotifier.getSoundsDescriptor();
            return hudsonSoundsDescriptor.getSounds();
        }

        public boolean isGlobalMute() {
            return this.globalMute;
        }

        public void setGlobalMute(boolean mute) {
            this.globalMute = mute;
            this.save();
        }

        public FormValidation validateUrl(String soundUrl) {
            block6: {
                if (StringUtils.isEmpty((String)soundUrl)) {
                    return FormValidation.warning((String)"Missing URL");
                }
                try {
                    URL url = new URL(soundUrl);
                    if (!url.getProtocol().toLowerCase().equals("file")) break block6;
                    URI uri = new URI(soundUrl);
                    File file = new File(uri);
                    if (!file.exists() || !file.isFile()) {
                        return FormValidation.error((String)"File not found or not readable");
                    }
                    try {
                        FileInputStream inputStream = new FileInputStream(file);
                        inputStream.close();
                    }
                    catch (IOException e) {
                        return FormValidation.error((String)"File not found or not readable");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Invalid URL");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doTestSound(@QueryParameter String selectedSound) {
            try {
                HudsonSoundsNotifier.getSoundsDescriptor().playSound(selectedSound, null);
                return FormValidation.ok((String)String.format("Sound played successfully", new Object[0]));
            }
            catch (Exception e) {
                return FormValidation.error((String)String.format("Sound failed : " + e, new Object[0]));
            }
        }

        public FormValidation doTestUrl(@QueryParameter String soundUrl) {
            try {
                soundUrl = HudsonSoundsNotifier.toUri(soundUrl);
                FormValidation response = this.validateUrl(soundUrl);
                if (response.kind != FormValidation.Kind.OK) {
                    return response;
                }
                URL url = new URL(soundUrl);
                HudsonSoundsNotifier.getSoundsDescriptor().playSoundFromUrl(url, null, null);
                return FormValidation.ok((String)String.format("Sound played successfully", new Object[0]));
            }
            catch (Exception e) {
                return FormValidation.error((String)String.format("Sound failed : " + e, new Object[0]));
            }
        }
    }
}

