/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.tool;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.tool.SonargraphBuild;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstallerDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public final class SonargraphBuildInstaller
extends DownloadFromUrlInstaller {
    @DataBoundConstructor
    public SonargraphBuildInstaller(String id) {
        super(id);
    }

    public DownloadFromUrlInstaller.Installable getInstallable() throws IOException {
        for (DownloadFromUrlInstaller.Installable i : ((DescriptorImpl)this.getDescriptor()).getInstallables()) {
            if (!this.id.equals(i.id)) continue;
            return i;
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends ToolInstallerDescriptor<SonargraphBuildInstaller> {
        private static final long THIRTY_MINUTES = 1800000L;
        private static final String SONARGRAPH_BUILD_JSON = "http://eclipse.hello2morrow.com/jenkins/sonargraphBuild/sonargraphBuild.json";
        List<DownloadFromUrlInstaller.Installable> installables = null;
        long lastMillis = 0L;

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == SonargraphBuild.class;
        }

        public String getDisplayName() {
            return "Install from hello2morrow";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DownloadFromUrlInstaller.Installable> getInstallables() {
            if (this.installables == null || this.checkAgain()) {
                SonargraphLogger.INSTANCE.log(Level.INFO, "Trying to get list of installables from {0} ...", SONARGRAPH_BUILD_JSON);
                try (InputStream in = ProxyConfiguration.getInputStream((URL)new URL(SONARGRAPH_BUILD_JSON));
                     BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                    String inputStr;
                    StringBuilder responseStrBuilder = new StringBuilder();
                    while ((inputStr = streamReader.readLine()) != null) {
                        responseStrBuilder.append(inputStr);
                    }
                    JSONObject d = JSONObject.fromObject((Object)responseStrBuilder.toString());
                    this.installables = Arrays.asList(((DownloadFromUrlInstaller.InstallableList)JSONObject.toBean((JSONObject)d, DownloadFromUrlInstaller.InstallableList.class)).list);
                    SonargraphLogger.INSTANCE.log(Level.INFO, "Got list of {0} installables.", this.installables.size());
                }
                catch (Exception e) {
                    SonargraphLogger.INSTANCE.log(Level.SEVERE, "{0} while getting installables: {1}", new Object[]{e.getClass().getName(), e.getMessage()});
                    this.installables = Collections.emptyList();
                }
                finally {
                    this.lastMillis = System.currentTimeMillis();
                }
            }
            return this.installables;
        }

        private boolean checkAgain() {
            boolean result = System.currentTimeMillis() - this.lastMillis > 1800000L;
            return result;
        }
    }
}

