/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.model.BuildDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.model.InvalidDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.NotExistingDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.CSVColumnMapper;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public final class CSVFileHandler
implements IMetricHistoryProvider {
    public static final char CSV_SEPARATOR = ';';
    private static final String BUILDNUMBER_COLUMN_NAME = "buildnumber";
    private static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    private static final String NOT_EXISTING_VALUE = "-";
    private final File m_file;
    private final MetricIds m_metaData;
    private final CSVColumnMapper m_columnMapper;

    public CSVFileHandler(File csvFile, MetricIds metaData) {
        this.m_file = csvFile;
        this.m_metaData = metaData;
        if (!this.m_file.exists()) {
            try {
                this.m_file.createNewFile();
                FileWriter fileWriter = new FileWriter(this.m_file, true);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(this.createHeaderLine());
                bufferedWriter.newLine();
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException ex) {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to create CSV file '" + this.m_file.getAbsolutePath(), ex);
            }
            this.m_columnMapper = new CSVColumnMapper(this.m_metaData, new String[0]);
        } else {
            String[] existingColumnNames = this.getHeaderLine();
            this.m_columnMapper = new CSVColumnMapper(this.m_metaData, existingColumnNames);
            this.changeHeaderLine(existingColumnNames, this.m_columnMapper.getColumnNames(false));
        }
    }

    private void changeHeaderLine(String[] existingColumnNames, String[] newColumnNames) {
        Path temp;
        if (Arrays.equals(existingColumnNames, newColumnNames)) {
            return;
        }
        String newHeader = String.join((CharSequence)String.valueOf(';'), newColumnNames);
        try {
            temp = Files.createTempFile("pre", "suff", new FileAttribute[0]);
            Files.copy(this.m_file.toPath(), temp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to copy file to change header line'", e);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.m_file.toPath(), StandardCharsets.US_ASCII, new OpenOption[0]);
             BufferedReader reader = Files.newBufferedReader(temp, StandardCharsets.US_ASCII);){
            String line;
            writer.write(newHeader);
            writer.write(Utility.LINE_SEPARATOR);
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(Utility.LINE_SEPARATOR);
            }
        }
        catch (IOException ioe) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to write file to change header line'", ioe);
        }
    }

    private String[] getHeaderLine() {
        String[] stringArray;
        CSVReader csvReader = new CSVReader((Reader)new FileReader(this.m_file), ';');
        try {
            String[] nextLine;
            stringArray = nextLine = csvReader.readNext();
        }
        catch (Throwable throwable) {
            try {
                try {
                    csvReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to get header line from CSV file '" + this.m_file.getAbsolutePath(), ex);
                return new String[0];
            }
        }
        csvReader.close();
        return stringArray;
    }

    public String createHeaderLine() {
        StringBuilder headerLine = new StringBuilder(BUILDNUMBER_COLUMN_NAME).append(';');
        headerLine.append(TIMESTAMP_COLUMN_NAME);
        for (String metricName : this.m_metaData.getMetricIds().keySet()) {
            headerLine.append(';');
            headerLine.append(metricName);
        }
        return headerLine.toString();
    }

    @Override
    public List<IDataPoint> readMetricValues(MetricId metric) throws IOException {
        ArrayList<IDataPoint> sonargraphDataset = new ArrayList<IDataPoint>();
        if (!this.m_file.exists()) {
            return sonargraphDataset;
        }
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.m_file), ';');){
            String[] nextLine;
            int column = this.m_columnMapper.getIndex(metric.getId());
            csvReader.readNext();
            while ((nextLine = csvReader.readNext()) != null) {
                if (nextLine.length == 0 || nextLine.length <= column) continue;
                this.processLine(nextLine, column, sonargraphDataset, metric, NumberFormat.getInstance(Locale.US));
            }
        }
        catch (IOException ioe) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Exception occurred while reading from file '" + this.m_file.getAbsolutePath(), ioe);
        }
        return sonargraphDataset;
    }

    protected void processLine(String[] nextLine, int column, List<IDataPoint> sonargraphDataset, MetricId metric, NumberFormat numberFormat) {
        long timestamp;
        int buildNumber;
        int indexOfBuildnumber = this.m_columnMapper.getIndex(BUILDNUMBER_COLUMN_NAME);
        if (indexOfBuildnumber == -1) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Build number could not be found");
            return;
        }
        String buildNumberString = nextLine[indexOfBuildnumber];
        try {
            buildNumber = Integer.parseInt(buildNumberString);
        }
        catch (NumberFormatException ex) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Build number '" + buildNumberString + "' could not be parsed to an integer value.");
            return;
        }
        String timestampString = nextLine[this.m_columnMapper.getIndex(TIMESTAMP_COLUMN_NAME)];
        try {
            timestamp = Long.parseLong(timestampString);
        }
        catch (NumberFormatException ex) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Timestamp '" + timestampString + "' could not be parsed to a long value.");
            return;
        }
        String valueString = nextLine[column].trim();
        try {
            if (valueString.equals(NOT_EXISTING_VALUE)) {
                SonargraphLogger.INSTANCE.log(Level.FINE, "Skipping value for metric '" + metric.getName() + "' for build number '" + buildNumberString + "' and column '" + column + "'; it did not exist in Sonargraph XML report.");
                sonargraphDataset.add(new NotExistingDataPoint(buildNumber));
                return;
            }
            Number value = numberFormat.parse(valueString);
            sonargraphDataset.add(new BuildDataPoint(buildNumber, value.doubleValue(), timestamp));
        }
        catch (NumberFormatException ex) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "The value of metric '" + metric.getName() + "' for build number '" + buildNumberString + "' is not a valid number. Found '" + valueString + "' but expected a Number. File '" + this.m_file.getAbsolutePath() + "' might be corrupt:\n" + ex.getMessage());
            sonargraphDataset.add(new InvalidDataPoint(buildNumber));
        }
        catch (ParseException ex) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "The value of metric '" + metric.getName() + "' for build number '" + nextLine[0] + "' is not a valid number. Found '" + valueString + "' but expected a Number. File '" + this.m_file.getAbsolutePath() + "' might be corrupt:\n" + ex.getMessage());
            sonargraphDataset.add(new InvalidDataPoint(buildNumber));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "The value of metric '" + metric.getName() + "' for build number '" + nextLine[0] + "' was not found. File '" + this.m_file.getAbsolutePath() + "' might be corrupt", ex);
            sonargraphDataset.add(new NotExistingDataPoint(buildNumber));
        }
    }

    @Override
    public void writeMetricValues(Integer buildnumber, long timestamp, Map<MetricId, String> metricValues) throws IOException {
        FileWriter fileWriter = new FileWriter(this.m_file, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        StringBuilder line = new StringBuilder(buildnumber.toString()).append(';');
        line.append(timestamp);
        for (String metric : this.m_columnMapper.getColumnNames(true)) {
            line.append(';');
            String value = metricValues.get(this.m_metaData.getMetricIds().get(metric));
            if (value == null) {
                line.append(NOT_EXISTING_VALUE);
                continue;
            }
            line.append(value);
        }
        bufferedWriter.write(line.toString());
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    @Override
    public String getStorageName() {
        return this.m_file.getAbsolutePath();
    }
}

