/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractHTMLAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.InvisibleDiffAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.InvisibleReportAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.JobCategory;
import com.hello2morrow.sonargraph.integration.jenkins.controller.PipelineChartAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.PipelineDiffAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.PipelineReportAction;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class SonargraphReportAction
extends AbstractHTMLAction
implements SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;

    public SonargraphReportAction(Run<?, ?> run) {
        this.run = run;
    }

    @Override
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        FilePath reportHistoryDir = new FilePath(new FilePath(this.run.getParent().getRootDir()), ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        this.enableDirectoryBrowserSupport(req, rsp, new FilePath(reportHistoryDir, "sonargraph-report-build-" + this.run.getNumber()));
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_REPORT.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_REPORT.getValue();
    }

    @Override
    public String getHTMLReport() throws IOException, InterruptedException {
        File projectRootFolder = this.run.getParent().getRootDir();
        File reportHistoryFolder = new File(projectRootFolder, ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        File reportBuildFolder = new File(reportHistoryFolder, "sonargraph-report-build-" + this.run.getNumber());
        String reportFileName = ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue() + ".html";
        File reportFile = new File(reportBuildFolder, reportFileName);
        return this.readHTMLReport(new FilePath(reportFile), "Unable to read Sonargraph HTML report.");
    }

    public Collection<Action> getProjectActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        Job job = this.getRun().getParent();
        if (JobCategory.isPipelineJob(job)) {
            result.add(PipelineChartAction.getInstance(job));
            result.add(new PipelineReportAction(job));
            PipelineDiffAction diffAction = new PipelineDiffAction(job);
            if (diffAction.isPossible()) {
                result.add(diffAction);
            }
        }
        result.add(new InvisibleReportAction(job));
        result.add(new InvisibleDiffAction(job));
        return result;
    }
}

