/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractHTMLAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class SonargraphDiffAction
extends AbstractHTMLAction {
    private final Run<?, ?> run;

    public SonargraphDiffAction(Run<?, ?> run) {
        this.run = run;
    }

    @Override
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        FilePath reportHistoryDir = new FilePath(new FilePath(this.run.getParent().getRootDir()), ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        this.enableDirectoryBrowserSupport(req, rsp, new FilePath(reportHistoryDir, "sonargraph-report-build-" + this.run.getNumber()));
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_DIFF.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_DIFF.getValue();
    }

    @Override
    public String getHTMLReport() throws IOException, InterruptedException {
        File projectRootFolder = this.run.getParent().getRootDir();
        File reportHistoryFolder = new File(projectRootFolder, ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        File reportBuildFolder = new File(reportHistoryFolder, "sonargraph-report-build-" + this.run.getNumber());
        String reportFileName = ConfigParameters.SONARGRAPH_DIFF_FILE_NAME.getValue() + ".html";
        File reportFile = new File(reportBuildFolder, reportFileName);
        return this.readHTMLReport(new FilePath(reportFile), "Unable to read Sonargraph Diff report.");
    }
}

