/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.model.AbstractPlot;
import com.hello2morrow.sonargraph.integration.jenkins.model.TimeSeriesPlot;
import com.hello2morrow.sonargraph.integration.jenkins.model.XYLineAndShapePlot;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.CSVFileHandler;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import hudson.model.Job;
import hudson.util.Graph;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class Plotter {
    private static final String TYPE_PARAMETER = "type";
    private static final String METRIC_PARAMETER = "metric";
    private static final String SHORT_TERM = "shortterm";
    private static final String LONG_TERM = "longterm";
    private static final Integer defaultGraphicWidth = 400;
    private static final Integer defaultGraphicHeight = 250;
    private static final int MAX_DATA_POINTS_SHORT_TERM = 25;
    private static final int MAX_DATA_POINTS_LONG_TERM = 300;
    private static final String BUILD = "Build";
    private static final String DATE = "Date";

    private Plotter() {
    }

    public static void doGetPlot(Job<?, ?> job, MetricIds metaData, StaplerRequest req, StaplerResponse rsp) {
        int maxDataPoints;
        String xAxisLabel;
        AbstractPlot plot;
        Map parameterMap = req.getParameterMap();
        String metricName = Plotter.getSimpleValue(METRIC_PARAMETER, parameterMap);
        if (metricName == null) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "No metric specified for creating a plot.");
            return;
        }
        MetricId metric = metaData.getMetricId(metricName);
        if (metric == null) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Specified metric '" + metricName + "' is not supported.");
            return;
        }
        File csvFile = new File(job.getRootDir(), ConfigParameters.METRIC_HISTORY_CSV_FILE_PATH.getValue());
        SonargraphLogger.INSTANCE.log(Level.FINE, "Generating chart for metric '" + metricName + "'. Reading values from '" + csvFile.getAbsolutePath() + "'");
        CSVFileHandler csvFileHandler = new CSVFileHandler(csvFile, metaData);
        String type = Plotter.getSimpleValue(TYPE_PARAMETER, parameterMap);
        if (type == null || type.equals(SHORT_TERM)) {
            plot = new XYLineAndShapePlot(csvFileHandler);
            xAxisLabel = BUILD;
            maxDataPoints = 25;
        } else if (type.equals(LONG_TERM)) {
            plot = new TimeSeriesPlot(csvFileHandler, 25);
            xAxisLabel = DATE;
            maxDataPoints = 300;
        } else {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Chart type '" + type + "' is not supported!");
            return;
        }
        final JFreeChart chart = plot.createXYChart(metric, xAxisLabel, maxDataPoints, true);
        Graph graph = new Graph(plot.getTimestampOfLastDisplayedPoint(), defaultGraphicWidth, defaultGraphicHeight){

            protected JFreeChart createGraph() {
                return chart;
            }
        };
        try {
            graph.doPng(req, rsp);
        }
        catch (IOException ioe) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Error generating the graphic for metric '" + metric.getName() + "'");
        }
    }

    private static String getSimpleValue(String parameterName, Map<String, String[]> params) {
        assert (parameterName != null && parameterName.length() > 0) : "Parameter 'parameterName' of method 'getValue' must not be empty";
        assert (params != null) : "Parameter 'params' of method 'getValue' must not be null";
        String[] value = params.get(parameterName);
        if (value == null || value.length == 0) {
            return null;
        }
        return value[0];
    }
}

