/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.util.JSONStringer;
import org.apache.commons.beanutils.DynaBean;

public class MetricIds
implements Serializable {
    private static final long serialVersionUID = -5993873338543821075L;
    private final Map<String, MetricId> metricIds = new HashMap<String, MetricId>();

    public void addMetricId(MetricId metricId) {
        this.metricIds.put(metricId.getId(), metricId);
    }

    public Map<String, MetricId> getMetricIds() {
        return Collections.unmodifiableMap(this.metricIds);
    }

    public Map<String, MetricId> getMetricIds(String language) {
        HashMap<String, MetricId> result = new HashMap<String, MetricId>();
        for (String next : this.metricIds.keySet()) {
            MetricId nextMetric = this.metricIds.get(next);
            String nextProviderId = nextMetric.getProviderId();
            if (!nextProviderId.equals(language) && !nextProviderId.equals("Core") && !nextProviderId.startsWith("./")) continue;
            result.put(next, nextMetric);
        }
        return result;
    }

    public MetricId getMetricId(String metricName) {
        return this.metricIds.get(metricName);
    }

    public Set<String> getMetricCategories() {
        HashSet<String> result = new HashSet<String>();
        for (MetricId metricId : this.metricIds.values()) {
            result.addAll(metricId.getCategories());
        }
        return result;
    }

    public Set<MetricId> getMetricIdsForCategory(String metricCategory) {
        HashSet<MetricId> result = new HashSet<MetricId>();
        for (MetricId metricId : this.metricIds.values()) {
            if (!metricId.getCategories().contains(metricCategory)) continue;
            result.add(metricId);
        }
        return result;
    }

    public static String toJSON(MetricIds metricIds) {
        JSONStringer builder = new JSONStringer();
        builder.array();
        for (MetricId metricId : metricIds.getMetricIds().values()) {
            builder.object();
            builder.key("id").value((Object)metricId.getId());
            builder.key("providerId").value((Object)metricId.getProviderId());
            builder.key("name").value((Object)metricId.getName());
            builder.key("isFloat").value(metricId.isFloat());
            builder.key("categories").array();
            for (String category : metricId.getCategories()) {
                builder.value((Object)category);
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endArray();
        return builder.toString();
    }

    public static MetricIds fromJSON(String jsonString) {
        MetricIds result = new MetricIds();
        try {
            JSONArray jsonObject = JSONArray.fromObject((Object)jsonString);
            Collection jsonCollection = JSONArray.toCollection((JSONArray)jsonObject);
            for (Object next : jsonCollection) {
                DynaBean dynaBean = (DynaBean)next;
                MetricId metricId = new MetricId((String)dynaBean.get("id"), (String)dynaBean.get("providerId"), (String)dynaBean.get("name"), (boolean)((Boolean)dynaBean.get("isFloat")), (List)dynaBean.get("categories"));
                result.addMetricId(metricId);
            }
        }
        catch (JSONException je) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to read metricIds from json string", je);
        }
        return result;
    }

    public static MetricIds fromIMetricIds(List<IMetricId> metricIds) {
        MetricIds result = new MetricIds();
        for (IMetricId next : metricIds) {
            result.addMetricId(MetricId.from(next));
        }
        return result;
    }

    public static MetricIds fromExportMetaData(IExportMetaData exportMetaData) {
        MetricIds result = new MetricIds();
        for (IMetricId next : exportMetaData.getMetricIdsForLevel((IMetricLevel)exportMetaData.getMetricLevels().get("System"))) {
            result.addMetricId(MetricId.from(next));
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metricIds == null ? 0 : this.metricIds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricIds other = (MetricIds)obj;
        return !(this.metricIds == null ? other.metricIds != null : !this.metricIds.equals(other.metricIds));
    }

    public MetricIds addAll(MetricIds other) {
        for (MetricId nextId : other.getMetricIds().values()) {
            this.addMetricId(nextId);
        }
        return this;
    }
}

