/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationFileWriter {
    private final File m_file;

    public ConfigurationFileWriter(File file) {
        assert (file != null) : "Parameter 'file' of method 'ConfigurationFileWriter' must not be null";
        this.m_file = file;
    }

    public void createConfigurationFile(EnumMap<MandatoryParameter, String> parameters, PrintStream logger) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element sonargraphBuild = doc.createElement("sonargraphBuild");
            doc.appendChild(sonargraphBuild);
            this.setStartupAttributes(sonargraphBuild, parameters);
            Element failSet = doc.createElement("failSet");
            sonargraphBuild.appendChild(failSet);
            failSet.setAttribute("failOnEmptyWorkspace", "false");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.m_file);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to create configuration file '", pce);
        }
        catch (TransformerException tfe) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to create configuration file '", tfe);
        }
    }

    private void setStartupAttributes(Element element, EnumMap<MandatoryParameter, String> params) {
        for (MandatoryParameter parameter : params.keySet()) {
            String value = params.get((Object)parameter);
            if (value == null) continue;
            element.setAttribute(parameter.getPresentationName(), value);
        }
    }

    public static final class MandatoryParameter
    extends Enum<MandatoryParameter> {
        public static final /* enum */ MandatoryParameter ACTIVATION_CODE = new MandatoryParameter("activationCode");
        public static final /* enum */ MandatoryParameter INSTALLATION_DIRECTORY = new MandatoryParameter("installationDirectory");
        public static final /* enum */ MandatoryParameter LANGUAGES = new MandatoryParameter("languages");
        public static final /* enum */ MandatoryParameter SYSTEM_DIRECTORY = new MandatoryParameter("systemDirectory");
        public static final /* enum */ MandatoryParameter REPORT_DIRECTORY = new MandatoryParameter("reportDirectory");
        public static final /* enum */ MandatoryParameter REPORT_FILENAME = new MandatoryParameter("reportFileName");
        public static final /* enum */ MandatoryParameter REPORT_BASELINE = new MandatoryParameter("baselineReportPath");
        public static final /* enum */ MandatoryParameter REPORT_TYPE = new MandatoryParameter("reportType");
        public static final /* enum */ MandatoryParameter REPORT_FORMAT = new MandatoryParameter("reportFormat");
        public static final /* enum */ MandatoryParameter QUALITY_MODEL_FILE = new MandatoryParameter("qualityModelFile");
        public static final /* enum */ MandatoryParameter VIRTUAL_MODEL = new MandatoryParameter("virtualModel");
        public static final /* enum */ MandatoryParameter LICENSE_FILE = new MandatoryParameter("licenseFile");
        public static final /* enum */ MandatoryParameter WORKSPACE_PROFILE = new MandatoryParameter("workspaceProfile");
        public static final /* enum */ MandatoryParameter SNAPSHOT_DIRECTORY = new MandatoryParameter("snapshotDirectory");
        public static final /* enum */ MandatoryParameter SNAPSHOT_FILE_NAME = new MandatoryParameter("snapshotFileName");
        public static final /* enum */ MandatoryParameter LOG_FILE = new MandatoryParameter("logFile");
        public static final /* enum */ MandatoryParameter LOG_LEVEL = new MandatoryParameter("logLevel");
        public static final /* enum */ MandatoryParameter LICENSE_SERVER_HOST = new MandatoryParameter("licenseServerHost");
        public static final /* enum */ MandatoryParameter LICENSE_SERVER_PORT = new MandatoryParameter("licenseServerPort");
        public static final /* enum */ MandatoryParameter ELEMENT_COUNT_TO_SPLIT_HTML_REPORT = new MandatoryParameter("elementCountToSplitHtmlReport");
        public static final /* enum */ MandatoryParameter MAX_ELEMENT_COUNT_FOR_HTML_DETEILS_PAGE = new MandatoryParameter("maxElementCountForHtmlDetailsPage");
        public static final /* enum */ MandatoryParameter SPLIT_BY_MODULE = new MandatoryParameter("splitByModule");
        public static final /* enum */ MandatoryParameter PROGRESS_INFO = new MandatoryParameter("progressInfo");
        private final String m_presentationName;
        private static final /* synthetic */ MandatoryParameter[] $VALUES;

        public static MandatoryParameter[] values() {
            return (MandatoryParameter[])$VALUES.clone();
        }

        public static MandatoryParameter valueOf(String name) {
            return Enum.valueOf(MandatoryParameter.class, name);
        }

        private MandatoryParameter(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'MandatoryParameter' must not be empty";
            this.m_presentationName = presentationName;
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        static {
            $VALUES = new MandatoryParameter[]{ACTIVATION_CODE, INSTALLATION_DIRECTORY, LANGUAGES, SYSTEM_DIRECTORY, REPORT_DIRECTORY, REPORT_FILENAME, REPORT_BASELINE, REPORT_TYPE, REPORT_FORMAT, QUALITY_MODEL_FILE, VIRTUAL_MODEL, LICENSE_FILE, WORKSPACE_PROFILE, SNAPSHOT_DIRECTORY, SNAPSHOT_FILE_NAME, LOG_FILE, LOG_LEVEL, LICENSE_SERVER_HOST, LICENSE_SERVER_PORT, ELEMENT_COUNT_TO_SPLIT_HTML_REPORT, MAX_ELEMENT_COUNT_FOR_HTML_DETEILS_PAGE, SPLIT_BY_MODULE, PROGRESS_INFO};
        }
    }
}

