/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.InvisibleFromSidebarAction;
import hudson.FilePath;
import hudson.model.AbstractProject;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class SonargraphHTMLReportAction
extends InvisibleFromSidebarAction {
    private final AbstractProject<?, ?> project;

    public SonargraphHTMLReportAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getUrlName() {
        return ConfigParameters.HTML_REPORT_ACTION_URL.getValue();
    }

    @Override
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        File latestFolder = this.getLatestFolder();
        this.enableDirectoryBrowserSupport(req, rsp, new FilePath(latestFolder));
    }

    private File getLatestFolder() {
        File projectRootFolder = this.project.getRootDir();
        File reportHistoryFolder = new File(projectRootFolder, ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        File latestFolder = new File(reportHistoryFolder, "latest");
        return latestFolder;
    }

    @Override
    public String getHTMLReport() throws IOException, InterruptedException {
        File latestFolder = this.getLatestFolder();
        String reportFileName = ConfigParameters.SONARGRAPH_HTML_REPORT_FILE_NAME.getValue() + ".html";
        File reportFile = new File(latestFolder, reportFileName);
        return this.readHTMLReport(new FilePath(reportFile));
    }
}

