/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphBadgeAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphBuildAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphBuildAnalyzer;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.PluginVersionReader;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.ReportHistoryFileManager;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;

public abstract class AbstractSonargraphRecorder
extends Recorder {
    private final String architectureViolationsAction;
    private final String unassignedTypesAction;
    private final String cyclicElementsAction;
    private final String thresholdViolationsAction;
    private final String architectureWarningsAction;
    private final String workspaceWarningsAction;
    private final String workItemsAction;
    private final String emptyWorkspaceAction;

    public AbstractSonargraphRecorder(String architectureViolationsAction, String unassignedTypesAction, String cyclicElementsAction, String thresholdViolationsAction, String architectureWarningsAction, String workspaceWarningsAction, String workItemsAction, String emptyWorkspaceAction) {
        this.architectureViolationsAction = architectureViolationsAction;
        this.unassignedTypesAction = unassignedTypesAction;
        this.cyclicElementsAction = cyclicElementsAction;
        this.thresholdViolationsAction = thresholdViolationsAction;
        this.architectureWarningsAction = architectureWarningsAction;
        this.workspaceWarningsAction = workspaceWarningsAction;
        this.workItemsAction = workItemsAction;
        this.emptyWorkspaceAction = emptyWorkspaceAction;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected boolean processSonargraphReport(AbstractBuild<?, ?> build, FilePath sonargraphReportDirectory, String reportFileName, PrintStream logger) throws IOException, InterruptedException {
        assert (build != null) : "Parameter 'build' of method 'processSonargraphReport' must not be null";
        assert (sonargraphReportDirectory != null) : "Parameter 'sonargraphReportDirectory' of method 'processSonargraphReport' must not be null";
        FilePath projectRootDir = new FilePath(build.getProject().getRootDir());
        ReportHistoryFileManager reportHistoryManager = new ReportHistoryFileManager(projectRootDir, ConfigParameters.REPORT_HISTORY_FOLDER.getValue(), logger);
        FilePath reportFile = null;
        try {
            reportFile = reportHistoryManager.storeGeneratedReportDirectory(sonargraphReportDirectory, reportFileName, build.getNumber(), logger);
        }
        catch (IOException ex) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to process the generated Sonargraph report", ex);
            return false;
        }
        if (reportFile == null || !reportFile.exists() || reportFile.isRemote() || reportFile.isDirectory()) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Sonargraph analysis cannot be executed as Sonargraph report does not exist.", null);
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Report file \"" + reportFile + "\" does not exist.", null);
            build.setResult(Result.FAILURE);
            return false;
        }
        SonargraphBuildAnalyzer sonargraphBuildAnalyzer = new SonargraphBuildAnalyzer(reportFile, logger);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ArchitectureViolation", Severity.NONE, this.architectureViolationsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfMetricValueNotZero("CoreUnassignedComponents", this.unassignedTypesAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("CycleGroup", Severity.ERROR, this.cyclicElementsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ThresholdViolation", Severity.ERROR, this.thresholdViolationsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ArchitectureConsistency", Severity.NONE, this.architectureWarningsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("Workspace", Severity.NONE, this.workspaceWarningsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("Todo", Severity.NONE, this.workItemsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfMetricValueIsZero("CoreComponents", this.emptyWorkspaceAction);
        Result buildResult = sonargraphBuildAnalyzer.getOverallBuildResult();
        File metricHistoryFile = new File(build.getProject().getRootDir(), ConfigParameters.METRIC_HISTORY_CSV_FILE_PATH.getValue());
        File metricIdsHistoryFile = new File(build.getProject().getRootDir(), ConfigParameters.METRICIDS_HISTORY_JSON_FILE_PATH.getValue());
        try {
            sonargraphBuildAnalyzer.saveMetrics(metricHistoryFile, metricIdsHistoryFile, build.getTimestamp().getTimeInMillis(), build.getNumber());
        }
        catch (IOException ex) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to save Sonargraph metrics to CSV data file", ex);
            return false;
        }
        if (buildResult != null) {
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Sonargraph analysis has set the final build result to '" + buildResult.toString() + "'", null);
            build.setResult(buildResult);
        }
        return true;
    }

    protected void logExecutionStart(AbstractBuild<?, ?> build, BuildListener listener, Class<? extends AbstractSonargraphRecorder> recorderClazz) {
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Sonargraph Jenkins Plugin, Version '" + PluginVersionReader.INSTANCE.getVersion() + "', post-build step '" + recorderClazz.getName() + "'\nStart structural analysis on project '" + build.getProject().getDisplayName() + "', build number '" + build.getNumber() + "'", null);
    }

    protected void addActions(AbstractBuild<?, ?> build) {
        build.addAction((Action)new SonargraphBadgeAction());
        build.addAction((Action)new SonargraphBuildAction(build));
    }

    public String getArchitectureViolationsAction() {
        return this.architectureViolationsAction;
    }

    public String getUnassignedTypesAction() {
        return this.unassignedTypesAction;
    }

    public String getCyclicElementsAction() {
        return this.cyclicElementsAction;
    }

    public String getThresholdViolationsAction() {
        return this.thresholdViolationsAction;
    }

    public String getArchitectureWarningsAction() {
        return this.architectureWarningsAction;
    }

    public String getWorkspaceWarningsAction() {
        return this.workspaceWarningsAction;
    }

    public String getWorkItemsAction() {
        return this.workItemsAction;
    }

    public String getEmptyWorkspaceAction() {
        return this.emptyWorkspaceAction;
    }
}

