/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.jenkins.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.WsClient;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.sonarsource.scanner.jenkins.pipeline.SonarQubeWebHook;

public class WaitForQualityGateStep
extends Step
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(WaitForQualityGateStep.class.getName());
    private String taskId;
    private String installationName;
    private String serverUrl;
    private boolean abortPipeline;

    @DataBoundConstructor
    public WaitForQualityGateStep(boolean abortPipeline) {
        this.abortPipeline = abortPipeline;
    }

    public boolean isAbortPipeline() {
        return this.abortPipeline;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Wait for SonarQube analysis to be completed and return quality gate status";
        }

        public String getFunctionName() {
            return "waitForQualityGate";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FlowNode.class, Run.class, TaskListener.class);
        }
    }

    private static class Execution
    extends StepExecution
    implements SonarQubeWebHook.Listener {
        private static final String PLEASE_USE_THE_WITH_SONAR_QUBE_ENV_WRAPPER_TO_RUN_YOUR_ANALYSIS = "Please use the 'withSonarQubeEnv' wrapper to run your analysis.";
        private static final long serialVersionUID = 1L;
        private WaitForQualityGateStep step;

        public Execution(WaitForQualityGateStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            this.processStepParameters();
            if (!this.checkTaskCompleted()) {
                ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new PauseAction("SonarQube analysis"));
                return false;
            }
            return true;
        }

        private void processStepParameters() throws IOException, InterruptedException {
            List actions = ((Run)this.getContext().get(Run.class)).getActions(SonarAnalysisAction.class);
            if (actions.isEmpty()) {
                throw new IllegalStateException("No previous SonarQube analysis found on this pipeline execution. Please use the 'withSonarQubeEnv' wrapper to run your analysis.");
            }
            String ceTaskId = null;
            String serverUrl = null;
            String installationName = null;
            ArrayList reversedActions = new ArrayList(actions);
            Collections.reverse(reversedActions);
            for (SonarAnalysisAction a : reversedActions) {
                ceTaskId = a.getCeTaskId();
                if (ceTaskId == null) continue;
                serverUrl = a.getServerUrl();
                installationName = a.getInstallationName();
                break;
            }
            if (ceTaskId == null || serverUrl == null || installationName == null) {
                throw new IllegalStateException("Unable to guess SonarQube task id and/or SQ server details. Please use the 'withSonarQubeEnv' wrapper to run your analysis.");
            }
            this.step.setTaskId(ceTaskId);
            this.step.setServerUrl(serverUrl);
            this.step.setInstallationName(installationName);
        }

        private void log(String msg, Object ... args) throws IOException, InterruptedException {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().printf(msg, args);
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println();
        }

        private boolean checkTaskCompleted() throws IOException, InterruptedException {
            SonarQubeWebHook.get().addListener(this);
            SonarInstallation inst = SonarInstallation.get(this.step.getInstallationName());
            if (inst == null) {
                throw new IllegalStateException("Invalid installation name: " + this.step.getInstallationName());
            }
            this.log("Checking status of SonarQube task '%s' on server '%s'", this.step.taskId, this.step.getInstallationName());
            WsClient wsClient = new WsClient(new HttpClient(), this.step.getServerUrl(), inst.getServerAuthenticationToken());
            WsClient.CETask ceTask = wsClient.getCETask(this.step.getTaskId());
            this.log("SonarQube task '%s' status is '%s'", this.step.taskId, ceTask.getStatus());
            switch (ceTask.getStatus()) {
                case "SUCCESS": {
                    String status = wsClient.requestQualityGateStatus(ceTask.getAnalysisId());
                    this.log("SonarQube task '%s' completed. Quality gate is '%s'", this.step.taskId, status);
                    this.handleQGStatus(status);
                    return true;
                }
                case "FAILED": 
                case "CANCELED": {
                    throw new IllegalStateException("SonarQube analysis '" + this.step.getTaskId() + "' failed: " + ceTask.getStatus());
                }
            }
            return false;
        }

        private void handleQGStatus(String status) {
            if (this.step.isAbortPipeline() && !"OK".equals(status)) {
                this.getContext().onFailure((Throwable)new AbortException("Pipeline aborted due to quality gate failure: " + status));
            } else {
                this.getContext().onSuccess((Object)new QGStatus(status));
            }
        }

        public void onResume() {
            SonarQubeWebHook.get().addListener(this);
            try {
                this.checkTaskCompleted();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to restore step", e);
            }
        }

        public void stop(Throwable cause) throws Exception {
            PauseAction.endCurrentPause((FlowNode)((FlowNode)this.getContext().get(FlowNode.class)));
            SonarQubeWebHook.get().removeListener(this);
            this.getContext().onFailure(cause);
        }

        @Override
        public void onTaskCompleted(String taskId, String taskStatus, @Nullable String qgStatus) {
            if (taskId.equals(this.step.taskId)) {
                try {
                    PauseAction.endCurrentPause((FlowNode)((FlowNode)this.getContext().get(FlowNode.class)));
                    SonarQubeWebHook.get().removeListener(this);
                    this.log("SonarQube task '%s' status is '%s'", this.step.taskId, taskStatus);
                    switch (taskStatus) {
                        case "SUCCESS": {
                            this.log("SonarQube task '%s' completed. Quality gate is '%s'", this.step.taskId, qgStatus);
                            this.handleQGStatus(qgStatus);
                            break;
                        }
                        case "FAILED": 
                        case "CANCELED": {
                            this.getContext().onFailure((Throwable)new IllegalStateException("SonarQube analysis '" + this.step.getTaskId() + "' failed: " + taskStatus));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected task status: " + taskStatus);
                        }
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Error during WaitForQualityGateStep", e);
                }
            }
        }
    }

    public static class QGStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String status;

        public QGStatus(String status) {
            this.status = status;
        }

        @Whitelisted
        public String getStatus() {
            return this.status;
        }
    }
}

