/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.AbortException;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.model.TriggersConfig;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarInstallation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SERVER_URL = "http://localhost:9000";
    private final String name;
    private final String serverUrl;
    private String serverAuthenticationToken;
    private String mojoVersion;
    private final String additionalProperties;
    private final String additionalAnalysisProperties;
    private TriggersConfig triggers;
    private String[] split;

    @DataBoundConstructor
    public SonarInstallation(String name, String serverUrl, String serverAuthenticationToken, String mojoVersion, String additionalProperties, TriggersConfig triggers, String additionalAnalysisProperties) {
        this.name = name;
        this.serverUrl = serverUrl;
        this.serverAuthenticationToken = serverAuthenticationToken;
        this.additionalAnalysisProperties = additionalAnalysisProperties;
        this.mojoVersion = mojoVersion;
        this.additionalProperties = additionalProperties;
        this.triggers = triggers;
    }

    public static final SonarInstallation[] all() {
        return SonarGlobalConfiguration.get().getInstallations();
    }

    public static boolean isValid(String sonarInstallationName, TaskListener listener) {
        String failureMsg = SonarInstallation.validationMsg(sonarInstallationName);
        if (failureMsg != null) {
            listener.fatalError(failureMsg);
            return false;
        }
        return true;
    }

    public static void checkValid(String sonarInstallationName) throws AbortException {
        String failureMsg = SonarInstallation.validationMsg(sonarInstallationName);
        if (failureMsg != null) {
            throw new AbortException(failureMsg);
        }
    }

    private static String validationMsg(String sonarInstallationName) {
        String failureMsg;
        SonarInstallation sonarInstallation = SonarInstallation.get(sonarInstallationName);
        if (sonarInstallation == null) {
            failureMsg = StringUtils.isBlank((String)sonarInstallationName) ? Messages.SonarInstallation_NoInstallation(SonarInstallation.all().length) : Messages.SonarInstallation_NoMatchInstallation(sonarInstallationName, SonarInstallation.all().length);
            failureMsg = failureMsg + "\n" + Messages.SonarInstallation_FixInstallationTip();
        } else {
            failureMsg = null;
        }
        return failureMsg;
    }

    public static final SonarInstallation get(String name) {
        SonarInstallation[] available = SonarInstallation.all();
        if (StringUtils.isEmpty((String)name) && available.length > 0) {
            return available[0];
        }
        for (SonarInstallation si : available) {
            if (!StringUtils.equals((String)name, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerAuthenticationToken() {
        return StringUtils.trimToNull((String)this.serverAuthenticationToken);
    }

    @CheckForNull
    public String getMojoVersion() {
        return this.mojoVersion;
    }

    @CheckForNull
    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    @CheckForNull
    public String getAdditionalAnalysisProperties() {
        return this.additionalAnalysisProperties;
    }

    public String[] getAdditionalAnalysisPropertiesWindows() {
        if (this.additionalAnalysisProperties == null) {
            return new String[0];
        }
        this.split = StringUtils.split((String)this.additionalAnalysisProperties);
        for (int i = 0; i < this.split.length; ++i) {
            this.split[i] = "/d:" + this.split[i];
        }
        return this.split;
    }

    public String[] getAdditionalAnalysisPropertiesUnix() {
        if (this.additionalAnalysisProperties == null) {
            return new String[0];
        }
        this.split = StringUtils.split((String)this.additionalAnalysisProperties);
        for (int i = 0; i < this.split.length; ++i) {
            this.split[i] = "-D" + this.split[i];
        }
        return this.split;
    }

    public TriggersConfig getTriggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersConfig();
        }
        return this.triggers;
    }
}

