/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.jenkins.pipeline;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SonarQubeWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(SonarQubeWebHook.class.getName());
    private final Cache<String, WebhookEvent> eventCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build();
    public static final String URLNAME = "sonarqube-webhook";
    @VisibleForTesting
    List<Consumer<WebhookEvent>> listeners = new CopyOnWriteArrayList<Consumer<WebhookEvent>>();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @RequirePOST
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String payload = IOUtils.toString((Reader)req.getReader());
        LOGGER.info("Received POST from " + req.getRemoteHost());
        try {
            JSONObject jsonObject = SonarQubeWebHook.validate(payload);
            LOGGER.fine(() -> "Full details of the POST was " + jsonObject.toString());
            WebhookEvent event = new WebhookEvent(new Payload(payload, jsonObject), req.getHeader("X-Sonar-Webhook-HMAC-SHA256"));
            this.eventCache.put((Object)event.payload.taskId, (Object)event);
            for (Consumer<WebhookEvent> listener : this.listeners) {
                listener.accept(event);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, e, () -> "Invalid payload " + payload);
            rsp.sendError(400, "Invalid JSON Payload");
        }
        rsp.setStatus(200);
    }

    private static JSONObject validate(String payload) {
        return JSONObject.fromObject((Object)payload);
    }

    public static SonarQubeWebHook get() {
        return (SonarQubeWebHook)Jenkins.get().getExtensionList(RootAction.class).get(SonarQubeWebHook.class);
    }

    public void addListener(Consumer<WebhookEvent> l) {
        this.listeners.add(l);
    }

    public void removeListener(Consumer<WebhookEvent> l) {
        this.listeners.remove(l);
    }

    @Nullable
    public WebhookEvent getWebhookEventForTaskId(String taskId) {
        return (WebhookEvent)this.eventCache.getIfPresent((Object)taskId);
    }

    static final class WebhookEvent {
        private final Payload payload;
        private final String receivedSignature;

        WebhookEvent(Payload payload, String receivedSignature) {
            this.payload = payload;
            this.receivedSignature = receivedSignature;
        }

        public Payload getPayload() {
            return this.payload;
        }

        public String getReceivedSignature() {
            return this.receivedSignature;
        }
    }

    static final class Payload {
        private final String payloadAsString;
        private final String taskId;
        private final String componentName;
        private final String taskStatus;
        private final String qualityGateStatus;
        private final String dashboardUrl;

        Payload(String payloadAsString, JSONObject json) {
            this.payloadAsString = payloadAsString;
            this.taskId = json.getString("taskId");
            this.taskStatus = json.getString("status");
            JSONObject project = json.getJSONObject("project");
            this.componentName = project.getString("name");
            this.dashboardUrl = project.getString("url");
            this.qualityGateStatus = "SUCCESS".equals(this.getTaskStatus()) ? (json.has("qualityGate") ? json.getJSONObject("qualityGate").getString("status") : "NONE") : null;
        }

        String getTaskId() {
            return this.taskId;
        }

        String getTaskStatus() {
            return this.taskStatus;
        }

        String getQualityGateStatus() {
            return this.qualityGateStatus;
        }

        String getComponentName() {
            return this.componentName;
        }

        String getDashboardUrl() {
            return this.dashboardUrl;
        }

        String getPayloadAsString() {
            return this.payloadAsString;
        }
    }
}

