/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.WsClient;
import hudson.plugins.sonar.utils.BuilderUtils;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class SonarUtils {
    public static final String SERVER_URL_KEY = "serverUrl";
    public static final String DASHBOARD_URL_KEY = "dashboardUrl";
    public static final String CE_TASK_ID_KEY = "ceTaskId";
    public static final String REPORT_TASK_FILE_NAME = "report-task.txt";
    public static final String PROPERTY_SONAR_LOGIN = "sonar.login";
    public static final String PROPERTY_SONAR_TOKEN = "sonar.token";
    private static final String SONARCLOUD_URL = "https://sonarcloud.io";

    private SonarUtils() {
    }

    public static <T extends Action> List<T> getPersistentActions(Actionable actionable, Class<T> type) {
        LinkedList<Action> filtered = new LinkedList<Action>();
        for (Action a : actionable.getActions()) {
            if (a == null || !type.isAssignableFrom(a.getClass())) continue;
            filtered.add(a);
        }
        return filtered;
    }

    @CheckForNull
    public static <T extends Action> T getPersistentAction(Actionable actionable, Class<T> type) {
        for (Action a : actionable.getActions()) {
            if (a == null || !type.isAssignableFrom(a.getClass())) continue;
            return (T)a;
        }
        return null;
    }

    public static Properties extractReportTask(TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        FilePath[] candidates = null;
        if (workspace.exists()) {
            candidates = workspace.list("**/report-task.txt");
        }
        if (candidates == null || candidates.length == 0) {
            listener.getLogger().println("WARN: Unable to locate 'report-task.txt' in the workspace. Did the SonarScanner succeed?");
            return null;
        }
        if (candidates.length > 1) {
            listener.getLogger().println("WARN: Found multiple 'report-task.txt' in the workspace. Taking the first one.");
            Stream.of(candidates).forEach(p -> listener.getLogger().println(p));
        }
        FilePath reportTaskFile = candidates[0];
        try (InputStream in = reportTaskFile.read();){
            Properties p2 = new Properties();
            p2.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            Properties properties = p2;
            return properties;
        }
    }

    @Nullable
    public static SonarAnalysisAction addBuildInfoTo(Run<?, ?> build, TaskListener listener, FilePath workspace, SonarInstallation sonarInstallation, @Nullable String credentialId, boolean skippedIfNoBuild) throws IOException, InterruptedException {
        Properties reportTask;
        SonarAnalysisAction buildInfo = SonarUtils.createSonarAnalysisAction(sonarInstallation, credentialId, build, listener);
        boolean java11Warning = build.getLog(Integer.MAX_VALUE).stream().anyMatch(line -> line.contains("Please update to at least Java 11."));
        Result result = build.getResult();
        if (java11Warning && !Result.FAILURE.equals(result)) {
            build.setResult(Result.UNSTABLE);
            listener.getLogger().println("Pipeline marked as 'UNSTABLE'. Please update to at least Java 11. Find more information here on how to do this: https://sonarcloud.io/documentation/appendices/move-analysis-java-11/");
        }
        if ((reportTask = SonarUtils.extractReportTask(listener, workspace)) == null) {
            return SonarUtils.addBuildInfoFromLastBuildTo(build, listener, sonarInstallation, credentialId, skippedIfNoBuild);
        }
        buildInfo.setServerUrl(reportTask.getProperty(SERVER_URL_KEY));
        buildInfo.setUrl(reportTask.getProperty(DASHBOARD_URL_KEY));
        buildInfo.setCeTaskId(reportTask.getProperty(CE_TASK_ID_KEY));
        build.addAction((Action)buildInfo);
        return buildInfo;
    }

    public static SonarAnalysisAction addBuildInfoTo(Run<?, ?> build, TaskListener listener, FilePath workspace, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        return SonarUtils.addBuildInfoTo(build, listener, workspace, sonarInstallation, sonarInstallation.getCredentialsId());
    }

    public static SonarAnalysisAction addBuildInfoTo(Run<?, ?> build, TaskListener listener, FilePath workspace, SonarInstallation sonarInstallation, @Nullable String credentialId) throws IOException, InterruptedException {
        return SonarUtils.addBuildInfoTo(build, listener, workspace, sonarInstallation, credentialId, false);
    }

    public static SonarAnalysisAction addBuildInfoFromLastBuildTo(Run<?, ?> build, TaskListener listener, SonarInstallation sonarInstallation, boolean isSkipped) throws IOException, InterruptedException {
        return SonarUtils.addBuildInfoFromLastBuildTo(build, listener, sonarInstallation, sonarInstallation.getCredentialsId(), isSkipped);
    }

    public static SonarAnalysisAction addBuildInfoFromLastBuildTo(Run<?, ?> build, TaskListener listener, SonarInstallation sonarInstallation, @Nullable String credentialId, boolean isSkipped) throws IOException, InterruptedException {
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild == null) {
            return SonarUtils.addEmptyBuildInfo(build, listener, sonarInstallation, credentialId, isSkipped);
        }
        for (SonarAnalysisAction analysis : previousBuild.getActions(SonarAnalysisAction.class)) {
            if (analysis.getUrl() == null || !analysis.getInstallationName().equals(sonarInstallation.getName())) continue;
            SonarAnalysisAction copy = new SonarAnalysisAction(analysis);
            copy.setSkipped(isSkipped);
            build.addAction((Action)copy);
            return copy;
        }
        return SonarUtils.addEmptyBuildInfo(build, listener, sonarInstallation, credentialId, isSkipped);
    }

    public static SonarAnalysisAction addEmptyBuildInfo(Run<?, ?> build, TaskListener listener, SonarInstallation sonarInstallation, @Nullable String credentialId, boolean isSkipped) throws IOException, InterruptedException {
        SonarAnalysisAction analysis = SonarUtils.createSonarAnalysisAction(sonarInstallation, credentialId, build, listener);
        analysis.setSkipped(isSkipped);
        build.addAction((Action)analysis);
        return analysis;
    }

    private static SonarAnalysisAction createSonarAnalysisAction(SonarInstallation sonarInstallation, @Nullable String credentialId, Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = BuilderUtils.getEnvAndBuildVars(build, listener);
        return new SonarAnalysisAction(sonarInstallation.getName(), credentialId, envVars.expand(sonarInstallation.getServerUrl()));
    }

    public static String getMavenGoal(String version) {
        Float majorMinor = SonarUtils.extractMajorMinor(version);
        if (majorMinor == null || (double)majorMinor.floatValue() >= 3.0) {
            return "org.sonarsource.scanner.maven:sonar-maven-plugin:" + version + ":sonar";
        }
        return "org.codehaus.mojo:sonar-maven-plugin:" + version + ":sonar";
    }

    @CheckForNull
    public static Float extractMajorMinor(String version) {
        Pattern p = Pattern.compile("\\d+\\.\\d+");
        Matcher m = p.matcher(version);
        if (m.find()) {
            return Float.valueOf(Float.parseFloat(m.group()));
        }
        return null;
    }

    @CheckForNull
    public static String getAuthenticationToken(Run<?, ?> build, SonarInstallation inst, @Nullable String credentialsId) {
        if (credentialsId == null) {
            return inst.getServerAuthenticationToken(build);
        }
        StringCredentials cred = SonarUtils.getCredentials(build, credentialsId);
        if (cred == null) {
            throw new IllegalStateException("Unable to find credential with id '" + credentialsId + "'");
        }
        return cred.getSecret().getPlainText();
    }

    public static StringCredentials getCredentials(Run<?, ?> build, String credentialsId) {
        return (StringCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StringCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
    }

    public static String getTokenProperty(SonarInstallation inst, HttpClient client) {
        try {
            if (!SonarUtils.isSonarCloud(inst) && SonarUtils.getVersion(inst, client).compareTo(new Version("10.0")) < 0) {
                return PROPERTY_SONAR_LOGIN;
            }
            return PROPERTY_SONAR_TOKEN;
        }
        catch (Exception e) {
            Logger.LOG.log(Level.WARNING, String.format("Failed to retrieve SonarQube instance version, '%s' is used by default", PROPERTY_SONAR_LOGIN), e);
            return PROPERTY_SONAR_LOGIN;
        }
    }

    public static Version getVersion(SonarInstallation inst, HttpClient client) {
        if (inst.getServerUrl() == null) {
            throw new IllegalStateException("No server url on installation: " + inst.getName());
        }
        WsClient wsClient = new WsClient(client, inst.getServerUrl(), null);
        return new Version(wsClient.getServerVersion());
    }

    public static boolean isSonarCloud(SonarInstallation inst) {
        return inst.getServerUrl() != null && inst.getServerUrl().startsWith(SONARCLOUD_URL);
    }
}

