/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.annotations.VisibleForTesting;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.OkHttpClientSingleton;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.MaskPasswordsOutputStream;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.security.ACL;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SonarBuildWrapper
extends SimpleBuildWrapper {
    private String installationName;
    private String credentialsId;
    private boolean envOnly = false;
    private HttpClient client;

    @DataBoundConstructor
    public SonarBuildWrapper(@Nullable String installationName) {
        this.installationName = installationName;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public boolean isEnvOnly() {
        return this.envOnly;
    }

    @DataBoundSetter
    public void setEnvOnly(boolean envOnly) {
        this.envOnly = envOnly;
    }

    protected HttpClient getClient() {
        if (this.client == null) {
            this.client = new HttpClient(OkHttpClientSingleton.getInstance());
        }
        return this.client;
    }

    @VisibleForTesting
    void setClient(HttpClient client) {
        this.client = client;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        SonarInstallation.checkValid(this.getInstallationName());
        SonarInstallation installation = SonarInstallation.get(this.getInstallationName());
        String msg = Messages.SonarBuildWrapper_Injecting(installation.getName());
        Logger.LOG.info(msg);
        listener.getLogger().println(msg);
        context.getEnv().putAll(SonarBuildWrapper.createVars(installation, this.getCredentialsId(), initialEnvironment, build, this.getClient()));
        if (this.envOnly) {
            return;
        }
        context.setDisposer((SimpleBuildWrapper.Disposer)new AddBuildInfo(installation, this.getCredentialsId()));
        build.addAction((Action)new SonarMarkerAction());
    }

    @VisibleForTesting
    static Map<String, String> createVars(SonarInstallation inst, @Nullable String credentialsId, EnvVars initialEnvironment, Run<?, ?> build, HttpClient client) {
        String additionalAnalysisProperties;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SONAR_CONFIG_NAME", inst.getName());
        String hostUrl = SonarBuildWrapper.getOrDefault(initialEnvironment.expand(inst.getServerUrl()), "http://localhost:9000");
        map.put("SONAR_HOST_URL", hostUrl);
        String token = SonarBuildWrapper.getOrDefault(SonarUtils.getAuthenticationToken(build, inst, credentialsId), "");
        map.put("SONAR_AUTH_TOKEN", token);
        String mojoVersion = inst.getMojoVersion();
        if (StringUtils.isEmpty((String)mojoVersion)) {
            map.put("SONAR_MAVEN_GOAL", "sonar:sonar");
        } else {
            map.put("SONAR_MAVEN_GOAL", SonarUtils.getMavenGoal(mojoVersion));
        }
        map.put("SONAR_EXTRA_PROPS", SonarBuildWrapper.getOrDefault(initialEnvironment.expand(SonarBuildWrapper.getAdditionalProps(inst)), ""));
        EnvVars.resolve(map);
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"sonar.host.url\" : \"").append(StringEscapeUtils.escapeJson((String)hostUrl)).append("\"");
        if (!token.isEmpty()) {
            sb.append(", \"").append(SonarUtils.getTokenProperty(inst, build, client)).append("\" : \"").append(StringEscapeUtils.escapeJson((String)token)).append("\"");
        }
        if ((additionalAnalysisProperties = inst.getAdditionalAnalysisProperties()) != null) {
            for (String pair : StringUtils.split((String)additionalAnalysisProperties)) {
                String[] keyValue = StringUtils.split((String)pair, (String)"=");
                if (keyValue.length != 2) continue;
                sb.append(", \"").append(StringEscapeUtils.escapeJson((String)keyValue[0])).append("\" : \"").append(StringEscapeUtils.escapeJson((String)initialEnvironment.expand(keyValue[1]))).append("\"");
            }
        }
        sb.append("}");
        map.put("SONARQUBE_SCANNER_PARAMS", sb.toString());
        return map;
    }

    private static String getAdditionalProps(SonarInstallation inst) {
        ArgumentListBuilder builder = new ArgumentListBuilder();
        builder.add(inst.getAdditionalAnalysisPropertiesUnix());
        builder.add(inst.getAdditionalProperties());
        return StringUtils.join((Collection)builder.toList(), (char)' ');
    }

    private static String getOrDefault(@Nullable String value, String defaultValue) {
        return !StringUtils.isEmpty((String)value) ? value : defaultValue;
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        SonarInstallation inst = SonarInstallation.get(this.getInstallationName());
        if (inst == null) {
            return null;
        }
        Logger.LOG.info(Messages.SonarBuildWrapper_MaskingPasswords());
        ArrayList<String> passwords = new ArrayList<String>();
        String token = SonarBuildWrapper.getOrDefault(SonarUtils.getAuthenticationToken(build, inst, this.credentialsId), "");
        if (!StringUtils.isBlank((String)token)) {
            passwords.add(token);
        }
        return new SonarQubePasswordLogFilter(passwords, build.getCharset().name());
    }

    @Nullable
    public String getInstallationName() {
        return this.installationName;
    }

    public void setInstallationName(@Nullable String installationName) {
        this.installationName = installationName;
    }

    private static final class AddBuildInfo
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private final SonarInstallation installation;
        private final String credentialsId;

        public AddBuildInfo(SonarInstallation installation, @Nullable String credentialsId) {
            this.installation = installation;
            this.credentialsId = credentialsId;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            SonarUtils.addBuildInfoTo(build, listener, workspace, this.installation, this.credentialsId, build.getResult() == null);
        }
    }

    private static class SonarQubePasswordLogFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> passwords;
        private final String consoleCharset;

        public SonarQubePasswordLogFilter(List<String> passwords, String consoleCharset) {
            this.passwords = passwords;
            this.consoleCharset = consoleCharset;
        }

        public OutputStream decorateLogger(Run ignore, OutputStream logger) throws IOException, InterruptedException {
            return new MaskPasswordsOutputStream(logger, Charset.forName(this.consoleCharset), this.passwords);
        }
    }

    @Symbol(value={"withSonarQubeEnv"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.SonarBuildWrapper_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            if (project == null) {
                project = new FreeStyleProject(Jenkins.getInstance(), "fake-" + UUID.randomUUID().toString());
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String value) {
            if (project == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always())) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return SonarGlobalConfiguration.get().isBuildWrapperEnabled();
        }

        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }

        public String getHelpFile() {
            return "/plugin/sonar/help-buildWrapper.html";
        }
    }
}

