/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.google.common.annotations.VisibleForTesting;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.JDK;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerInstallation;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.utils.BuilderUtils;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.plugins.sonar.utils.JenkinsRouter;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SonarRunnerBuilder
extends Builder {
    private String installationName;
    private String project;
    private String properties;
    private String javaOpts;
    private String additionalArguments;
    private String jdk;
    @Deprecated
    private transient String sonarRunnerName;
    private String sonarScannerName;
    private String task;

    @DataBoundConstructor
    public SonarRunnerBuilder() {
    }

    @Deprecated
    public SonarRunnerBuilder(String installationName, String sonarScannerName, String project, String properties, String javaOpts, String jdk, String task, String additionalArguments) {
        this.installationName = installationName;
        this.sonarScannerName = sonarScannerName;
        this.javaOpts = javaOpts;
        this.project = project;
        this.properties = properties;
        this.jdk = jdk;
        this.task = task;
        this.additionalArguments = additionalArguments;
    }

    public String getInstallationName() {
        return Util.fixNull((String)this.installationName);
    }

    @DataBoundSetter
    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    public String getSonarScannerName() {
        return Util.fixNull((String)this.sonarScannerName);
    }

    @DataBoundSetter
    public void setSonarScannerName(String sonarScannerName) {
        this.sonarScannerName = sonarScannerName;
    }

    @CheckForNull
    public JDK getJdkFromJenkins() {
        return Jenkins.getInstance().getJDK(this.jdk);
    }

    public String getJdk() {
        return this.jdk != null && !this.jdk.isEmpty() ? this.jdk : "(Inherit From Job)";
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public String getProject() {
        return Util.fixNull((String)this.project);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getProperties() {
        return Util.fixNull((String)this.properties);
    }

    @DataBoundSetter
    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getJavaOpts() {
        return Util.fixNull((String)this.javaOpts);
    }

    @DataBoundSetter
    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public String getAdditionalArguments() {
        return Util.fixNull((String)this.additionalArguments);
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public SonarInstallation getSonarInstallation() {
        return SonarInstallation.get(this.getInstallationName());
    }

    public String getTask() {
        return Util.fixNull((String)this.task);
    }

    @DataBoundSetter
    public void setTask(String task) {
        this.task = task;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SonarRunnerInstallation getSonarRunnerInstallation() {
        for (SonarRunnerInstallation sri : this.getDescriptor().getSonarRunnerInstallations()) {
            if (this.sonarScannerName == null || !this.sonarScannerName.equals(sri.getName())) continue;
            return sri;
        }
        if (this.getDescriptor().getSonarRunnerInstallations().length > 0) {
            return this.getDescriptor().getSonarRunnerInstallations()[0];
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("no workspace for " + build);
        }
        this.perform((Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
        return true;
    }

    private void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        int exitCode;
        if (!SonarInstallation.isValid(this.getInstallationName(), listener)) {
            throw new AbortException("Invalid SonarQube server installation");
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = BuilderUtils.getEnvAndBuildVars(run, listener);
        SonarRunnerInstallation sri = this.getSonarRunnerInstallation();
        if (sri == null) {
            args.add(launcher.isUnix() ? "sonar-scanner" : "sonar-scanner.bat");
        } else {
            String exe = (sri = BuilderUtils.getBuildTool(sri, env, listener, workspace)).getExecutable(launcher);
            if (exe == null) {
                Logger.printFailureMessage(listener);
                String msg = Messages.SonarScanner_ExecutableNotFound(sri.getName());
                listener.fatalError(msg);
                throw new AbortException(msg);
            }
            args.add(exe);
        }
        SonarInstallation sonarInst = this.getSonarInstallation();
        this.addTaskArgument(args);
        this.addAdditionalArguments(args, sonarInst);
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        this.populateConfiguration(argsBuilder, run, workspace, listener, env, sonarInst);
        this.computeJdkToUse(run, workspace, listener, env);
        env.put("SONAR_SCANNER_OPTS", this.getJavaOpts());
        env.put("SONAR_RUNNER_OPTS", this.getJavaOpts());
        long startTime = System.currentTimeMillis();
        try {
            exitCode = SonarRunnerBuilder.executeSonarQubeScanner(run, workspace, launcher, listener, args, env);
        }
        catch (IOException e) {
            this.handleErrors(listener, sri, startTime, e);
            exitCode = -1;
        }
        SonarUtils.addBuildInfoTo(run, listener, workspace, sonarInst);
        if (exitCode != 0) {
            throw new AbortException("SonarQube scanner exited with non-zero code: " + exitCode);
        }
    }

    private void handleErrors(TaskListener listener, @Nullable SonarRunnerInstallation sri, long startTime, IOException e) {
        Logger.printFailureMessage(listener);
        Util.displayIOException((IOException)e, (TaskListener)listener);
        Object errorMessage = Messages.SonarScanner_ExecFailed();
        if (sri == null && System.currentTimeMillis() - startTime < 1000L && this.getDescriptor().getSonarRunnerInstallations() == null) {
            errorMessage = (String)errorMessage + Messages.SonarScanner_GlobalConfigNeeded();
        }
        e.printStackTrace(listener.fatalError((String)errorMessage));
    }

    private static int executeSonarQubeScanner(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, ArgumentListBuilder args, EnvVars env) throws IOException, InterruptedException {
        return launcher.launch().cmds(args).envs((Map)env).stdout(listener).pwd(BuilderUtils.getModuleRoot(build, workspace)).join();
    }

    private static AbstractProject<?, ?> getProject(Run<?, ?> run) {
        AbstractProject project = null;
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            project = build.getProject();
        }
        return project;
    }

    private void computeJdkToUse(Run<?, ?> build, FilePath workspace, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        JDK jdkToUse = this.getJdkToUse(SonarRunnerBuilder.getProject(build));
        if (jdkToUse != null) {
            Computer computer = workspace.toComputer();
            if (computer != null) {
                jdkToUse = jdkToUse.forNode(computer.getNode(), listener);
            }
            jdkToUse.buildEnvVars(env);
        }
    }

    @VisibleForTesting
    void addAdditionalArguments(ArgumentListBuilder args, SonarInstallation inst) {
        args.addTokenized(inst.getAdditionalProperties());
        args.add(inst.getAdditionalAnalysisPropertiesUnix());
        args.addTokenized(this.additionalArguments);
    }

    private void addTaskArgument(ArgumentListBuilder args) {
        if (StringUtils.isNotBlank((String)this.getTask())) {
            args.add(this.task);
        }
    }

    @VisibleForTesting
    void populateConfiguration(ExtendedArgumentListBuilder args, Run<?, ?> build, FilePath workspace, TaskListener listener, EnvVars env, @Nullable SonarInstallation si) throws IOException, InterruptedException {
        if (si != null) {
            args.append("sonar.host.url", si.getServerUrl());
            String token = si.getServerAuthenticationToken(build);
            if (StringUtils.isNotBlank((String)token)) {
                args.appendMasked("sonar.login", token);
            }
        }
        if (StringUtils.isNotBlank((String)this.getProject())) {
            String projectSettingsFile = env.expand(this.getProject());
            FilePath projectSettingsFilePath = BuilderUtils.getModuleRoot(build, workspace).child(projectSettingsFile);
            if (!projectSettingsFilePath.exists()) {
                FilePath projectSettingsFilePath2 = workspace.child(projectSettingsFile);
                if (projectSettingsFilePath2.exists()) {
                    projectSettingsFilePath = projectSettingsFilePath2;
                } else {
                    String msg = "Unable to find SonarQube project settings at " + projectSettingsFilePath;
                    listener.fatalError(msg);
                    throw new AbortException(msg);
                }
            }
            args.append("project.settings", projectSettingsFilePath.getRemote());
        }
        Properties p = new Properties();
        p.load(new StringReader(env.expand(this.getProperties())));
        SonarRunnerBuilder.loadProperties(args, p);
        if (!p.containsKey("sonar.projectBaseDir")) {
            FilePath moduleRoot = BuilderUtils.getModuleRoot(build, workspace);
            args.append("sonar.projectBaseDir", moduleRoot.getRemote());
        }
    }

    private static void loadProperties(ExtendedArgumentListBuilder args, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            args.append(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private JDK getJdkToUse(@Nullable AbstractProject<?, ?> project) {
        JDK jdkToUse = this.getJdkFromJenkins();
        if (jdkToUse == null && project != null) {
            jdkToUse = project.getJDK();
        }
        return jdkToUse;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SonarMarkerAction();
    }

    protected Object readResolve() {
        if (this.sonarRunnerName != null) {
            this.sonarScannerName = this.sonarRunnerName;
        }
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final boolean BEFORE_V2 = JenkinsRouter.BEFORE_V2;

        public String getGlobalToolConfigUrl() {
            return JenkinsRouter.getGlobalToolConfigUrl();
        }

        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SonarScannerBuilder_DisplayName();
        }

        public SonarRunnerInstallation[] getSonarRunnerInstallations() {
            return ((SonarRunnerInstallation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(SonarRunnerInstallation.DescriptorImpl.class)).getInstallations();
        }
    }
}

