/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.AbstractMsBuildSQRunner;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.MsBuildSQRunnerInstallation;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.utils.BuilderUtils;
import hudson.plugins.sonar.utils.JenkinsRouter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MsBuildSQRunnerBegin
extends AbstractMsBuildSQRunner {
    @Deprecated
    private transient String msBuildRunnerInstallationName;
    private String msBuildScannerInstallationName;
    private String sonarInstallationName;
    private String projectKey;
    private String projectName;
    private String projectVersion;
    private String additionalArguments;

    @DataBoundConstructor
    public MsBuildSQRunnerBegin() {
    }

    @Deprecated
    public MsBuildSQRunnerBegin(String msBuildScannerInstallationName, String sonarInstallationName, String projectKey, String projectName, String projectVersion, String additionalArguments) {
        this.msBuildScannerInstallationName = msBuildScannerInstallationName;
        this.sonarInstallationName = sonarInstallationName;
        this.projectKey = projectKey;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.additionalArguments = additionalArguments;
    }

    @Override
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = BuilderUtils.getEnvAndBuildVars(run, listener);
        SonarInstallation sonarInstallation = MsBuildSQRunnerBegin.getSonarInstallation(this.getSonarInstallationName(), listener);
        MsBuildSQRunnerInstallation msBuildScanner = this.getDescriptor().getMsBuildScannerInstallation(this.msBuildScannerInstallationName);
        run.addAction((Action)new AbstractMsBuildSQRunner.SonarQubeScannerMsBuildParams(this.msBuildScannerInstallationName, this.getSonarInstallationName()));
        String scannerPath = this.getScannerPath(msBuildScanner, env, launcher, listener, workspace);
        if (this.isDotNetCoreTool(scannerPath).booleanValue()) {
            this.addDotNetCommand(args);
        }
        args.add(scannerPath);
        Map<String, String> props = MsBuildSQRunnerBegin.getSonarProps(sonarInstallation, run);
        this.addArgsTo(args, sonarInstallation, env, props);
        int result = launcher.launch().cmds(args).envs((Map)env).stdout(listener).pwd(BuilderUtils.getModuleRoot(run, workspace)).join();
        if (result != 0) {
            throw new AbortException(Messages.MSBuildScanner_ExecFailed(result));
        }
    }

    private static Map<String, String> getSonarProps(SonarInstallation inst, Run<?, ?> run) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("sonar.host.url", inst.getServerUrl());
        String token = inst.getServerAuthenticationToken(run);
        if (!StringUtils.isBlank((String)token)) {
            map.put("sonar.login", token);
        }
        return map;
    }

    private void addArgsTo(ArgumentListBuilder args, SonarInstallation sonarInst, EnvVars env, Map<String, String> props) {
        args.add("begin");
        args.add("/k:" + env.expand(this.projectKey));
        args.add("/n:" + env.expand(this.projectName));
        args.add("/v:" + env.expand(this.projectVersion));
        EnvVars.resolve(props);
        for (Map.Entry<String, String> e : props.entrySet()) {
            if (StringUtils.isEmpty((String)e.getValue())) continue;
            boolean hide = e.getKey().contains("sonar.login");
            args.addKeyValuePair("/d:", e.getKey(), env.expand(e.getValue()), hide);
        }
        args.add(sonarInst.getAdditionalAnalysisPropertiesWindows());
        args.addTokenized(sonarInst.getAdditionalProperties());
        args.addTokenized(env.expand(this.additionalArguments));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getProjectKey() {
        return Util.fixNull((String)this.projectKey);
    }

    @DataBoundSetter
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getProjectVersion() {
        return Util.fixNull((String)this.projectVersion);
    }

    @DataBoundSetter
    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectName() {
        return Util.fixNull((String)this.projectName);
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSonarInstallationName() {
        return Util.fixNull((String)this.sonarInstallationName);
    }

    @DataBoundSetter
    public void setSonarInstallationName(String sonarInstallationName) {
        this.sonarInstallationName = sonarInstallationName;
    }

    public String getMsBuildScannerInstallationName() {
        return Util.fixNull((String)this.msBuildScannerInstallationName);
    }

    @DataBoundSetter
    public void setMsBuildScannerInstallationName(String msBuildScannerInstallationName) {
        this.msBuildScannerInstallationName = msBuildScannerInstallationName;
    }

    public String getAdditionalArguments() {
        return Util.fixNull((String)this.additionalArguments);
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    protected Object readResolve() {
        if (this.msBuildRunnerInstallationName != null) {
            this.msBuildScannerInstallationName = Util.fixNull((String)this.msBuildRunnerInstallationName);
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final boolean BEFORE_V2 = JenkinsRouter.BEFORE_V2;

        public String getGlobalToolConfigUrl() {
            return JenkinsRouter.getGlobalToolConfigUrl();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/sonar/help-ms-build-sq-scanner-begin.html";
        }

        public String getDisplayName() {
            return Messages.MsBuildScannerBegin_DisplayName();
        }

        public FormValidation doCheckProjectKey(@QueryParameter String value) {
            return DescriptorImpl.checkNotEmpty(value);
        }

        private static FormValidation checkNotEmpty(String value) {
            if (!StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.SonarGlobalConfiguration_MandatoryProperty());
        }

        @Nullable
        public MsBuildSQRunnerInstallation getMsBuildScannerInstallation(@Nullable String name) {
            MsBuildSQRunnerInstallation[] msInst = this.getMsBuildScannerInstallations();
            if (StringUtils.isEmpty((String)name) && msInst.length > 0) {
                return msInst[0];
            }
            for (MsBuildSQRunnerInstallation inst : msInst) {
                if (!StringUtils.equals((String)name, (String)inst.getName())) continue;
                return inst;
            }
            return null;
        }

        public MsBuildSQRunnerInstallation[] getMsBuildScannerInstallations() {
            return (MsBuildSQRunnerInstallation[])((MsBuildSQRunnerInstallation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(MsBuildSQRunnerInstallation.DescriptorImpl.class)).getInstallations();
        }

        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }
    }
}

