/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private String versionStr;
    private int[] parts;

    public Version(String version) {
        Objects.requireNonNull(version, "Version can not be null");
        if (!version.matches("[0-9]+(\\.[0-9]+)+(.*)?")) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        this.versionStr = version;
        this.parse();
    }

    private void parse() {
        Pattern p = Pattern.compile("^[0-9]+(?:\\.[0-9]+)+");
        Matcher m = p.matcher(this.versionStr);
        if (!m.find()) {
            throw new IllegalArgumentException("Failed to parse version: " + this.versionStr);
        }
        String numbers = m.group(0);
        String[] partsStr = numbers.split("\\.");
        this.parts = new int[partsStr.length];
        for (int i = 0; i < partsStr.length; ++i) {
            this.parts[i] = Integer.parseInt(partsStr[i]);
        }
    }

    public final String get() {
        return this.versionStr;
    }

    public String toString() {
        return this.versionStr;
    }

    @Override
    public int compareTo(Version that) {
        int[] thisParts = this.parts;
        int[] thatParts = that.parts;
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? thisParts[i] : 0;
            int n = thatPart = i < thatParts.length ? thatParts[i] : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 17;
        boolean nonZero = false;
        for (int i = this.parts.length - 1; i >= 0; --i) {
            int part = this.parts[i];
            if (!nonZero && part != 0) {
                nonZero = true;
            }
            if (!nonZero) continue;
            hash = hash * 31 + part;
        }
        return hash;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }
}

