/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.jenkins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SonarQubeWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(SonarQubeWebHook.class.getName());
    public static final String URLNAME = "sonarqube-webhook";
    @VisibleForTesting
    List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @RequirePOST
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String payload = IOUtils.toString((Reader)req.getReader());
        LOGGER.info("Received POST from " + req.getRemoteHost());
        try {
            SonarQubeWebHook.validate(payload);
            LOGGER.fine(() -> "Full details of the POST was " + JSONObject.fromObject((Object)payload).toString());
            for (Listener listener : this.listeners) {
                listener.onTaskCompleted(new Payload(payload), req.getHeader("X-Sonar-Webhook-HMAC-SHA256"));
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, e, () -> "Invalid payload " + payload);
            rsp.sendError(400, "Invalid JSON Payload");
        }
        rsp.setStatus(200);
    }

    private static void validate(String payload) {
        JSONObject.fromObject((Object)payload);
    }

    public static SonarQubeWebHook get() {
        return (SonarQubeWebHook)Jenkins.get().getExtensionList(RootAction.class).get(SonarQubeWebHook.class);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    static final class Payload {
        private final String payloadAsString;
        private final String taskId;
        private final String taskStatus;
        private final String qualityGateStatus;

        Payload(String payloadAsString) {
            JSONObject json = JSONObject.fromObject((Object)payloadAsString);
            this.payloadAsString = payloadAsString;
            this.taskId = json.getString("taskId");
            this.taskStatus = json.getString("status");
            this.qualityGateStatus = "SUCCESS".equals(this.getTaskStatus()) ? (json.has("qualityGate") ? json.getJSONObject("qualityGate").getString("status") : "NONE") : null;
        }

        String getTaskId() {
            return this.taskId;
        }

        String getTaskStatus() {
            return this.taskStatus;
        }

        String getQualityGateStatus() {
            return this.qualityGateStatus;
        }

        String getPayloadAsString() {
            return this.payloadAsString;
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void onTaskCompleted(Payload var1, String var2);
    }
}

