/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.action;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.plugins.sonar.SonarBuildWrapper;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.action.SonarCacheAction;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.action.SonarProjectIconAction;
import hudson.plugins.sonar.action.SonarProjectPageAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.ProjectInformation;
import hudson.plugins.sonar.client.SQProjectResolver;
import hudson.plugins.sonar.utils.SonarUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.TransientActionFactory;

@Extension
public class SonarProjectActionFactory
extends TransientActionFactory<Job> {
    private SQProjectResolver resolver = new SQProjectResolver(new HttpClient());

    public Class<Job> type() {
        return Job.class;
    }

    public Collection<? extends Action> createFor(Job project) {
        HashSet<String> urls = new HashSet<String>();
        LinkedList<ProminentProjectAction> sonarProjectActions = new LinkedList<ProminentProjectAction>();
        LinkedList<SonarAnalysisAction> filteredActions = new LinkedList<SonarAnalysisAction>();
        Run lastBuild = project.getLastCompletedBuild();
        if (lastBuild != null) {
            for (SonarAnalysisAction a : lastBuild.getActions(SonarAnalysisAction.class)) {
                if (a.getUrl() == null || urls.contains(a.getUrl())) continue;
                urls.add(a.getUrl());
                sonarProjectActions.add(new SonarProjectIconAction(a));
                filteredActions.add(a);
            }
        }
        if (sonarProjectActions.isEmpty()) {
            if (SonarProjectActionFactory.projectHasSonarAnalysis(project)) {
                sonarProjectActions.add(new SonarProjectIconAction());
            }
        } else {
            SonarProjectPageAction projectPage = this.createProjectPage(lastBuild, filteredActions);
            if (projectPage != null) {
                sonarProjectActions.add(projectPage);
            }
        }
        return sonarProjectActions;
    }

    private static boolean projectHasSonarAnalysis(Job project) {
        if (project instanceof BuildableItemWithBuildWrappers) {
            for (Object wrapper : ((BuildableItemWithBuildWrappers)project).getBuildWrappersList()) {
                if (!(wrapper instanceof SonarBuildWrapper)) continue;
                return true;
            }
        }
        return !SonarUtils.getPersistentActions((Actionable)project, SonarMarkerAction.class).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private SonarProjectPageAction createProjectPage(Run<?, ?> run, List<SonarAnalysisAction> actions) {
        List<ProjectInformation> projects;
        long endTime = run.getStartTimeInMillis() + run.getDuration();
        Run<?, ?> run2 = run;
        synchronized (run2) {
            SonarCacheAction cache = SonarProjectActionFactory.getOrCreateCache(run);
            projects = cache.get(this.resolver, endTime, actions, run);
        }
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        return new SonarProjectPageAction(projects);
    }

    private static SonarCacheAction getOrCreateCache(Actionable actionable) {
        SonarCacheAction cache = SonarUtils.getPersistentAction(actionable, SonarCacheAction.class);
        if (cache == null) {
            cache = new SonarCacheAction();
            actionable.addAction((Action)cache);
        }
        return cache;
    }
}

