/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.action;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Run;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.action.SonarBuildBadgeAction;
import hudson.plugins.sonar.utils.SonarUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.TransientActionFactory;

@Extension
public class SonarBuildBadgeActionFactory
extends TransientActionFactory<Run> {
    public Class<Run> type() {
        return Run.class;
    }

    public Collection<? extends Action> createFor(Run run) {
        List<SonarAnalysisAction> actions = SonarUtils.getPersistentActions((Actionable)run, SonarAnalysisAction.class);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        String url = null;
        for (SonarAnalysisAction a : actions) {
            if (a.getUrl() == null) continue;
            if (url == null) {
                url = a.getUrl();
                continue;
            }
            if (url.equals(a.getUrl())) continue;
            url = null;
            break;
        }
        return Collections.singletonList(new SonarBuildBadgeAction(url));
    }
}

